/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.apache.hadoop.fs.FileUtil;

public class HardLink {
    public static OSType osType = HardLink.getOSType();
    private static HardLinkCommandGetter getHardLinkCommand;
    public final LinkStats linkStats = new LinkStats();

    private static OSType getOSType() {
        String osName = System.getProperty("os.name");
        if (osName.contains("Windows") && (osName.contains("XP") || osName.contains("2003") || osName.contains("Vista") || osName.contains("Windows_7") || osName.contains("Windows 7") || osName.contains("Windows7"))) {
            return OSType.OS_TYPE_WINXP;
        }
        if (osName.contains("SunOS") || osName.contains("Solaris")) {
            return OSType.OS_TYPE_SOLARIS;
        }
        if (osName.contains("Mac")) {
            return OSType.OS_TYPE_MAC;
        }
        return OSType.OS_TYPE_UNIX;
    }

    protected static int getLinkMultArgLength(File fileDir, String[] fileBaseNames, File linkDir) throws IOException {
        return getHardLinkCommand.getLinkMultArgLength(fileDir, fileBaseNames, linkDir);
    }

    protected static int getMaxAllowedCmdArgLength() {
        return getHardLinkCommand.getMaxAllowedCmdArgLength();
    }

    public static void createHardLink(File file, File linkName) throws IOException {
        if (file == null) {
            throw new IOException("invalid arguments to createHardLink: source file is null");
        }
        if (linkName == null) {
            throw new IOException("invalid arguments to createHardLink: link name is null");
        }
        String[] hardLinkCommand = getHardLinkCommand.linkOne(file, linkName);
        Process process = Runtime.getRuntime().exec(hardLinkCommand);
        try {
            if (process.waitFor() != 0) {
                String inpMsg;
                String errMsg = new BufferedReader(new InputStreamReader(process.getInputStream())).readLine();
                if (errMsg == null) {
                    errMsg = "";
                }
                if ((inpMsg = new BufferedReader(new InputStreamReader(process.getErrorStream())).readLine()) == null) {
                    inpMsg = "";
                }
                throw new IOException(errMsg + inpMsg);
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            process.destroy();
        }
    }

    public static void createHardLinkMult(File parentDir, String[] fileBaseNames, File linkDir) throws IOException {
        HardLink.createHardLinkMult(parentDir, fileBaseNames, linkDir, getHardLinkCommand.getMaxAllowedCmdArgLength());
    }

    protected static int createHardLinkMult(File parentDir, String[] fileBaseNames, File linkDir, int maxLength) throws IOException {
        if (parentDir == null) {
            throw new IOException("invalid arguments to createHardLinkMult: parent directory is null");
        }
        if (linkDir == null) {
            throw new IOException("invalid arguments to createHardLinkMult: link directory is null");
        }
        if (fileBaseNames == null) {
            throw new IOException("invalid arguments to createHardLinkMult: filename list can be empty but not null");
        }
        if (fileBaseNames.length == 0) {
            return 0;
        }
        if (!linkDir.exists()) {
            throw new FileNotFoundException(linkDir + " not found.");
        }
        int callCount = 0;
        if (HardLink.getLinkMultArgLength(parentDir, fileBaseNames, linkDir) > maxLength && fileBaseNames.length > 1) {
            String[] list1 = Arrays.copyOf(fileBaseNames, fileBaseNames.length / 2);
            callCount += HardLink.createHardLinkMult(parentDir, list1, linkDir, maxLength);
            String[] list2 = Arrays.copyOfRange(fileBaseNames, fileBaseNames.length / 2, fileBaseNames.length);
            return callCount += HardLink.createHardLinkMult(parentDir, list2, linkDir, maxLength);
        }
        callCount = 1;
        String[] hardLinkCommand = getHardLinkCommand.linkMult(fileBaseNames, linkDir);
        Process process = Runtime.getRuntime().exec(hardLinkCommand, null, parentDir);
        try {
            if (process.waitFor() != 0) {
                String inpMsg;
                String errMsg = new BufferedReader(new InputStreamReader(process.getInputStream())).readLine();
                if (errMsg == null) {
                    errMsg = "";
                }
                if ((inpMsg = new BufferedReader(new InputStreamReader(process.getErrorStream())).readLine()) == null) {
                    inpMsg = "";
                }
                throw new IOException(errMsg + inpMsg);
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            process.destroy();
        }
        return callCount;
    }

    public static int getLinkCount(File fileName) throws IOException {
        if (fileName == null) {
            throw new IOException("invalid argument to getLinkCount: file name is null");
        }
        if (!fileName.exists()) {
            throw new FileNotFoundException(fileName + " not found.");
        }
        String[] cmd = getHardLinkCommand.linkCount(fileName);
        String inpMsg = null;
        String errMsg = null;
        int exitValue = -1;
        BufferedReader in = null;
        BufferedReader err = null;
        Process process = Runtime.getRuntime().exec(cmd);
        try {
            exitValue = process.waitFor();
            in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            inpMsg = in.readLine();
            err = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            errMsg = err.readLine();
            if (inpMsg == null || exitValue != 0) {
                throw HardLink.createIOException(fileName, inpMsg, errMsg, exitValue, null);
            }
            if (osType == OSType.OS_TYPE_SOLARIS) {
                String[] result = inpMsg.split("\\s+");
                int n = Integer.parseInt(result[1]);
                return n;
            }
            int result = Integer.parseInt(inpMsg);
            return result;
        }
        catch (NumberFormatException e) {
            throw HardLink.createIOException(fileName, inpMsg, errMsg, exitValue, e);
        }
        catch (InterruptedException e) {
            throw HardLink.createIOException(fileName, inpMsg, errMsg, exitValue, e);
        }
        finally {
            process.destroy();
            if (in != null) {
                in.close();
            }
            if (err != null) {
                err.close();
            }
        }
    }

    private static IOException createIOException(File f, String message, String error2, int exitvalue, Exception cause) {
        String winErrMsg = "; Windows errors in getLinkCount are often due to Cygwin misconfiguration";
        String s = "Failed to get link count on file " + f + ": message=" + message + "; error=" + error2 + (osType == OSType.OS_TYPE_WINXP ? "; Windows errors in getLinkCount are often due to Cygwin misconfiguration" : "") + "; exit value=" + exitvalue;
        return cause == null ? new IOException(s) : new IOException(s, cause);
    }

    static {
        if (osType == OSType.OS_TYPE_WINXP) {
            getHardLinkCommand = new HardLinkCGWin();
        } else {
            getHardLinkCommand = new HardLinkCGUnix();
            if (osType == OSType.OS_TYPE_MAC) {
                String[] linkCountCmdTemplate = new String[]{"stat", "-f%l", null};
                HardLinkCGUnix.setLinkCountCmdTemplate(linkCountCmdTemplate);
            } else if (osType == OSType.OS_TYPE_SOLARIS) {
                String[] linkCountCmdTemplate = new String[]{"ls", "-l", null};
                HardLinkCGUnix.setLinkCountCmdTemplate(linkCountCmdTemplate);
            }
        }
    }

    public static class LinkStats {
        public int countDirs = 0;
        public int countSingleLinks = 0;
        public int countMultLinks = 0;
        public int countFilesMultLinks = 0;
        public int countEmptyDirs = 0;
        public int countPhysicalFileCopies = 0;

        public void clear() {
            this.countDirs = 0;
            this.countSingleLinks = 0;
            this.countMultLinks = 0;
            this.countFilesMultLinks = 0;
            this.countEmptyDirs = 0;
            this.countPhysicalFileCopies = 0;
        }

        public String report() {
            return "HardLinkStats: " + this.countDirs + " Directories, including " + this.countEmptyDirs + " Empty Directories, " + this.countSingleLinks + " single Link operations, " + this.countMultLinks + " multi-Link operations, linking " + this.countFilesMultLinks + " files, total " + (this.countSingleLinks + this.countFilesMultLinks) + " linkable files.  Also physically copied " + this.countPhysicalFileCopies + " other files.";
        }
    }

    static class HardLinkCGWin
    extends HardLinkCommandGetter {
        static String[] hardLinkCommand = new String[]{"fsutil", "hardlink", "create", null, null};
        static String[] hardLinkMultPrefix = new String[]{"cmd", "/q", "/c", "for", "%f", "in", "("};
        static String hardLinkMultDir = "\\%f";
        static String[] hardLinkMultSuffix = new String[]{")", "do", "fsutil", "hardlink", "create", null, "%f", "1>NUL"};
        static String[] getLinkCountCommand = new String[]{"stat", "-c%h", null};
        static final int maxAllowedCmdArgLength = 8127;

        HardLinkCGWin() {
        }

        @Override
        String[] linkOne(File file, File linkName) throws IOException {
            String[] buf = new String[hardLinkCommand.length];
            System.arraycopy(hardLinkCommand, 0, buf, 0, hardLinkCommand.length);
            buf[4] = file.getCanonicalPath();
            buf[3] = linkName.getCanonicalPath();
            return buf;
        }

        @Override
        String[] linkMult(String[] fileBaseNames, File linkDir) throws IOException {
            String[] buf = new String[fileBaseNames.length + hardLinkMultPrefix.length + hardLinkMultSuffix.length];
            String td = linkDir.getCanonicalPath() + hardLinkMultDir;
            int mark = 0;
            System.arraycopy(hardLinkMultPrefix, 0, buf, mark, hardLinkMultPrefix.length);
            System.arraycopy(fileBaseNames, 0, buf, mark += hardLinkMultPrefix.length, fileBaseNames.length);
            System.arraycopy(hardLinkMultSuffix, 0, buf, mark += fileBaseNames.length, hardLinkMultSuffix.length);
            buf[(mark += HardLinkCGWin.hardLinkMultSuffix.length) - 3] = td;
            return buf;
        }

        @Override
        String[] linkCount(File file) throws IOException {
            String[] buf = new String[getLinkCountCommand.length];
            System.arraycopy(getLinkCountCommand, 0, buf, 0, getLinkCountCommand.length);
            buf[HardLinkCGWin.getLinkCountCommand.length - 1] = file.getCanonicalPath();
            return buf;
        }

        @Override
        int getLinkMultArgLength(File fileDir, String[] fileBaseNames, File linkDir) throws IOException {
            int sum = 0;
            for (String x : fileBaseNames) {
                sum += 1 + (x == null ? 0 : x.length());
            }
            sum += 2 + fileDir.getCanonicalPath().length() + linkDir.getCanonicalPath().length();
            return sum += "cmd.exe /q /c for %f in ( ) do fsutil hardlink create \\%f %f 1>NUL ".length();
        }

        @Override
        int getMaxAllowedCmdArgLength() {
            return 8127;
        }
    }

    static class HardLinkCGUnix
    extends HardLinkCommandGetter {
        private static String[] hardLinkCommand = new String[]{"ln", null, null};
        private static String[] hardLinkMultPrefix = new String[]{"ln"};
        private static String[] hardLinkMultSuffix = new String[]{null};
        private static String[] getLinkCountCommand = new String[]{"stat", "-c%h", null};
        private static final int maxAllowedCmdArgLength = 32703;

        HardLinkCGUnix() {
        }

        private static synchronized void setLinkCountCmdTemplate(String[] template) {
            getLinkCountCommand = template;
        }

        @Override
        String[] linkOne(File file, File linkName) throws IOException {
            String[] buf = new String[hardLinkCommand.length];
            System.arraycopy(hardLinkCommand, 0, buf, 0, hardLinkCommand.length);
            buf[1] = FileUtil.makeShellPath(file, true);
            buf[2] = FileUtil.makeShellPath(linkName, true);
            return buf;
        }

        @Override
        String[] linkMult(String[] fileBaseNames, File linkDir) throws IOException {
            String[] buf = new String[fileBaseNames.length + hardLinkMultPrefix.length + hardLinkMultSuffix.length];
            int mark = 0;
            System.arraycopy(hardLinkMultPrefix, 0, buf, mark, hardLinkMultPrefix.length);
            System.arraycopy(fileBaseNames, 0, buf, mark += hardLinkMultPrefix.length, fileBaseNames.length);
            buf[mark += fileBaseNames.length] = FileUtil.makeShellPath(linkDir, true);
            return buf;
        }

        @Override
        String[] linkCount(File file) throws IOException {
            String[] buf = new String[getLinkCountCommand.length];
            System.arraycopy(getLinkCountCommand, 0, buf, 0, getLinkCountCommand.length);
            buf[HardLinkCGUnix.getLinkCountCommand.length - 1] = FileUtil.makeShellPath(file, true);
            return buf;
        }

        @Override
        int getLinkMultArgLength(File fileDir, String[] fileBaseNames, File linkDir) throws IOException {
            int sum = 0;
            for (String x : fileBaseNames) {
                sum += 1 + (x == null ? 0 : x.length());
            }
            sum += 2 + FileUtil.makeShellPath(fileDir, true).length() + FileUtil.makeShellPath(linkDir, true).length();
            return sum += 3;
        }

        @Override
        int getMaxAllowedCmdArgLength() {
            return 32703;
        }
    }

    private static abstract class HardLinkCommandGetter {
        private HardLinkCommandGetter() {
        }

        abstract String[] linkMult(String[] var1, File var2) throws IOException;

        abstract String[] linkOne(File var1, File var2) throws IOException;

        abstract String[] linkCount(File var1) throws IOException;

        abstract int getLinkMultArgLength(File var1, String[] var2, File var3) throws IOException;

        abstract int getMaxAllowedCmdArgLength();
    }

    public static enum OSType {
        OS_TYPE_UNIX,
        OS_TYPE_WINXP,
        OS_TYPE_SOLARIS,
        OS_TYPE_MAC;

    }
}

