/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.IndexRecord;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SpillRecord;

class IndexCache {
    private final JobConf conf;
    private final int totalMemoryAllowed;
    private AtomicInteger totalMemoryUsed = new AtomicInteger();
    private static final Log LOG = LogFactory.getLog(IndexCache.class);
    private final ConcurrentHashMap<String, IndexInformation> cache = new ConcurrentHashMap();
    private final LinkedBlockingQueue<String> queue = new LinkedBlockingQueue();

    public IndexCache(JobConf conf) {
        this.conf = conf;
        this.totalMemoryAllowed = conf.getInt("mapred.tasktracker.indexcache.mb", 10) * 1024 * 1024;
        LOG.info((Object)("IndexCache created with max memory = " + this.totalMemoryAllowed));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexRecord getIndexInformation(String mapId, int reduce, Path fileName, String expectedIndexOwner) throws IOException {
        IndexInformation info2 = this.cache.get(mapId);
        if (info2 == null) {
            info2 = this.readIndexFileToCache(fileName, mapId, expectedIndexOwner);
        } else {
            IndexInformation indexInformation = info2;
            synchronized (indexInformation) {
                while (null == info2.mapSpillRecord) {
                    try {
                        info2.wait();
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Interrupted waiting for construction", e);
                    }
                }
            }
            LOG.debug((Object)("IndexCache HIT: MapId " + mapId + " found"));
        }
        if (info2.mapSpillRecord.size() == 0 || info2.mapSpillRecord.size() < reduce) {
            throw new IOException("Invalid request  Map Id = " + mapId + " Reducer = " + reduce + " Index Info Length = " + info2.mapSpillRecord.size());
        }
        return info2.mapSpillRecord.getIndex(reduce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexInformation readIndexFileToCache(Path indexFileName, String mapId, String expectedIndexOwner) throws IOException {
        IndexInformation newInd = new IndexInformation();
        IndexInformation info2 = this.cache.putIfAbsent(mapId, newInd);
        if (info2 != null) {
            IndexInformation indexInformation = info2;
            synchronized (indexInformation) {
                while (null == info2.mapSpillRecord) {
                    try {
                        info2.wait();
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Interrupted waiting for construction", e);
                    }
                }
            }
            LOG.debug((Object)("IndexCache HIT: MapId " + mapId + " found"));
            return info2;
        }
        LOG.debug((Object)("IndexCache MISS: MapId " + mapId + " not found"));
        SpillRecord tmp = null;
        try {
            tmp = new SpillRecord(indexFileName, this.conf, expectedIndexOwner);
        }
        catch (Throwable e) {
            tmp = new SpillRecord(0);
            this.cache.remove(mapId);
            throw new IOException("Error Reading IndexFile", e);
        }
        finally {
            IndexInformation e = newInd;
            synchronized (e) {
                newInd.mapSpillRecord = tmp;
                newInd.notifyAll();
            }
        }
        this.queue.add(mapId);
        if (this.totalMemoryUsed.addAndGet(newInd.getSize()) > this.totalMemoryAllowed) {
            this.freeIndexInformation();
        }
        return newInd;
    }

    public void removeMap(String mapId) {
        IndexInformation info2 = this.cache.remove(mapId);
        if (info2 != null) {
            this.totalMemoryUsed.addAndGet(-info2.getSize());
            if (!this.queue.remove(mapId)) {
                LOG.warn((Object)("Map ID" + mapId + " not found in queue!!"));
            }
        } else {
            LOG.info((Object)("Map ID " + mapId + " not found in cache"));
        }
    }

    private synchronized void freeIndexInformation() {
        while (this.totalMemoryUsed.get() > this.totalMemoryAllowed) {
            String s = (String)this.queue.remove();
            IndexInformation info2 = this.cache.remove(s);
            if (info2 == null) continue;
            this.totalMemoryUsed.addAndGet(-info2.getSize());
        }
    }

    private static class IndexInformation {
        SpillRecord mapSpillRecord;

        private IndexInformation() {
        }

        int getSize() {
            return this.mapSpillRecord == null ? 0 : this.mapSpillRecord.size() * 24;
        }
    }
}

