/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.AuditLogger;
import org.apache.hadoop.mapred.CleanupQueue;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInfo;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.JobTrackerInstrumentation;
import org.apache.hadoop.mapred.JobTrackerStatistics;
import org.apache.hadoop.mapred.Operation;
import org.apache.hadoop.mapred.Queue;
import org.apache.hadoop.mapred.QueueMetrics;
import org.apache.hadoop.mapred.ResourceEstimator;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.DelegationTokenRenewal;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.server.jobtracker.TaskTracker;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.split.SplitMetaInfoReader;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.StringUtils;

public class JobInProgress {
    static final Log LOG = LogFactory.getLog(JobInProgress.class);
    JobProfile profile;
    JobStatus status;
    String jobFile = null;
    Path localJobFile = null;
    final QueueMetrics queueMetrics;
    TaskInProgress[] maps = new TaskInProgress[0];
    TaskInProgress[] reduces = new TaskInProgress[0];
    TaskInProgress[] cleanup = new TaskInProgress[0];
    TaskInProgress[] setup = new TaskInProgress[0];
    int numMapTasks = 0;
    int numReduceTasks = 0;
    final long memoryPerMap;
    final long memoryPerReduce;
    volatile int numSlotsPerMap = 1;
    volatile int numSlotsPerReduce = 1;
    final int maxTaskFailuresPerTracker;
    int runningMapTasks = 0;
    int runningReduceTasks = 0;
    int finishedMapTasks = 0;
    int finishedReduceTasks = 0;
    int failedMapTasks = 0;
    int failedReduceTasks = 0;
    private static long DEFAULT_REDUCE_INPUT_LIMIT = -1L;
    long reduce_input_limit = -1L;
    private static float DEFAULT_COMPLETED_MAPS_PERCENT_FOR_REDUCE_SLOWSTART = 0.05f;
    int completedMapsForReduceSlowstart = 0;
    int speculativeMapTasks = 0;
    int speculativeReduceTasks = 0;
    final int mapFailuresPercent;
    final int reduceFailuresPercent;
    int failedMapTIPs = 0;
    int failedReduceTIPs = 0;
    private volatile boolean launchedCleanup = false;
    private volatile boolean launchedSetup = false;
    private volatile boolean jobKilled = false;
    private volatile boolean jobFailed = false;
    JobPriority priority = JobPriority.NORMAL;
    final JobTracker jobtracker;
    protected Credentials tokenStorage;
    Map<Node, List<TaskInProgress>> nonRunningMapCache;
    Map<Node, Set<TaskInProgress>> runningMapCache;
    final List<TaskInProgress> nonLocalMaps;
    final SortedSet<TaskInProgress> failedMaps;
    Set<TaskInProgress> nonLocalRunningMaps;
    Set<TaskInProgress> nonRunningReduces;
    Set<TaskInProgress> runningReduces;
    List<TaskAttemptID> mapCleanupTasks = new LinkedList<TaskAttemptID>();
    List<TaskAttemptID> reduceCleanupTasks = new LinkedList<TaskAttemptID>();
    private static final Comparator<TaskInProgress> failComparator = new Comparator<TaskInProgress>(){

        @Override
        public int compare(TaskInProgress t1, TaskInProgress t2) {
            if (t1 == null) {
                return -1;
            }
            if (t2 == null) {
                return 1;
            }
            int failures = t2.numTaskFailures() - t1.numTaskFailures();
            return failures == 0 ? t1.getTIPId().getId() - t2.getTIPId().getId() : failures;
        }
    };
    private final int maxLevel;
    private final int anyCacheLevel;
    private volatile long numSchedulingOpportunities;
    static String LOCALITY_WAIT_FACTOR = "mapreduce.job.locality.wait.factor";
    static final float DEFAULT_LOCALITY_WAIT_FACTOR = 1.0f;
    private float localityWaitFactor = 1.0f;
    private static final int NON_LOCAL_CACHE_LEVEL = -1;
    private int taskCompletionEventTracker = 0;
    List<TaskCompletionEvent> taskCompletionEvents;
    private static final double CLUSTER_BLACKLIST_PERCENT = 0.25;
    private static final double MAX_ALLOWED_FETCH_FAILURES_PERCENT = 0.5;
    private volatile int clusterSize = 0;
    private volatile int flakyTaskTrackers = 0;
    private Map<String, Integer> trackerToFailuresMap = new TreeMap<String, Integer>();
    private ResourceEstimator resourceEstimator;
    long startTime;
    long launchTime;
    long finishTime;
    final Map<TaskType, Long> firstTaskLaunchTimes = new EnumMap<TaskType, Long>(TaskType.class);
    private final int restartCount;
    private JobConf conf;
    volatile boolean tasksInited = false;
    private JobInitKillStatus jobInitKillStatus = new JobInitKillStatus();
    private LocalFileSystem localFs;
    private FileSystem fs;
    private JobID jobId;
    private volatile boolean hasSpeculativeMaps;
    private volatile boolean hasSpeculativeReduces;
    private long inputLength = 0L;
    private String submitHostName;
    private String submitHostAddress;
    private String user;
    private String historyFile = "";
    private boolean historyFileCopied;
    private Counters jobCounters = new Counters();
    private static final int MAX_FETCH_FAILURES_NOTIFICATIONS = 3;
    private Map<TaskAttemptID, Integer> mapTaskIdToFetchFailuresMap = new TreeMap<TaskAttemptID, Integer>();
    private Object schedulingInfo;
    private Map<TaskTracker, FallowSlotInfo> trackersReservedForMaps = new HashMap<TaskTracker, FallowSlotInfo>();
    private Map<TaskTracker, FallowSlotInfo> trackersReservedForReduces = new HashMap<TaskTracker, FallowSlotInfo>();
    private Path jobSubmitDir = null;
    private final UserGroupInformation userUGI;
    private static final long OVERRIDE = 1000000L;

    protected JobInProgress(JobID jobid, JobConf conf, JobTracker tracker) throws IOException {
        this.conf = conf;
        this.jobId = jobid;
        this.numMapTasks = conf.getNumMapTasks();
        this.numReduceTasks = conf.getNumReduceTasks();
        this.maxLevel = 2;
        this.anyCacheLevel = this.maxLevel + 1;
        this.jobtracker = tracker;
        this.restartCount = 0;
        this.hasSpeculativeMaps = conf.getMapSpeculativeExecution();
        this.hasSpeculativeReduces = conf.getReduceSpeculativeExecution();
        this.nonLocalMaps = new LinkedList<TaskInProgress>();
        this.failedMaps = new TreeSet<TaskInProgress>(failComparator);
        this.nonLocalRunningMaps = new LinkedHashSet<TaskInProgress>();
        this.runningMapCache = new IdentityHashMap<Node, Set<TaskInProgress>>();
        this.nonRunningReduces = new TreeSet<TaskInProgress>(failComparator);
        this.runningReduces = new LinkedHashSet<TaskInProgress>();
        this.resourceEstimator = new ResourceEstimator(this);
        this.status = new JobStatus(jobid, 0.0f, 0.0f, 4);
        this.status.setUsername(conf.getUser());
        String queueName = conf.getQueueName();
        this.profile = new JobProfile(conf.getUser(), jobid, "", "", conf.getJobName(), queueName);
        this.memoryPerMap = conf.getMemoryForMapTask();
        this.memoryPerReduce = conf.getMemoryForReduceTask();
        this.maxTaskFailuresPerTracker = conf.getMaxTaskFailuresPerTracker();
        this.mapFailuresPercent = conf.getMaxMapTaskFailuresPercent();
        this.reduceFailuresPercent = conf.getMaxReduceTaskFailuresPercent();
        Queue queue = this.jobtracker.getQueueManager().getQueue(queueName);
        if (queue == null) {
            throw new IOException("Queue \"" + queueName + "\" does not exist");
        }
        this.queueMetrics = queue.getMetrics();
        this.checkTaskLimits();
        this.taskCompletionEvents = new ArrayList<TaskCompletionEvent>(this.numMapTasks + this.numReduceTasks + 10);
        try {
            this.userUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            throw new RuntimeException(ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobInProgress(JobTracker jobtracker, final JobConf default_conf, JobInfo jobInfo, int rCount, Credentials ts) throws IOException, InterruptedException {
        try {
            this.restartCount = rCount;
            this.jobId = JobID.downgrade(jobInfo.getJobID());
            String url = "http://" + jobtracker.getJobTrackerMachine() + ":" + jobtracker.getInfoPort() + "/jobdetails.jsp?jobid=" + this.jobId;
            this.jobtracker = jobtracker;
            this.status = new JobStatus(this.jobId, 0.0f, 0.0f, 4);
            this.status.setUsername(jobInfo.getUser().toString());
            this.jobtracker.getInstrumentation().addPrepJob(this.conf, this.jobId);
            this.startTime = jobtracker.getClock().getTime();
            this.status.setStartTime(this.startTime);
            this.localFs = jobtracker.getLocalFileSystem();
            this.tokenStorage = ts;
            this.jobSubmitDir = jobInfo.getJobSubmitDir();
            this.user = jobInfo.getUser().toString();
            this.userUGI = UserGroupInformation.createRemoteUser(this.user);
            if (ts != null) {
                for (Token<? extends TokenIdentifier> token : ts.getAllTokens()) {
                    this.userUGI.addToken(token);
                }
            }
            this.fs = this.userUGI.doAs(new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws IOException {
                    return JobInProgress.this.jobSubmitDir.getFileSystem(default_conf);
                }
            });
            Path submitJobFile = JobSubmissionFiles.getJobConfPath(this.jobSubmitDir);
            FileStatus fstatus = this.fs.getFileStatus(submitJobFile);
            if (fstatus.getLen() > jobtracker.MAX_JOBCONF_SIZE) {
                throw new IOException("Exceeded max jobconf size: " + fstatus.getLen() + " limit: " + jobtracker.MAX_JOBCONF_SIZE);
            }
            this.localJobFile = default_conf.getLocalPath("jobTracker/" + this.jobId + ".xml");
            Path jobFilePath = JobSubmissionFiles.getJobConfPath(this.jobSubmitDir);
            this.jobFile = jobFilePath.toString();
            this.fs.copyToLocalFile(jobFilePath, this.localJobFile);
            this.conf = new JobConf(this.localJobFile);
            if (this.conf.getUser() == null) {
                this.conf.setUser(this.user);
            }
            if (!this.conf.getUser().equals(this.user)) {
                String desc = "The username " + this.conf.getUser() + " obtained from the " + "conf doesn't match the username " + this.user + " the user " + "authenticated as";
                AuditLogger.logFailure(this.user, Operation.SUBMIT_JOB.name(), this.conf.getUser(), this.jobId.toString(), desc);
                throw new IOException(desc);
            }
            this.priority = this.conf.getJobPriority();
            this.status.setJobPriority(this.priority);
            String queueName = this.conf.getQueueName();
            this.profile = new JobProfile(this.user, this.jobId, this.jobFile, url, this.conf.getJobName(), queueName);
            Queue queue = this.jobtracker.getQueueManager().getQueue(queueName);
            if (queue == null) {
                throw new IOException("Queue \"" + queueName + "\" does not exist");
            }
            this.queueMetrics = queue.getMetrics();
            this.queueMetrics.addPrepJob(this.conf, this.jobId);
            this.submitHostName = this.conf.getJobSubmitHostName();
            this.submitHostAddress = this.conf.getJobSubmitHostAddress();
            this.numMapTasks = this.conf.getNumMapTasks();
            this.numReduceTasks = this.conf.getNumReduceTasks();
            this.memoryPerMap = this.conf.getMemoryForMapTask();
            this.memoryPerReduce = this.conf.getMemoryForReduceTask();
            this.taskCompletionEvents = new ArrayList<TaskCompletionEvent>(this.numMapTasks + this.numReduceTasks + 10);
            this.status.setJobACLs(jobtracker.getJobACLsManager().constructJobACLs(this.conf));
            this.mapFailuresPercent = this.conf.getMaxMapTaskFailuresPercent();
            this.reduceFailuresPercent = this.conf.getMaxReduceTaskFailuresPercent();
            this.maxTaskFailuresPerTracker = this.conf.getMaxTaskFailuresPerTracker();
            this.hasSpeculativeMaps = this.conf.getMapSpeculativeExecution();
            this.hasSpeculativeReduces = this.conf.getReduceSpeculativeExecution();
            this.reduce_input_limit = -1L;
            this.maxLevel = jobtracker.getNumTaskCacheLevels();
            this.anyCacheLevel = this.maxLevel + 1;
            this.nonLocalMaps = new LinkedList<TaskInProgress>();
            this.failedMaps = new TreeSet<TaskInProgress>(failComparator);
            this.nonLocalRunningMaps = new LinkedHashSet<TaskInProgress>();
            this.runningMapCache = new IdentityHashMap<Node, Set<TaskInProgress>>();
            this.nonRunningReduces = new TreeSet<TaskInProgress>(failComparator);
            this.runningReduces = new LinkedHashSet<TaskInProgress>();
            this.resourceEstimator = new ResourceEstimator(this);
            this.reduce_input_limit = this.conf.getLong("mapreduce.reduce.input.limit", DEFAULT_REDUCE_INPUT_LIMIT);
            DelegationTokenRenewal.registerDelegationTokensForRenewal(jobInfo.getJobID(), ts, jobtracker.getConf());
            this.checkTaskLimits();
        }
        finally {
            FileSystem.closeAllForUGI(UserGroupInformation.getCurrentUser());
        }
    }

    public QueueMetrics getQueueMetrics() {
        return this.queueMetrics;
    }

    private void checkTaskLimits() throws IOException {
        int maxTasks = this.jobtracker.getMaxTasksPerJob();
        LOG.info((Object)(this.jobId + ": nMaps=" + this.numMapTasks + " nReduces=" + this.numReduceTasks + " max=" + maxTasks));
        if (maxTasks > 0 && this.numMapTasks + this.numReduceTasks > maxTasks) {
            throw new IOException("The number of tasks for this job " + (this.numMapTasks + this.numReduceTasks) + " exceeds the configured limit " + maxTasks);
        }
    }

    public void cleanUpMetrics() {
    }

    private void printCache(Map<Node, List<TaskInProgress>> cache) {
        LOG.info((Object)"The taskcache info:");
        for (Map.Entry<Node, List<TaskInProgress>> n : cache.entrySet()) {
            List<TaskInProgress> tips = n.getValue();
            LOG.info((Object)("Cached TIPs on node: " + n.getKey()));
            for (TaskInProgress tip : tips) {
                LOG.info((Object)("tip : " + tip.getTIPId()));
            }
        }
    }

    private Map<Node, List<TaskInProgress>> createCache(JobSplit.TaskSplitMetaInfo[] splits, int maxLevel) throws UnknownHostException {
        IdentityHashMap<Node, List<TaskInProgress>> cache = new IdentityHashMap<Node, List<TaskInProgress>>(maxLevel);
        TreeSet<String> uniqueHosts = new TreeSet<String>();
        for (int i = 0; i < splits.length; ++i) {
            String[] splitLocations = splits[i].getLocations();
            if (splitLocations == null || splitLocations.length == 0) {
                this.nonLocalMaps.add(this.maps[i]);
                continue;
            }
            for (String host : splitLocations) {
                Node node = this.jobtracker.resolveAndAddToTopology(host);
                uniqueHosts.add(host);
                LOG.info((Object)("tip:" + this.maps[i].getTIPId() + " has split on node:" + node));
                for (int j = 0; j < maxLevel; ++j) {
                    ArrayList<TaskInProgress> hostMaps = (ArrayList<TaskInProgress>)cache.get(node);
                    if (hostMaps == null) {
                        hostMaps = new ArrayList<TaskInProgress>();
                        cache.put(node, hostMaps);
                        hostMaps.add(this.maps[i]);
                    }
                    if (hostMaps.get(hostMaps.size() - 1) != this.maps[i]) {
                        hostMaps.add(this.maps[i]);
                    }
                    node = node.getParent();
                }
            }
        }
        if (this.localityWaitFactor == 1.0f) {
            int jobNodes = uniqueHosts.size();
            int clusterNodes = this.jobtracker.getNumberOfUniqueHosts();
            if (clusterNodes > 0) {
                this.localityWaitFactor = Math.min((float)jobNodes / (float)clusterNodes, this.localityWaitFactor);
            }
            LOG.info((Object)(this.jobId + " LOCALITY_WAIT_FACTOR=" + this.localityWaitFactor));
        }
        return cache;
    }

    public boolean inited() {
        return this.tasksInited;
    }

    public String getUser() {
        return this.user;
    }

    boolean hasRestarted() {
        return this.restartCount > 0;
    }

    boolean getMapSpeculativeExecution() {
        return this.hasSpeculativeMaps;
    }

    boolean getReduceSpeculativeExecution() {
        return this.hasSpeculativeReduces;
    }

    long getMemoryForMapTask() {
        return this.memoryPerMap;
    }

    long getMemoryForReduceTask() {
        return this.memoryPerReduce;
    }

    int getNumSlotsPerMap() {
        return this.numSlotsPerMap;
    }

    void setNumSlotsPerMap(int numSlotsPerMap) {
        this.numSlotsPerMap = numSlotsPerMap;
    }

    int getNumSlotsPerReduce() {
        return this.numSlotsPerReduce;
    }

    void setNumSlotsPerReduce(int numSlotsPerReduce) {
        this.numSlotsPerReduce = numSlotsPerReduce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initTasks() throws IOException, KillInterruptedException, UnknownHostException {
        int i;
        if (this.tasksInited || this.isComplete()) {
            return;
        }
        JobInitKillStatus jobInitKillStatus = this.jobInitKillStatus;
        synchronized (jobInitKillStatus) {
            if (this.jobInitKillStatus.killed || this.jobInitKillStatus.initStarted) {
                return;
            }
            this.jobInitKillStatus.initStarted = true;
        }
        LOG.info((Object)("Initializing " + this.jobId));
        final long startTimeFinal = this.startTime;
        try {
            this.userUGI.doAs(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    JobHistory.JobInfo.logSubmitted(JobInProgress.this.getJobID(), JobInProgress.this.conf, JobInProgress.this.jobFile, startTimeFinal, JobInProgress.this.hasRestarted());
                    return null;
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        this.setPriority(this.priority);
        this.generateAndStoreTokens();
        JobSplit.TaskSplitMetaInfo[] splits = this.createSplits(this.jobId);
        if (this.numMapTasks != splits.length) {
            throw new IOException("Number of maps in JobConf doesn't match number of recieved splits for job " + this.jobId + "! " + "numMapTasks=" + this.numMapTasks + ", #splits=" + splits.length);
        }
        this.numMapTasks = splits.length;
        for (JobSplit.TaskSplitMetaInfo split : splits) {
            NetUtils.verifyHostnames(split.getLocations());
        }
        this.jobtracker.getInstrumentation().addWaitingMaps(this.getJobID(), this.numMapTasks);
        this.jobtracker.getInstrumentation().addWaitingReduces(this.getJobID(), this.numReduceTasks);
        this.queueMetrics.addWaitingMaps(this.getJobID(), this.numMapTasks);
        this.queueMetrics.addWaitingReduces(this.getJobID(), this.numReduceTasks);
        this.maps = new TaskInProgress[this.numMapTasks];
        for (i = 0; i < this.numMapTasks; ++i) {
            this.inputLength += splits[i].getInputDataLength();
            this.maps[i] = new TaskInProgress(this.jobId, this.jobFile, splits[i], this.jobtracker, this.conf, this, i, this.numSlotsPerMap);
        }
        LOG.info((Object)("Input size for job " + this.jobId + " = " + this.inputLength + ". Number of splits = " + splits.length));
        this.localityWaitFactor = this.conf.getFloat(LOCALITY_WAIT_FACTOR, 1.0f);
        if (this.numMapTasks > 0) {
            this.nonRunningMapCache = this.createCache(splits, this.maxLevel);
        }
        this.launchTime = this.jobtracker.getClock().getTime();
        this.reduces = new TaskInProgress[this.numReduceTasks];
        for (i = 0; i < this.numReduceTasks; ++i) {
            this.reduces[i] = new TaskInProgress(this.jobId, this.jobFile, this.numMapTasks, i, this.jobtracker, this.conf, this, this.numSlotsPerReduce);
            this.nonRunningReduces.add(this.reduces[i]);
        }
        this.completedMapsForReduceSlowstart = (int)Math.ceil(this.conf.getFloat("mapred.reduce.slowstart.completed.maps", DEFAULT_COMPLETED_MAPS_PERCENT_FOR_REDUCE_SLOWSTART) * (float)this.numMapTasks);
        this.resourceEstimator.setThreshhold(this.completedMapsForReduceSlowstart);
        this.cleanup = new TaskInProgress[2];
        JobSplit.TaskSplitMetaInfo emptySplit = JobSplit.EMPTY_TASK_SPLIT;
        this.cleanup[0] = new TaskInProgress(this.jobId, this.jobFile, emptySplit, this.jobtracker, this.conf, this, this.numMapTasks, 1);
        this.cleanup[0].setJobCleanupTask();
        this.cleanup[1] = new TaskInProgress(this.jobId, this.jobFile, this.numMapTasks, this.numReduceTasks, this.jobtracker, this.conf, this, 1);
        this.cleanup[1].setJobCleanupTask();
        this.setup = new TaskInProgress[2];
        this.setup[0] = new TaskInProgress(this.jobId, this.jobFile, emptySplit, this.jobtracker, this.conf, this, this.numMapTasks + 1, 1);
        this.setup[0].setJobSetupTask();
        this.setup[1] = new TaskInProgress(this.jobId, this.jobFile, this.numMapTasks, this.numReduceTasks + 1, this.jobtracker, this.conf, this, 1);
        this.setup[1].setJobSetupTask();
        JobInitKillStatus jobInitKillStatus2 = this.jobInitKillStatus;
        synchronized (jobInitKillStatus2) {
            this.jobInitKillStatus.initDone = true;
            if (this.jobInitKillStatus.killed) {
                throw new KillInterruptedException("Job " + this.jobId + " killed in init");
            }
        }
        this.tasksInited = true;
        JobHistory.JobInfo.logInited(this.profile.getJobID(), this.launchTime, this.numMapTasks, this.numReduceTasks);
        LOG.info((Object)("Job " + this.jobId + " initialized successfully with " + this.numMapTasks + " map tasks and " + this.numReduceTasks + " reduce tasks."));
    }

    JobSplit.TaskSplitMetaInfo[] createSplits(org.apache.hadoop.mapreduce.JobID jobId) throws IOException {
        JobSplit.TaskSplitMetaInfo[] allTaskSplitMetaInfo = SplitMetaInfoReader.readSplitMetaInfo(jobId, this.fs, this.jobtracker.getConf(), this.jobSubmitDir);
        return allTaskSplitMetaInfo;
    }

    public JobProfile getProfile() {
        return this.profile;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public synchronized long getLaunchTime() {
        return this.launchTime;
    }

    Map<TaskType, Long> getFirstTaskLaunchTimes() {
        return this.firstTaskLaunchTimes;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public int desiredMaps() {
        return this.numMapTasks;
    }

    public synchronized int finishedMaps() {
        return this.finishedMapTasks;
    }

    public int desiredReduces() {
        return this.numReduceTasks;
    }

    public synchronized int runningMaps() {
        return this.runningMapTasks;
    }

    public synchronized int runningReduces() {
        return this.runningReduceTasks;
    }

    public synchronized int finishedReduces() {
        return this.finishedReduceTasks;
    }

    public synchronized int pendingMaps() {
        return this.numMapTasks - this.runningMapTasks - this.failedMapTIPs - this.finishedMapTasks + this.speculativeMapTasks;
    }

    public synchronized int pendingReduces() {
        return this.numReduceTasks - this.runningReduceTasks - this.failedReduceTIPs - this.finishedReduceTasks + this.speculativeReduceTasks;
    }

    public int desiredTasks() {
        return this.desiredMaps() + this.desiredReduces();
    }

    public int getNumSlotsPerTask(TaskType taskType) {
        if (taskType == TaskType.MAP) {
            return this.numSlotsPerMap;
        }
        if (taskType == TaskType.REDUCE) {
            return this.numSlotsPerReduce;
        }
        return 1;
    }

    public JobPriority getPriority() {
        return this.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(JobPriority priority) {
        this.priority = priority == null ? JobPriority.NORMAL : priority;
        JobInProgress jobInProgress = this;
        synchronized (jobInProgress) {
            this.status.setJobPriority(priority);
        }
        JobHistory.JobInfo.logJobPriority(this.jobId, priority);
    }

    synchronized void updateJobInfo(long startTime, long launchTime) {
        this.startTime = startTime;
        this.launchTime = launchTime;
        JobHistory.JobInfo.logJobInfo(this.jobId, startTime, launchTime);
    }

    int getNumRestarts() {
        return this.restartCount;
    }

    long getInputLength() {
        return this.inputLength;
    }

    boolean isCleanupLaunched() {
        return this.launchedCleanup;
    }

    boolean isSetupLaunched() {
        return this.launchedSetup;
    }

    TaskInProgress[] getTasks(TaskType type) {
        TaskInProgress[] tasks = null;
        switch (type) {
            case MAP: {
                tasks = this.maps;
                break;
            }
            case REDUCE: {
                tasks = this.reduces;
                break;
            }
            case JOB_SETUP: {
                tasks = this.setup;
                break;
            }
            case JOB_CLEANUP: {
                tasks = this.cleanup;
                break;
            }
            default: {
                tasks = new TaskInProgress[]{};
            }
        }
        return tasks;
    }

    Set<TaskInProgress> getNonLocalRunningMaps() {
        return this.nonLocalRunningMaps;
    }

    Map<Node, Set<TaskInProgress>> getRunningMapCache() {
        return this.runningMapCache;
    }

    Set<TaskInProgress> getRunningReduces() {
        return this.runningReduces;
    }

    JobConf getJobConf() {
        return this.conf;
    }

    public synchronized Vector<TaskInProgress> reportTasksInProgress(boolean shouldBeMap, boolean shouldBeComplete) {
        Vector<TaskInProgress> results = new Vector<TaskInProgress>();
        TaskInProgress[] tips = null;
        tips = shouldBeMap ? this.maps : this.reduces;
        for (int i = 0; i < tips.length; ++i) {
            if (tips[i].isComplete() != shouldBeComplete) continue;
            results.add(tips[i]);
        }
        return results;
    }

    public synchronized Vector<TaskInProgress> reportCleanupTIPs(boolean shouldBeComplete) {
        Vector<TaskInProgress> results = new Vector<TaskInProgress>();
        for (int i = 0; i < this.cleanup.length; ++i) {
            if (this.cleanup[i].isComplete() != shouldBeComplete) continue;
            results.add(this.cleanup[i]);
        }
        return results;
    }

    public synchronized Vector<TaskInProgress> reportSetupTIPs(boolean shouldBeComplete) {
        Vector<TaskInProgress> results = new Vector<TaskInProgress>();
        for (int i = 0; i < this.setup.length; ++i) {
            if (this.setup[i].isComplete() != shouldBeComplete) continue;
            results.add(this.setup[i]);
        }
        return results;
    }

    public synchronized void updateTaskStatus(TaskInProgress tip, TaskStatus status) {
        boolean change;
        double oldProgress = tip.getProgress();
        boolean wasRunning = tip.isRunning();
        boolean wasComplete = tip.isComplete();
        boolean wasPending = tip.isOnlyCommitPending();
        TaskAttemptID taskid = status.getTaskID();
        boolean wasAttemptRunning = tip.isAttemptRunning(taskid);
        if ((wasComplete || tip.wasKilled(taskid)) && status.getRunState() == TaskStatus.State.SUCCEEDED) {
            status.setRunState(TaskStatus.State.KILLED);
        }
        if ((this.isComplete() || this.jobFailed || this.jobKilled) && !tip.isCleanupAttempt(taskid)) {
            if (status.getRunState() == TaskStatus.State.FAILED_UNCLEAN) {
                status.setRunState(TaskStatus.State.FAILED);
            } else if (status.getRunState() == TaskStatus.State.KILLED_UNCLEAN) {
                status.setRunState(TaskStatus.State.KILLED);
            }
        }
        if (change = tip.updateStatus(status)) {
            TaskStatus.State state = status.getRunState();
            TaskTracker taskTracker = this.jobtracker.getTaskTracker(tip.machineWhereTaskRan(taskid));
            TaskTrackerStatus ttStatus = taskTracker == null ? null : taskTracker.getStatus();
            String httpTaskLogLocation = null;
            if (null != ttStatus) {
                String host = NetUtils.getStaticResolution(ttStatus.getHost()) != null ? NetUtils.getStaticResolution(ttStatus.getHost()) : ttStatus.getHost();
                httpTaskLogLocation = "http://" + host + ":" + ttStatus.getHttpPort();
            }
            TaskCompletionEvent taskEvent = null;
            if (state == TaskStatus.State.SUCCEEDED) {
                taskEvent = new TaskCompletionEvent(this.taskCompletionEventTracker, taskid, tip.idWithinJob(), status.getIsMap() && !tip.isJobCleanupTask() && !tip.isJobSetupTask(), TaskCompletionEvent.Status.SUCCEEDED, httpTaskLogLocation);
                taskEvent.setTaskRunTime((int)(status.getFinishTime() - status.getStartTime()));
                tip.setSuccessEventNumber(this.taskCompletionEventTracker);
            } else {
                if (state == TaskStatus.State.COMMIT_PENDING) {
                    if (!wasComplete && !wasPending) {
                        tip.doCommit(taskid);
                    }
                    return;
                }
                if (state == TaskStatus.State.FAILED_UNCLEAN || state == TaskStatus.State.KILLED_UNCLEAN) {
                    tip.incompleteSubTask(taskid, this.status);
                    if (tip.isMapTask()) {
                        this.mapCleanupTasks.add(taskid);
                    } else {
                        this.reduceCleanupTasks.add(taskid);
                    }
                    this.jobtracker.removeTaskEntry(taskid);
                } else if (state == TaskStatus.State.FAILED || state == TaskStatus.State.KILLED) {
                    TaskCompletionEvent.Status taskCompletionStatus;
                    TaskCompletionEvent t;
                    int eventNumber = tip.getSuccessEventNumber();
                    if (eventNumber != -1 && (t = this.taskCompletionEvents.get(eventNumber)).getTaskAttemptId().equals(taskid)) {
                        t.setTaskStatus(TaskCompletionEvent.Status.OBSOLETE);
                    }
                    this.failedTask(tip, taskid, status, taskTracker, wasRunning, wasComplete, wasAttemptRunning);
                    TaskCompletionEvent.Status status2 = taskCompletionStatus = state == TaskStatus.State.FAILED ? TaskCompletionEvent.Status.FAILED : TaskCompletionEvent.Status.KILLED;
                    if (tip.isFailed()) {
                        taskCompletionStatus = TaskCompletionEvent.Status.TIPFAILED;
                    }
                    taskEvent = new TaskCompletionEvent(this.taskCompletionEventTracker, taskid, tip.idWithinJob(), status.getIsMap() && !tip.isJobCleanupTask() && !tip.isJobSetupTask(), taskCompletionStatus, httpTaskLogLocation);
                }
            }
            if (taskEvent != null) {
                this.taskCompletionEvents.add(taskEvent);
                ++this.taskCompletionEventTracker;
                JobTrackerStatistics.TaskTrackerStat ttStat = this.jobtracker.getStatistics().getTaskTrackerStat(tip.machineWhereTaskRan(taskid));
                if (ttStat != null) {
                    ttStat.incrTotalTasks();
                }
                if (state == TaskStatus.State.SUCCEEDED) {
                    this.completedTask(tip, status);
                    if (ttStat != null) {
                        ttStat.incrSucceededTasks();
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Taking progress for " + tip.getTIPId() + " from " + oldProgress + " to " + tip.getProgress()));
        }
        if (!tip.isJobCleanupTask() && !tip.isJobSetupTask()) {
            double progressDelta = tip.getProgress() - oldProgress;
            if (tip.isMapTask()) {
                this.status.setMapProgress((float)((double)this.status.mapProgress() + progressDelta / (double)this.maps.length));
            } else {
                this.status.setReduceProgress((float)((double)this.status.reduceProgress() + progressDelta / (double)this.reduces.length));
            }
        }
    }

    String getHistoryFile() {
        return this.historyFile;
    }

    synchronized void setHistoryFile(String file) {
        this.historyFile = file;
    }

    public synchronized Counters getJobCounters() {
        return this.jobCounters;
    }

    public synchronized boolean getMapCounters(Counters counters) {
        try {
            counters = this.incrementTaskCounters(counters, this.maps);
        }
        catch (Counters.CountersExceededException ce) {
            LOG.info((Object)("Counters Exceeded for Job: " + this.jobId), (Throwable)ce);
            return false;
        }
        return true;
    }

    public synchronized boolean getReduceCounters(Counters counters) {
        try {
            counters = this.incrementTaskCounters(counters, this.reduces);
        }
        catch (Counters.CountersExceededException ce) {
            LOG.info((Object)("Counters Exceeded for Job: " + this.jobId), (Throwable)ce);
            return false;
        }
        return true;
    }

    public synchronized boolean getCounters(Counters result) {
        try {
            result.incrAllCounters(this.getJobCounters());
            this.incrementTaskCounters(result, this.maps);
            this.incrementTaskCounters(result, this.reduces);
        }
        catch (Counters.CountersExceededException ce) {
            LOG.info((Object)("Counters Exceeded for Job: " + this.jobId), (Throwable)ce);
            return false;
        }
        return true;
    }

    private Counters incrementTaskCounters(Counters counters, TaskInProgress[] tips) {
        for (TaskInProgress tip : tips) {
            counters.incrAllCounters(tip.getCounters());
        }
        return counters;
    }

    public synchronized Task obtainNewMapTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts) throws IOException {
        if (this.status.getRunState() != 1) {
            LOG.info((Object)("Cannot create task split for " + this.profile.getJobID()));
            try {
                throw new IOException("state = " + this.status.getRunState());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return null;
            }
        }
        int target = this.findNewMapTask(tts, clusterSize, numUniqueHosts, this.anyCacheLevel, this.status.mapProgress());
        if (target == -1) {
            return null;
        }
        Task result = this.maps[target].getTaskToRun(tts.getTrackerName());
        if (result != null) {
            this.addRunningTaskToTIP(this.maps[target], result.getTaskID(), tts, true);
            this.resetSchedulingOpportunities();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task obtainTaskCleanupTask(TaskTrackerStatus tts, boolean isMapSlot) throws IOException {
        if (!this.tasksInited) {
            return null;
        }
        JobInProgress jobInProgress = this;
        synchronized (jobInProgress) {
            if (this.status.getRunState() != 1 || this.jobFailed || this.jobKilled) {
                return null;
            }
            String taskTracker = tts.getTrackerName();
            if (!this.shouldRunOnTaskTracker(taskTracker)) {
                return null;
            }
            TaskAttemptID taskid = null;
            TaskInProgress tip = null;
            if (isMapSlot) {
                if (!this.mapCleanupTasks.isEmpty()) {
                    taskid = this.mapCleanupTasks.remove(0);
                    tip = this.maps[taskid.getTaskID().getId()];
                }
            } else if (!this.reduceCleanupTasks.isEmpty()) {
                taskid = this.reduceCleanupTasks.remove(0);
                tip = this.reduces[taskid.getTaskID().getId()];
            }
            if (tip != null) {
                return tip.addRunningTask(taskid, taskTracker, true);
            }
            return null;
        }
    }

    public synchronized Task obtainNewNodeLocalMapTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts) throws IOException {
        if (!this.tasksInited) {
            LOG.info((Object)("Cannot create task split for " + this.profile.getJobID()));
            try {
                throw new IOException("state = " + this.status.getRunState());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return null;
            }
        }
        int target = this.findNewMapTask(tts, clusterSize, numUniqueHosts, 1, this.status.mapProgress());
        if (target == -1) {
            return null;
        }
        Task result = this.maps[target].getTaskToRun(tts.getTrackerName());
        if (result != null) {
            this.addRunningTaskToTIP(this.maps[target], result.getTaskID(), tts, true);
            this.resetSchedulingOpportunities();
        }
        return result;
    }

    public synchronized Task obtainNewNodeOrRackLocalMapTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts) throws IOException {
        if (!this.tasksInited) {
            LOG.info((Object)("Cannot create task split for " + this.profile.getJobID()));
            try {
                throw new IOException("state = " + this.status.getRunState());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return null;
            }
        }
        int target = this.findNewMapTask(tts, clusterSize, numUniqueHosts, this.maxLevel, this.status.mapProgress());
        if (target == -1) {
            return null;
        }
        Task result = this.maps[target].getTaskToRun(tts.getTrackerName());
        if (result != null) {
            this.addRunningTaskToTIP(this.maps[target], result.getTaskID(), tts, true);
            this.resetSchedulingOpportunities();
        }
        return result;
    }

    public synchronized Task obtainNewNonLocalMapTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts) throws IOException {
        if (!this.tasksInited) {
            LOG.info((Object)("Cannot create task split for " + this.profile.getJobID()));
            try {
                throw new IOException("state = " + this.status.getRunState());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return null;
            }
        }
        int target = this.findNewMapTask(tts, clusterSize, numUniqueHosts, -1, this.status.mapProgress());
        if (target == -1) {
            return null;
        }
        Task result = this.maps[target].getTaskToRun(tts.getTrackerName());
        if (result != null) {
            this.addRunningTaskToTIP(this.maps[target], result.getTaskID(), tts, true);
        }
        return result;
    }

    public void schedulingOpportunity() {
        ++this.numSchedulingOpportunities;
    }

    public void resetSchedulingOpportunities() {
        this.numSchedulingOpportunities = 0L;
    }

    public long getNumSchedulingOpportunities() {
        return this.numSchedulingOpportunities;
    }

    public void overrideSchedulingOpportunities() {
        this.numSchedulingOpportunities = 1000000L;
    }

    public boolean scheduleOffSwitch(int numTaskTrackers) {
        long missedTaskTrackers = this.getNumSchedulingOpportunities();
        long requiredSlots = Math.min(this.desiredMaps() - this.finishedMaps(), numTaskTrackers);
        return (float)requiredSlots * this.localityWaitFactor < (float)missedTaskTrackers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task obtainJobCleanupTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts, boolean isMapSlot) throws IOException {
        if (!this.tasksInited) {
            return null;
        }
        JobInProgress jobInProgress = this;
        synchronized (jobInProgress) {
            if (!this.canLaunchJobCleanupTask()) {
                return null;
            }
            String taskTracker = tts.getTrackerName();
            this.clusterSize = clusterSize;
            if (!this.shouldRunOnTaskTracker(taskTracker)) {
                return null;
            }
            ArrayList<TaskInProgress> cleanupTaskList = new ArrayList<TaskInProgress>();
            if (isMapSlot) {
                cleanupTaskList.add(this.cleanup[0]);
            } else {
                cleanupTaskList.add(this.cleanup[1]);
            }
            TaskInProgress tip = this.findTaskFromList(cleanupTaskList, tts, numUniqueHosts, false);
            if (tip == null) {
                return null;
            }
            Task result = tip.getTaskToRun(tts.getTrackerName());
            if (result != null) {
                this.addRunningTaskToTIP(tip, result.getTaskID(), tts, true);
                if (this.jobFailed) {
                    result.setJobCleanupTaskState(JobStatus.State.FAILED);
                } else if (this.jobKilled) {
                    result.setJobCleanupTaskState(JobStatus.State.KILLED);
                } else {
                    result.setJobCleanupTaskState(JobStatus.State.SUCCEEDED);
                }
            }
            return result;
        }
    }

    private synchronized boolean canLaunchJobCleanupTask() {
        boolean launchCleanupTask;
        if (this.status.getRunState() != 1 && this.status.getRunState() != 4) {
            return false;
        }
        if (this.launchedCleanup || !this.isSetupFinished()) {
            return false;
        }
        if (this.jobKilled || this.jobFailed) {
            return true;
        }
        boolean bl = launchCleanupTask = this.finishedMapTasks + this.failedMapTIPs == this.numMapTasks;
        if (launchCleanupTask) {
            launchCleanupTask = this.finishedReduceTasks + this.failedReduceTIPs == this.numReduceTasks;
        }
        return launchCleanupTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task obtainJobSetupTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts, boolean isMapSlot) throws IOException {
        if (!this.tasksInited) {
            return null;
        }
        JobInProgress jobInProgress = this;
        synchronized (jobInProgress) {
            if (!this.canLaunchSetupTask()) {
                return null;
            }
            String taskTracker = tts.getTrackerName();
            this.clusterSize = clusterSize;
            if (!this.shouldRunOnTaskTracker(taskTracker)) {
                return null;
            }
            ArrayList<TaskInProgress> setupTaskList = new ArrayList<TaskInProgress>();
            if (isMapSlot) {
                setupTaskList.add(this.setup[0]);
            } else {
                setupTaskList.add(this.setup[1]);
            }
            TaskInProgress tip = this.findTaskFromList(setupTaskList, tts, numUniqueHosts, false);
            if (tip == null) {
                return null;
            }
            Task result = tip.getTaskToRun(tts.getTrackerName());
            if (result != null) {
                this.addRunningTaskToTIP(tip, result.getTaskID(), tts, true);
            }
            return result;
        }
    }

    public synchronized boolean scheduleReduces() {
        return this.finishedMapTasks >= this.completedMapsForReduceSlowstart;
    }

    private synchronized boolean canLaunchSetupTask() {
        return this.tasksInited && this.status.getRunState() == 4 && !this.launchedSetup && !this.jobKilled && !this.jobFailed;
    }

    public synchronized Task obtainNewReduceTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts) throws IOException {
        if (this.status.getRunState() != 1) {
            LOG.info((Object)("Cannot create task split for " + this.profile.getJobID()));
            return null;
        }
        long estimatedReduceInputSize = this.resourceEstimator.getEstimatedReduceInputSize() / 2L;
        if (estimatedReduceInputSize > this.reduce_input_limit && this.reduce_input_limit > 0L) {
            LOG.info((Object)("Exceeded limit for reduce input size: Estimated:" + estimatedReduceInputSize + " Limit: " + this.reduce_input_limit + " Failing Job " + this.jobId));
            this.status.setFailureInfo("Job exceeded Reduce Input limit  Limit:  " + this.reduce_input_limit + " Estimated: " + estimatedReduceInputSize);
            this.jobtracker.failJob(this);
            return null;
        }
        if (!this.scheduleReduces()) {
            return null;
        }
        int target = this.findNewReduceTask(tts, clusterSize, numUniqueHosts, this.status.reduceProgress());
        if (target == -1) {
            return null;
        }
        Task result = this.reduces[target].getTaskToRun(tts.getTrackerName());
        if (result != null) {
            this.addRunningTaskToTIP(this.reduces[target], result.getTaskID(), tts, true);
        }
        return result;
    }

    private int getMatchingLevelForNodes(Node n1, Node n2) {
        int count = 0;
        do {
            if (n1.equals(n2)) {
                return count;
            }
            ++count;
            n1 = n1.getParent();
            n2 = n2.getParent();
        } while (n1 != null);
        return this.maxLevel;
    }

    synchronized void addRunningTaskToTIP(TaskInProgress tip, TaskAttemptID id, TaskTrackerStatus tts, boolean isScheduled) {
        String name;
        if (!isScheduled) {
            tip.addRunningTask(id, tts.getTrackerName());
        }
        JobTrackerInstrumentation metrics = this.jobtracker.getInstrumentation();
        String splits = "";
        Counter counter = null;
        if (tip.isJobSetupTask()) {
            this.launchedSetup = true;
            name = JobHistory.Values.SETUP.name();
        } else if (tip.isJobCleanupTask()) {
            this.launchedCleanup = true;
            name = JobHistory.Values.CLEANUP.name();
        } else if (tip.isMapTask()) {
            ++this.runningMapTasks;
            name = JobHistory.Values.MAP.name();
            counter = Counter.TOTAL_LAUNCHED_MAPS;
            splits = tip.getSplitNodes();
            if (tip.getActiveTasks().size() > 1) {
                ++this.speculativeMapTasks;
            }
            metrics.launchMap(id);
            this.queueMetrics.launchMap(id);
        } else {
            ++this.runningReduceTasks;
            name = JobHistory.Values.REDUCE.name();
            counter = Counter.TOTAL_LAUNCHED_REDUCES;
            if (tip.getActiveTasks().size() > 1) {
                ++this.speculativeReduceTasks;
            }
            metrics.launchReduce(id);
            this.queueMetrics.launchReduce(id);
        }
        if (tip.isFirstAttempt(id)) {
            JobHistory.Task.logStarted(tip.getTIPId(), name, tip.getExecStartTime(), splits);
            this.setFirstTaskLaunchTime(tip);
        }
        if (!tip.isJobSetupTask() && !tip.isJobCleanupTask()) {
            this.jobCounters.incrCounter(counter, 1L);
        }
        if (tip.isMapTask() && !tip.isJobSetupTask() && !tip.isJobCleanupTask()) {
            Node tracker = this.jobtracker.getNode(tts.getHost());
            int level = this.maxLevel;
            for (String local : this.maps[tip.getIdWithinJob()].getSplitLocations()) {
                Node datanode = this.jobtracker.getNode(local);
                int newLevel = this.maxLevel;
                if (tracker != null && datanode != null) {
                    newLevel = this.getMatchingLevelForNodes(tracker, datanode);
                }
                if (newLevel < level && (level = newLevel) == 0) break;
            }
            switch (level) {
                case 0: {
                    LOG.info((Object)("Choosing data-local task " + tip.getTIPId()));
                    this.jobCounters.incrCounter(Counter.DATA_LOCAL_MAPS, 1L);
                    break;
                }
                case 1: {
                    LOG.info((Object)("Choosing rack-local task " + tip.getTIPId()));
                    this.jobCounters.incrCounter(Counter.RACK_LOCAL_MAPS, 1L);
                    break;
                }
                default: {
                    if (level == this.maxLevel) break;
                    LOG.info((Object)("Choosing cached task at level " + level + tip.getTIPId()));
                    this.jobCounters.incrCounter(Counter.OTHER_LOCAL_MAPS, 1L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFirstTaskLaunchTime(TaskInProgress tip) {
        TaskType key = tip.getFirstTaskType();
        Map<TaskType, Long> map2 = this.firstTaskLaunchTimes;
        synchronized (map2) {
            if (!this.firstTaskLaunchTimes.containsKey((Object)key)) {
                this.firstTaskLaunchTimes.put(key, tip.getExecStartTime());
            }
        }
    }

    static String convertTrackerNameToHostName(String trackerName) {
        int indexOfColon = trackerName.indexOf(":");
        String trackerHostName = indexOfColon == -1 ? trackerName : trackerName.substring(0, indexOfColon);
        return trackerHostName.substring("tracker_".length());
    }

    synchronized void addTrackerTaskFailure(String trackerName, TaskTracker taskTracker) {
        if ((double)this.flakyTaskTrackers < (double)this.clusterSize * 0.25) {
            String trackerHostName = JobInProgress.convertTrackerNameToHostName(trackerName);
            Integer trackerFailures = this.trackerToFailuresMap.get(trackerHostName);
            if (trackerFailures == null) {
                trackerFailures = 0;
            }
            trackerFailures = trackerFailures + 1;
            this.trackerToFailuresMap.put(trackerHostName, trackerFailures);
            if (trackerFailures == this.maxTaskFailuresPerTracker) {
                ++this.flakyTaskTrackers;
                if (taskTracker != null) {
                    if (this.trackersReservedForMaps.containsKey(taskTracker)) {
                        taskTracker.unreserveSlots(TaskType.MAP, this);
                    }
                    if (this.trackersReservedForReduces.containsKey(taskTracker)) {
                        taskTracker.unreserveSlots(TaskType.REDUCE, this);
                    }
                }
                LOG.info((Object)("TaskTracker at '" + trackerHostName + "' turned 'flaky'"));
            }
        }
    }

    public synchronized void reserveTaskTracker(TaskTracker taskTracker, TaskType type, int numSlots) {
        Map<TaskTracker, FallowSlotInfo> map2 = type == TaskType.MAP ? this.trackersReservedForMaps : this.trackersReservedForReduces;
        long now = this.jobtracker.getClock().getTime();
        FallowSlotInfo info2 = map2.get(taskTracker);
        int reservedSlots = 0;
        if (info2 == null) {
            info2 = new FallowSlotInfo(now, numSlots);
            reservedSlots = numSlots;
        } else if (info2.getNumSlots() != numSlots) {
            Counter counter = type == TaskType.MAP ? Counter.FALLOW_SLOTS_MILLIS_MAPS : Counter.FALLOW_SLOTS_MILLIS_REDUCES;
            long fallowSlotMillis = (now - info2.getTimestamp()) * (long)info2.getNumSlots();
            this.jobCounters.incrCounter(counter, fallowSlotMillis);
            reservedSlots = numSlots - info2.getNumSlots();
            info2.setTimestamp(now);
            info2.setNumSlots(numSlots);
        }
        map2.put(taskTracker, info2);
        if (type == TaskType.MAP) {
            this.jobtracker.getInstrumentation().addReservedMapSlots(reservedSlots);
            this.queueMetrics.addReservedMapSlots(reservedSlots);
        } else {
            this.jobtracker.getInstrumentation().addReservedReduceSlots(reservedSlots);
            this.queueMetrics.addReservedReduceSlots(reservedSlots);
        }
        this.jobtracker.incrementReservations(type, reservedSlots);
    }

    public synchronized void unreserveTaskTracker(TaskTracker taskTracker, TaskType type) {
        Map<TaskTracker, FallowSlotInfo> map2 = type == TaskType.MAP ? this.trackersReservedForMaps : this.trackersReservedForReduces;
        FallowSlotInfo info2 = map2.get(taskTracker);
        if (info2 == null) {
            LOG.warn((Object)("Cannot find information about fallow slots for " + taskTracker.getTrackerName()));
            return;
        }
        long now = this.jobtracker.getClock().getTime();
        Counter counter = type == TaskType.MAP ? Counter.FALLOW_SLOTS_MILLIS_MAPS : Counter.FALLOW_SLOTS_MILLIS_REDUCES;
        long fallowSlotMillis = (now - info2.getTimestamp()) * (long)info2.getNumSlots();
        this.jobCounters.incrCounter(counter, fallowSlotMillis);
        map2.remove(taskTracker);
        if (type == TaskType.MAP) {
            this.jobtracker.getInstrumentation().decReservedMapSlots(info2.getNumSlots());
            this.queueMetrics.decReservedMapSlots(info2.getNumSlots());
        } else {
            this.jobtracker.getInstrumentation().decReservedReduceSlots(info2.getNumSlots());
            this.queueMetrics.decReservedReduceSlots(info2.getNumSlots());
        }
        this.jobtracker.decrementReservations(type, info2.getNumSlots());
    }

    public int getNumReservedTaskTrackersForMaps() {
        return this.trackersReservedForMaps.size();
    }

    public int getNumReservedTaskTrackersForReduces() {
        return this.trackersReservedForReduces.size();
    }

    private int getTrackerTaskFailures(String trackerName) {
        String trackerHostName = JobInProgress.convertTrackerNameToHostName(trackerName);
        Integer failedTasks = this.trackerToFailuresMap.get(trackerHostName);
        return failedTasks != null ? failedTasks : 0;
    }

    List<String> getBlackListedTrackers() {
        ArrayList<String> blackListedTrackers = new ArrayList<String>();
        for (Map.Entry<String, Integer> e : this.trackerToFailuresMap.entrySet()) {
            if (e.getValue() < this.maxTaskFailuresPerTracker) continue;
            blackListedTrackers.add(e.getKey());
        }
        return blackListedTrackers;
    }

    int getNoOfBlackListedTrackers() {
        return this.flakyTaskTrackers;
    }

    synchronized Map<String, Integer> getTaskTrackerErrors() {
        TreeMap<String, Integer> trackerErrors = new TreeMap<String, Integer>(this.trackerToFailuresMap);
        return trackerErrors;
    }

    private synchronized void retireMap(TaskInProgress tip) {
        if (this.runningMapCache == null) {
            LOG.warn((Object)"Running cache for maps missing!! Job details are missing.");
            return;
        }
        String[] splitLocations = tip.getSplitLocations();
        if (splitLocations == null || splitLocations.length == 0) {
            this.nonLocalRunningMaps.remove(tip);
            return;
        }
        for (String host : splitLocations) {
            Node node = this.jobtracker.getNode(host);
            for (int j = 0; j < this.maxLevel; ++j) {
                Set<TaskInProgress> hostMaps = this.runningMapCache.get(node);
                if (hostMaps != null) {
                    hostMaps.remove(tip);
                    if (hostMaps.size() == 0) {
                        this.runningMapCache.remove(node);
                    }
                }
                node = node.getParent();
            }
        }
    }

    private synchronized void retireReduce(TaskInProgress tip) {
        if (this.runningReduces == null) {
            LOG.warn((Object)"Running list for reducers missing!! Job details are missing.");
            return;
        }
        this.runningReduces.remove(tip);
    }

    protected synchronized void scheduleMap(TaskInProgress tip) {
        if (this.runningMapCache == null) {
            LOG.warn((Object)"Running cache for maps is missing!! Job details are missing.");
            return;
        }
        String[] splitLocations = tip.getSplitLocations();
        if (splitLocations == null || splitLocations.length == 0) {
            this.nonLocalRunningMaps.add(tip);
            return;
        }
        for (String host : splitLocations) {
            Node node = this.jobtracker.getNode(host);
            for (int j = 0; j < this.maxLevel; ++j) {
                Set<TaskInProgress> hostMaps = this.runningMapCache.get(node);
                if (hostMaps == null) {
                    hostMaps = new LinkedHashSet<TaskInProgress>();
                    this.runningMapCache.put(node, hostMaps);
                }
                hostMaps.add(tip);
                node = node.getParent();
            }
        }
    }

    protected synchronized void scheduleReduce(TaskInProgress tip) {
        if (this.runningReduces == null) {
            LOG.warn((Object)"Running cache for reducers missing!! Job details are missing.");
            return;
        }
        this.runningReduces.add(tip);
    }

    private synchronized void failMap(TaskInProgress tip) {
        if (this.failedMaps == null) {
            LOG.warn((Object)"Failed cache for maps is missing! Job details are missing.");
            return;
        }
        this.failedMaps.add(tip);
    }

    private synchronized void failReduce(TaskInProgress tip) {
        if (this.nonRunningReduces == null) {
            LOG.warn((Object)"Failed cache for reducers missing!! Job details are missing.");
            return;
        }
        this.nonRunningReduces.add(tip);
    }

    private synchronized TaskInProgress findTaskFromList(Collection<TaskInProgress> tips, TaskTrackerStatus ttStatus, int numUniqueHosts, boolean removeFailedTip) {
        Iterator<TaskInProgress> iter = tips.iterator();
        while (iter.hasNext()) {
            TaskInProgress tip = iter.next();
            if (tip.isRunnable() && !tip.isRunning()) {
                if (!tip.hasFailedOnMachine(ttStatus.getHost()) || tip.getNumberOfFailedMachines() >= numUniqueHosts) {
                    iter.remove();
                    return tip;
                }
                if (!removeFailedTip) continue;
                iter.remove();
                continue;
            }
            iter.remove();
        }
        return null;
    }

    protected synchronized TaskInProgress findSpeculativeTask(Collection<TaskInProgress> list, TaskTrackerStatus ttStatus, double avgProgress, long currentTime, boolean shouldRemove) {
        Iterator<TaskInProgress> iter = list.iterator();
        while (iter.hasNext()) {
            TaskInProgress tip = iter.next();
            if (!tip.isRunning() || !tip.isRunnable()) {
                iter.remove();
                continue;
            }
            if (!tip.hasRunOnMachine(ttStatus.getHost(), ttStatus.getTrackerName())) {
                if (!tip.hasSpeculativeTask(currentTime, avgProgress)) continue;
                if (shouldRemove) {
                    iter.remove();
                }
                return tip;
            }
            if (!shouldRemove) continue;
            iter.remove();
        }
        return null;
    }

    private synchronized int findNewMapTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts, int maxCacheLevel, double avgProgress) {
        if (this.numMapTasks == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No maps to schedule for " + this.profile.getJobID()));
            }
            return -1;
        }
        String taskTracker = tts.getTrackerName();
        TaskInProgress tip = null;
        this.clusterSize = clusterSize;
        if (!this.shouldRunOnTaskTracker(taskTracker)) {
            return -1;
        }
        long outSize = this.resourceEstimator.getEstimatedMapOutputSize();
        long availSpace = tts.getResourceStatus().getAvailableSpace();
        if (availSpace < outSize) {
            LOG.warn((Object)("No room for map task. Node " + tts.getHost() + " has " + availSpace + " bytes free; but we expect map to take " + outSize));
            return -1;
        }
        tip = this.findTaskFromList(this.failedMaps, tts, numUniqueHosts, false);
        if (tip != null) {
            this.scheduleMap(tip);
            LOG.info((Object)("Choosing a failed task " + tip.getTIPId()));
            return tip.getIdWithinJob();
        }
        Node node = this.jobtracker.getNode(tts.getHost());
        if (node != null) {
            Node key = node;
            int level = 0;
            int maxLevelToSchedule = Math.min(maxCacheLevel, this.maxLevel);
            for (level = 0; level < maxLevelToSchedule; ++level) {
                List<TaskInProgress> cacheForLevel = this.nonRunningMapCache.get(key);
                if (cacheForLevel != null && (tip = this.findTaskFromList(cacheForLevel, tts, numUniqueHosts, level == 0)) != null) {
                    this.scheduleMap(tip);
                    if (cacheForLevel.size() == 0) {
                        this.nonRunningMapCache.remove(key);
                    }
                    return tip.getIdWithinJob();
                }
                key = key.getParent();
            }
            if (level == maxCacheLevel) {
                return -1;
            }
        }
        Collection<Node> nodesAtMaxLevel = this.jobtracker.getNodesAtMaxLevel();
        Node nodeParentAtMaxLevel = node == null ? null : JobTracker.getParentNode(node, this.maxLevel - 1);
        for (Node parent : nodesAtMaxLevel) {
            List<TaskInProgress> cache;
            if (parent == nodeParentAtMaxLevel || (cache = this.nonRunningMapCache.get(parent)) == null || (tip = this.findTaskFromList(cache, tts, numUniqueHosts, false)) == null) continue;
            this.scheduleMap(tip);
            if (cache.size() == 0) {
                this.nonRunningMapCache.remove(parent);
            }
            LOG.info((Object)("Choosing a non-local task " + tip.getTIPId()));
            return tip.getIdWithinJob();
        }
        tip = this.findTaskFromList(this.nonLocalMaps, tts, numUniqueHosts, false);
        if (tip != null) {
            this.scheduleMap(tip);
            LOG.info((Object)("Choosing a non-local task " + tip.getTIPId()));
            return tip.getIdWithinJob();
        }
        if (this.hasSpeculativeMaps) {
            long currentTime = this.jobtracker.getClock().getTime();
            if (node != null) {
                Node key = node;
                for (int level = 0; level < this.maxLevel; ++level) {
                    Set<TaskInProgress> cacheForLevel = this.runningMapCache.get(key);
                    if (cacheForLevel != null && (tip = this.findSpeculativeTask(cacheForLevel, tts, avgProgress, currentTime, level == 0)) != null) {
                        if (cacheForLevel.size() == 0) {
                            this.runningMapCache.remove(key);
                        }
                        return tip.getIdWithinJob();
                    }
                    key = key.getParent();
                }
            }
            for (Node parent : nodesAtMaxLevel) {
                Set<TaskInProgress> cache;
                if (parent == nodeParentAtMaxLevel || (cache = this.runningMapCache.get(parent)) == null || (tip = this.findSpeculativeTask(cache, tts, avgProgress, currentTime, false)) == null) continue;
                if (cache.size() == 0) {
                    this.runningMapCache.remove(parent);
                }
                LOG.info((Object)("Choosing a non-local task " + tip.getTIPId() + " for speculation"));
                return tip.getIdWithinJob();
            }
            tip = this.findSpeculativeTask(this.nonLocalRunningMaps, tts, avgProgress, currentTime, false);
            if (tip != null) {
                LOG.info((Object)("Choosing a non-local task " + tip.getTIPId() + " for speculation"));
                return tip.getIdWithinJob();
            }
        }
        return -1;
    }

    private synchronized int findNewReduceTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts, double avgProgress) {
        if (this.numReduceTasks == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No reduces to schedule for " + this.profile.getJobID()));
            }
            return -1;
        }
        String taskTracker = tts.getTrackerName();
        TaskInProgress tip = null;
        this.clusterSize = clusterSize;
        if (!this.shouldRunOnTaskTracker(taskTracker)) {
            return -1;
        }
        tip = this.findTaskFromList(this.nonRunningReduces, tts, numUniqueHosts, false);
        if (tip != null) {
            this.scheduleReduce(tip);
            return tip.getIdWithinJob();
        }
        if (this.hasSpeculativeReduces && (tip = this.findSpeculativeTask(this.runningReduces, tts, avgProgress, this.jobtracker.getClock().getTime(), false)) != null) {
            this.scheduleReduce(tip);
            return tip.getIdWithinJob();
        }
        return -1;
    }

    private boolean shouldRunOnTaskTracker(String taskTracker) {
        int taskTrackerFailedTasks = this.getTrackerTaskFailures(taskTracker);
        if ((double)this.flakyTaskTrackers < (double)this.clusterSize * 0.25 && taskTrackerFailedTasks >= this.maxTaskFailuresPerTracker) {
            if (LOG.isDebugEnabled()) {
                String flakyTracker = JobInProgress.convertTrackerNameToHostName(taskTracker);
                LOG.debug((Object)("Ignoring the black-listed tasktracker: '" + flakyTracker + "' for assigning a new task"));
            }
            return false;
        }
        return true;
    }

    private void meterTaskAttempt(TaskInProgress tip, TaskStatus status) {
        Counter slotCounter = tip.isMapTask() ? Counter.SLOTS_MILLIS_MAPS : Counter.SLOTS_MILLIS_REDUCES;
        this.jobCounters.incrCounter(slotCounter, (long)tip.getNumSlotsRequired() * (status.getFinishTime() - status.getStartTime()));
    }

    public synchronized boolean completedTask(TaskInProgress tip, TaskStatus status) {
        TaskAttemptID taskid = status.getTaskID();
        int oldNumAttempts = tip.getActiveTasks().size();
        JobTrackerInstrumentation metrics = this.jobtracker.getInstrumentation();
        this.meterTaskAttempt(tip, status);
        if (tip.isComplete()) {
            tip.alreadyCompletedTask(taskid);
            if (this.status.getRunState() != 1) {
                this.jobtracker.markCompletedTaskAttempt(status.getTaskTracker(), taskid);
            }
            return false;
        }
        LOG.info((Object)("Task '" + taskid + "' has completed " + tip.getTIPId() + " successfully."));
        tip.completed(taskid);
        this.resourceEstimator.updateWithCompletedTask(status, tip);
        TaskTrackerStatus ttStatus = this.jobtracker.getTaskTrackerStatus(status.getTaskTracker());
        String trackerHostname = this.jobtracker.getNode(ttStatus.getHost()).toString();
        String taskType = this.getTaskType(tip);
        if (status.getIsMap()) {
            JobHistory.MapAttempt.logStarted(status.getTaskID(), status.getStartTime(), status.getTaskTracker(), ttStatus.getHttpPort(), taskType);
            JobHistory.MapAttempt.logFinished(status.getTaskID(), status.getFinishTime(), trackerHostname, taskType, status.getStateString(), status.getCounters());
        } else {
            JobHistory.ReduceAttempt.logStarted(status.getTaskID(), status.getStartTime(), status.getTaskTracker(), ttStatus.getHttpPort(), taskType);
            JobHistory.ReduceAttempt.logFinished(status.getTaskID(), status.getShuffleFinishTime(), status.getSortFinishTime(), status.getFinishTime(), trackerHostname, taskType, status.getStateString(), status.getCounters());
        }
        JobHistory.Task.logFinished(tip.getTIPId(), taskType, tip.getExecFinishTime(), status.getCounters());
        int newNumAttempts = tip.getActiveTasks().size();
        if (tip.isJobSetupTask()) {
            this.killSetupTip(!tip.isMapTask());
            this.status.setSetupProgress(1.0f);
            if (this.status.getRunState() == 4) {
                this.changeStateTo(1);
                JobHistory.JobInfo.logStarted(this.profile.getJobID());
            }
        } else if (tip.isJobCleanupTask()) {
            if (tip.isMapTask()) {
                this.cleanup[1].kill();
            } else {
                this.cleanup[0].kill();
            }
            if (this.jobFailed) {
                this.terminateJob(3);
            }
            if (this.jobKilled) {
                this.terminateJob(5);
            } else {
                this.jobComplete();
            }
            this.jobtracker.markCompletedTaskAttempt(status.getTaskTracker(), taskid);
        } else if (tip.isMapTask()) {
            --this.runningMapTasks;
            if (oldNumAttempts > 1) {
                this.speculativeMapTasks -= oldNumAttempts - newNumAttempts;
            }
            ++this.finishedMapTasks;
            metrics.completeMap(taskid);
            this.queueMetrics.completeMap(taskid);
            this.retireMap(tip);
            if (this.finishedMapTasks + this.failedMapTIPs == this.numMapTasks) {
                this.status.setMapProgress(1.0f);
                if (this.canLaunchJobCleanupTask()) {
                    this.checkCounterLimitsAndFail();
                }
            }
        } else {
            --this.runningReduceTasks;
            if (oldNumAttempts > 1) {
                this.speculativeReduceTasks -= oldNumAttempts - newNumAttempts;
            }
            ++this.finishedReduceTasks;
            metrics.completeReduce(taskid);
            this.queueMetrics.completeReduce(taskid);
            this.retireReduce(tip);
            if (this.finishedReduceTasks + this.failedReduceTIPs == this.numReduceTasks) {
                this.status.setReduceProgress(1.0f);
                if (this.canLaunchJobCleanupTask()) {
                    this.checkCounterLimitsAndFail();
                }
            }
        }
        return true;
    }

    private void checkCounterLimitsAndFail() {
        boolean jobIsFine = true;
        boolean mapIsFine = this.getMapCounters(new Counters());
        boolean reduceIsFine = this.getReduceCounters(new Counters());
        jobIsFine = this.getCounters(new Counters());
        if (!(mapIsFine && reduceIsFine && jobIsFine)) {
            this.status.setFailureInfo("Counters Exceeded: Limit: " + Counters.MAX_COUNTER_LIMIT);
            this.jobtracker.failJob(this);
        }
    }

    private void changeStateTo(int newState) {
        int oldState = this.status.getRunState();
        if (oldState == newState) {
            return;
        }
        this.status.setRunState(newState);
        if (oldState == 4) {
            this.jobtracker.getInstrumentation().decPrepJob(this.conf, this.jobId);
            this.queueMetrics.decPrepJob(this.conf, this.jobId);
        } else if (oldState == 1) {
            this.jobtracker.getInstrumentation().decRunningJob(this.conf, this.jobId);
            this.queueMetrics.decRunningJob(this.conf, this.jobId);
        }
        if (newState == 4) {
            this.jobtracker.getInstrumentation().addPrepJob(this.conf, this.jobId);
            this.queueMetrics.addPrepJob(this.conf, this.jobId);
        } else if (newState == 1) {
            this.jobtracker.getInstrumentation().addRunningJob(this.conf, this.jobId);
            this.queueMetrics.addRunningJob(this.conf, this.jobId);
        }
    }

    private void jobComplete() {
        JobTrackerInstrumentation metrics = this.jobtracker.getInstrumentation();
        if (this.status.getRunState() == 1) {
            this.changeStateTo(2);
            this.status.setCleanupProgress(1.0f);
            if (this.maps.length == 0) {
                this.status.setMapProgress(1.0f);
            }
            if (this.reduces.length == 0) {
                this.status.setReduceProgress(1.0f);
            }
            this.finishTime = this.jobtracker.getClock().getTime();
            LOG.info((Object)("Job " + this.status.getJobID() + " has completed successfully."));
            JobSummary.logJobSummary(this, this.jobtracker.getClusterStatus(false));
            Counters mapCounters = new Counters();
            boolean isFine = this.getMapCounters(mapCounters);
            mapCounters = isFine ? mapCounters : new Counters();
            Counters reduceCounters = new Counters();
            isFine = this.getReduceCounters(reduceCounters);
            reduceCounters = isFine ? reduceCounters : new Counters();
            Counters jobCounters = new Counters();
            isFine = this.getCounters(jobCounters);
            jobCounters = isFine ? jobCounters : new Counters();
            JobHistory.JobInfo.logFinished(this.status.getJobID(), this.finishTime, this.finishedMapTasks, this.finishedReduceTasks, this.failedMapTasks, this.failedReduceTasks, mapCounters, reduceCounters, jobCounters);
            this.garbageCollect();
            metrics.completeJob(this.conf, this.status.getJobID());
            this.queueMetrics.completeJob(this.conf, this.status.getJobID());
        }
    }

    private synchronized void terminateJob(int jobTerminationState) {
        if (this.status.getRunState() == 1 || this.status.getRunState() == 4) {
            this.finishTime = this.jobtracker.getClock().getTime();
            this.status.setMapProgress(1.0f);
            this.status.setReduceProgress(1.0f);
            this.status.setCleanupProgress(1.0f);
            if (jobTerminationState == 3) {
                this.changeStateTo(3);
                JobSummary.logJobSummary(this, this.jobtracker.getClusterStatus(false));
                JobHistory.JobInfo.logFailed(this.status.getJobID(), this.finishTime, this.finishedMapTasks, this.finishedReduceTasks, this.status.getFailureInfo());
            } else {
                this.changeStateTo(5);
                JobSummary.logJobSummary(this, this.jobtracker.getClusterStatus(false));
                JobHistory.JobInfo.logKilled(this.status.getJobID(), this.finishTime, this.finishedMapTasks, this.finishedReduceTasks);
            }
            this.garbageCollect();
            this.jobtracker.getInstrumentation().terminateJob(this.conf, this.status.getJobID());
            if (jobTerminationState == 3) {
                this.jobtracker.getInstrumentation().failedJob(this.conf, this.status.getJobID());
                this.queueMetrics.failedJob(this.conf, this.status.getJobID());
            } else {
                this.jobtracker.getInstrumentation().killedJob(this.conf, this.status.getJobID());
                this.queueMetrics.killedJob(this.conf, this.status.getJobID());
            }
        }
    }

    private synchronized void terminate(int jobTerminationState) {
        if (!this.tasksInited) {
            this.terminateJob(jobTerminationState);
            return;
        }
        if (this.status.getRunState() == 1 || this.status.getRunState() == 4) {
            int i;
            LOG.info((Object)("Killing job '" + this.status.getJobID() + "'"));
            if (jobTerminationState == 3) {
                if (this.jobFailed) {
                    return;
                }
                this.jobFailed = true;
            } else if (jobTerminationState == 5) {
                if (this.jobKilled) {
                    return;
                }
                this.jobKilled = true;
            }
            this.clearUncleanTasks();
            for (i = 0; i < this.setup.length; ++i) {
                this.setup[i].kill();
            }
            for (i = 0; i < this.maps.length; ++i) {
                this.maps[i].kill();
            }
            for (i = 0; i < this.reduces.length; ++i) {
                this.reduces[i].kill();
            }
        }
    }

    private void cancelReservedSlots() {
        HashSet<TaskTracker> tm = new HashSet<TaskTracker>(this.trackersReservedForMaps.keySet());
        for (TaskTracker tt : tm) {
            tt.unreserveSlots(TaskType.MAP, this);
        }
        HashSet<TaskTracker> tr = new HashSet<TaskTracker>(this.trackersReservedForReduces.keySet());
        for (TaskTracker tt : tr) {
            tt.unreserveSlots(TaskType.REDUCE, this);
        }
    }

    private void clearUncleanTasks() {
        TaskAttemptID taskid = null;
        TaskInProgress tip = null;
        while (!this.mapCleanupTasks.isEmpty()) {
            taskid = this.mapCleanupTasks.remove(0);
            tip = this.maps[taskid.getTaskID().getId()];
            this.updateTaskStatus(tip, tip.getTaskStatus(taskid));
        }
        while (!this.reduceCleanupTasks.isEmpty()) {
            taskid = this.reduceCleanupTasks.remove(0);
            tip = this.reduces[taskid.getTaskID().getId()];
            this.updateTaskStatus(tip, tip.getTaskStatus(taskid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        boolean killNow = false;
        JobInitKillStatus jobInitKillStatus = this.jobInitKillStatus;
        synchronized (jobInitKillStatus) {
            this.jobInitKillStatus.killed = true;
            if (!this.jobInitKillStatus.initStarted || this.jobInitKillStatus.initDone) {
                killNow = true;
            }
        }
        if (killNow) {
            this.terminate(5);
        }
    }

    synchronized void fail() {
        this.terminate(3);
    }

    private void failedTask(TaskInProgress tip, TaskAttemptID taskid, TaskStatus status, TaskTracker taskTracker, boolean wasRunning, boolean wasComplete, boolean wasAttemptRunning) {
        TaskTrackerStatus taskTrackerStatus;
        JobTrackerInstrumentation metrics = this.jobtracker.getInstrumentation();
        boolean wasFailed = tip.isFailed();
        tip.incompleteSubTask(taskid, this.status);
        boolean isRunning = tip.isRunning();
        boolean isComplete = tip.isComplete();
        boolean metricsDone = this.isComplete();
        if (wasAttemptRunning) {
            if (!tip.isJobCleanupTask() && !tip.isJobSetupTask()) {
                if (tip.isMapTask() && !metricsDone) {
                    --this.runningMapTasks;
                    metrics.failedMap(taskid);
                    this.queueMetrics.failedMap(taskid);
                } else if (!metricsDone) {
                    --this.runningReduceTasks;
                    metrics.failedReduce(taskid);
                    this.queueMetrics.failedReduce(taskid);
                }
            }
            this.meterTaskAttempt(tip, status);
        }
        if (wasRunning && !isRunning) {
            if (tip.isJobCleanupTask()) {
                this.launchedCleanup = false;
            } else if (tip.isJobSetupTask()) {
                this.launchedSetup = false;
            } else if (tip.isMapTask()) {
                if (!isComplete) {
                    this.retireMap(tip);
                    this.failMap(tip);
                }
            } else if (!isComplete) {
                this.retireReduce(tip);
                this.failReduce(tip);
            }
        }
        if (wasComplete && !isComplete && tip.isMapTask()) {
            this.failMap(tip);
            --this.finishedMapTasks;
        }
        TaskStatus taskStatus = tip.getTaskStatus(taskid);
        String taskTrackerName = taskStatus.getTaskTracker();
        String taskTrackerHostName = JobInProgress.convertTrackerNameToHostName(taskTrackerName);
        int taskTrackerPort = -1;
        TaskTrackerStatus taskTrackerStatus2 = taskTrackerStatus = taskTracker == null ? null : taskTracker.getStatus();
        if (taskTrackerStatus != null) {
            taskTrackerPort = taskTrackerStatus.getHttpPort();
        }
        long startTime = taskStatus.getStartTime();
        long finishTime = taskStatus.getFinishTime();
        List<String> taskDiagnosticInfo = tip.getDiagnosticInfo(taskid);
        String diagInfo = taskDiagnosticInfo == null ? "" : StringUtils.arrayToString(taskDiagnosticInfo.toArray(new String[0]));
        String taskType = this.getTaskType(tip);
        if (taskStatus.getIsMap()) {
            JobHistory.MapAttempt.logStarted(taskid, startTime, taskTrackerName, taskTrackerPort, taskType);
            if (taskStatus.getRunState() == TaskStatus.State.FAILED) {
                JobHistory.MapAttempt.logFailed(taskid, finishTime, taskTrackerHostName, diagInfo, taskType);
            } else {
                JobHistory.MapAttempt.logKilled(taskid, finishTime, taskTrackerHostName, diagInfo, taskType);
            }
        } else {
            JobHistory.ReduceAttempt.logStarted(taskid, startTime, taskTrackerName, taskTrackerPort, taskType);
            if (taskStatus.getRunState() == TaskStatus.State.FAILED) {
                JobHistory.ReduceAttempt.logFailed(taskid, finishTime, taskTrackerHostName, diagInfo, taskType);
            } else {
                JobHistory.ReduceAttempt.logKilled(taskid, finishTime, taskTrackerHostName, diagInfo, taskType);
            }
        }
        if (!tip.isJobCleanupTask() && !tip.isJobSetupTask()) {
            if (tip.isMapTask()) {
                ++this.failedMapTasks;
            } else {
                ++this.failedReduceTasks;
            }
        }
        if (status.getRunState() == TaskStatus.State.FAILED) {
            this.addTrackerTaskFailure(taskTrackerName, taskTracker);
        }
        this.jobtracker.markCompletedTaskAttempt(status.getTaskTracker(), taskid);
        if (!wasFailed && tip.isFailed()) {
            boolean killJob;
            boolean bl = tip.isJobCleanupTask() || tip.isJobSetupTask() ? true : (tip.isMapTask() ? ++this.failedMapTIPs * 100 > this.mapFailuresPercent * this.numMapTasks : (killJob = ++this.failedReduceTIPs * 100 > this.reduceFailuresPercent * this.numReduceTasks));
            if (killJob) {
                String failureInfo = "";
                failureInfo = tip.isJobCleanupTask() ? "JobCleanup Task Failure, Task: " + tip.getTIPId() : (tip.isJobSetupTask() ? "JobSetup Task Failure, Task: " + tip.getTIPId() : (tip.isMapTask() ? "# of failed Map Tasks exceeded allowed limit. FailedCount: " + this.failedMapTIPs + ". LastFailedTask: " + tip.getTIPId() : "# of failed Reduce Tasks exceeded allowed limit. FailedCount: " + this.failedReduceTIPs + ". LastFailedTask: " + tip.getTIPId()));
                this.status.setFailureInfo(failureInfo);
                LOG.info((Object)("Aborting job " + this.profile.getJobID()));
                JobHistory.Task.logFailed(tip.getTIPId(), taskType, finishTime, diagInfo);
                if (tip.isJobCleanupTask()) {
                    if (tip.isMapTask()) {
                        this.cleanup[1].kill();
                    } else {
                        this.cleanup[0].kill();
                    }
                    this.terminateJob(3);
                } else {
                    if (tip.isJobSetupTask()) {
                        this.killSetupTip(!tip.isMapTask());
                    }
                    this.fail();
                }
            }
            if (!tip.isJobCleanupTask() && !tip.isJobSetupTask()) {
                if (tip.isMapTask()) {
                    this.jobCounters.incrCounter(Counter.NUM_FAILED_MAPS, 1L);
                } else {
                    this.jobCounters.incrCounter(Counter.NUM_FAILED_REDUCES, 1L);
                }
            }
        }
    }

    void killSetupTip(boolean isMap) {
        if (isMap) {
            this.setup[0].kill();
        } else {
            this.setup[1].kill();
        }
    }

    boolean isSetupFinished() {
        return this.setup[0].isComplete() || this.setup[0].isFailed() || this.setup[1].isComplete() || this.setup[1].isFailed();
    }

    public void failedTask(TaskInProgress tip, TaskAttemptID taskid, String reason, TaskStatus.Phase phase, TaskStatus.State state, String trackerName) {
        TaskStatus status = TaskStatus.createTaskStatus(tip.isMapTask(), taskid, 0.0f, tip.isMapTask() ? this.numSlotsPerMap : this.numSlotsPerReduce, state, reason, reason, trackerName, phase, new Counters());
        TaskStatus oldStatus = tip.getTaskStatus(taskid);
        long startTime = oldStatus == null ? this.jobtracker.getClock().getTime() : oldStatus.getStartTime();
        status.setStartTime(startTime);
        status.setFinishTime(this.jobtracker.getClock().getTime());
        boolean wasComplete = tip.isComplete();
        this.updateTaskStatus(tip, status);
        boolean isComplete = tip.isComplete();
        if (wasComplete && !isComplete) {
            String taskType = this.getTaskType(tip);
            JobHistory.Task.logFailed(tip.getTIPId(), taskType, tip.getExecFinishTime(), reason, taskid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void garbageCollect() {
        JobInProgress jobInProgress = this;
        synchronized (jobInProgress) {
            this.cancelReservedSlots();
            this.jobtracker.getInstrumentation().decWaitingMaps(this.getJobID(), this.pendingMaps());
            this.jobtracker.getInstrumentation().decWaitingReduces(this.getJobID(), this.pendingReduces());
            this.queueMetrics.decWaitingMaps(this.getJobID(), this.pendingMaps());
            this.queueMetrics.decWaitingReduces(this.getJobID(), this.pendingReduces());
            this.jobtracker.storeCompletedJob(this);
            this.jobtracker.finalizeJob(this);
            try {
                if (this.localJobFile != null) {
                    this.localFs.delete(this.localJobFile, true);
                    this.localJobFile = null;
                }
                Path tempDir = this.jobtracker.getSystemDirectoryForJob(this.getJobID());
                CleanupQueue.getInstance().addToQueue(new CleanupQueue.PathDeletionContext(tempDir, this.conf));
            }
            catch (IOException e) {
                LOG.warn((Object)("Error cleaning up " + this.profile.getJobID() + ": " + e));
            }
            this.cleanUpMetrics();
            this.failedMaps.clear();
            this.nonRunningMapCache = null;
            this.runningMapCache = null;
            this.nonRunningReduces = null;
            this.runningReduces = null;
        }
        if (this.conf.getBoolean("mapreduce.job.complete.cancel.delegation.tokens", true)) {
            DelegationTokenRenewal.removeDelegationTokenRenewalForJob(this.jobId);
        }
        try {
            this.fs.close();
        }
        catch (IOException ie) {
            LOG.warn((Object)("Ignoring exception " + StringUtils.stringifyException(ie) + " while closing FileSystem for " + this.userUGI));
        }
    }

    public synchronized TaskInProgress getTaskInProgress(TaskID tipid) {
        if (tipid.isMap()) {
            if (tipid.equals(this.cleanup[0].getTIPId())) {
                return this.cleanup[0];
            }
            if (tipid.equals(this.setup[0].getTIPId())) {
                return this.setup[0];
            }
            for (int i = 0; i < this.maps.length; ++i) {
                if (!tipid.equals(this.maps[i].getTIPId())) continue;
                return this.maps[i];
            }
        } else {
            if (tipid.equals(this.cleanup[1].getTIPId())) {
                return this.cleanup[1];
            }
            if (tipid.equals(this.setup[1].getTIPId())) {
                return this.setup[1];
            }
            for (int i = 0; i < this.reduces.length; ++i) {
                if (!tipid.equals(this.reduces[i].getTIPId())) continue;
                return this.reduces[i];
            }
        }
        return null;
    }

    public synchronized TaskStatus findFinishedMap(int mapId) {
        TaskInProgress tip = this.maps[mapId];
        if (tip.isComplete()) {
            TaskStatus[] statuses = tip.getTaskStatuses();
            for (int i = 0; i < statuses.length; ++i) {
                if (statuses[i].getRunState() != TaskStatus.State.SUCCEEDED) continue;
                return statuses[i];
            }
        }
        return null;
    }

    synchronized int getNumTaskCompletionEvents() {
        return this.taskCompletionEvents.size();
    }

    public synchronized TaskCompletionEvent[] getTaskCompletionEvents(int fromEventId, int maxEvents) {
        TaskCompletionEvent[] events = TaskCompletionEvent.EMPTY_ARRAY;
        if (this.taskCompletionEvents.size() > fromEventId) {
            int actualMax = Math.min(maxEvents, this.taskCompletionEvents.size() - fromEventId);
            events = this.taskCompletionEvents.subList(fromEventId, actualMax + fromEventId).toArray(events);
        }
        return events;
    }

    synchronized void fetchFailureNotification(TaskInProgress tip, TaskAttemptID mapTaskId, String mapTrackerName, TaskAttemptID reduceTaskId, String reduceTrackerName) {
        boolean isMapFaulty;
        Integer fetchFailures = this.mapTaskIdToFetchFailuresMap.get(mapTaskId);
        fetchFailures = fetchFailures == null ? 1 : fetchFailures + 1;
        this.mapTaskIdToFetchFailuresMap.put(mapTaskId, fetchFailures);
        LOG.info((Object)("Failed fetch notification #" + fetchFailures + " for map task: " + mapTaskId + " running on tracker: " + mapTrackerName + " and reduce task: " + reduceTaskId + " running on tracker: " + reduceTrackerName));
        float failureRate = (float)fetchFailures.intValue() / (float)this.runningReduceTasks;
        boolean bl = isMapFaulty = (double)failureRate >= 0.5;
        if (fetchFailures >= 3 && isMapFaulty) {
            LOG.info((Object)("Too many fetch-failures for output of task: " + mapTaskId + " ... killing it"));
            this.failedTask(tip, mapTaskId, "Too many fetch-failures", tip.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.REDUCE, TaskStatus.State.FAILED, mapTrackerName);
            this.mapTaskIdToFetchFailuresMap.remove(mapTaskId);
        }
    }

    public JobID getJobID() {
        return this.jobId;
    }

    public String getJobSubmitHostName() {
        return this.submitHostName;
    }

    public String getJobSubmitHostAddress() {
        return this.submitHostAddress;
    }

    public synchronized Object getSchedulingInfo() {
        return this.schedulingInfo;
    }

    public synchronized void setSchedulingInfo(Object schedulingInfo) {
        this.schedulingInfo = schedulingInfo;
        this.status.setSchedulingInfo(schedulingInfo.toString());
    }

    boolean isComplete() {
        return this.status.isJobComplete();
    }

    private String getTaskType(TaskInProgress tip) {
        if (tip.isJobCleanupTask()) {
            return JobHistory.Values.CLEANUP.name();
        }
        if (tip.isJobSetupTask()) {
            return JobHistory.Values.SETUP.name();
        }
        if (tip.isMapTask()) {
            return JobHistory.Values.MAP.name();
        }
        return JobHistory.Values.REDUCE.name();
    }

    void setClusterSize(int clusterSize) {
        this.clusterSize = clusterSize;
    }

    private void generateAndStoreTokens() throws IOException {
        Path jobDir = this.jobtracker.getSystemDirectoryForJob(this.jobId);
        Path keysFile = new Path(jobDir, "jobToken");
        if (this.tokenStorage == null) {
            this.tokenStorage = new Credentials();
        }
        JobTokenIdentifier identifier = new JobTokenIdentifier(new Text(this.jobId.toString()));
        Token<JobTokenIdentifier> token = new Token<JobTokenIdentifier>(identifier, this.jobtracker.getJobTokenSecretManager());
        token.setService(identifier.getJobId());
        TokenCache.setJobToken(token, this.tokenStorage);
        this.tokenStorage.writeTokenStorageFile(keysFile, this.jobtracker.getConf());
        LOG.info((Object)("jobToken generated and stored with users keys in " + keysFile.toUri().getPath()));
    }

    int getLocalityLevel(TaskInProgress tip, TaskTrackerStatus tts) {
        Node tracker = this.jobtracker.getNode(tts.getHost());
        int level = this.maxLevel;
        for (String local : this.maps[tip.getIdWithinJob()].getSplitLocations()) {
            Node datanode = this.jobtracker.getNode(local);
            int newLevel = this.maxLevel;
            if (tracker != null && datanode != null) {
                newLevel = this.getMatchingLevelForNodes(tracker, datanode);
            }
            if (newLevel < level && (level = newLevel) == 0) break;
        }
        return level;
    }

    static class JobSummary {
        static final Log LOG = LogFactory.getLog(JobSummary.class);
        static final char EQUALS = '=';
        static final char[] charsToEscape = new char[]{',', '=', '\\'};

        JobSummary() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static SummaryBuilder getTaskLaunchTimesSummary(JobInProgress job) {
            Map<TaskType, Long> timeMap;
            SummaryBuilder summary = new SummaryBuilder();
            Map<TaskType, Long> map2 = timeMap = job.getFirstTaskLaunchTimes();
            synchronized (map2) {
                for (Map.Entry<TaskType, Long> e : timeMap.entrySet()) {
                    summary.add("first" + StringUtils.camelize(e.getKey().name()) + "TaskLaunchTime", e.getValue());
                }
            }
            return summary;
        }

        public static void logJobSummary(JobInProgress job, ClusterStatus cluster) {
            JobStatus status = job.getStatus();
            JobProfile profile = job.getProfile();
            Counters jobCounters = job.getJobCounters();
            long mapSlotSeconds = (jobCounters.getCounter(Counter.SLOTS_MILLIS_MAPS) + jobCounters.getCounter(Counter.FALLOW_SLOTS_MILLIS_MAPS)) / 1000L;
            long reduceSlotSeconds = (jobCounters.getCounter(Counter.SLOTS_MILLIS_REDUCES) + jobCounters.getCounter(Counter.FALLOW_SLOTS_MILLIS_REDUCES)) / 1000L;
            SummaryBuilder summary = new SummaryBuilder().add("jobId", job.getJobID()).add("submitTime", job.getStartTime()).add("launchTime", job.getLaunchTime()).add(JobSummary.getTaskLaunchTimesSummary(job)).add("finishTime", job.getFinishTime()).add("numMaps", job.getTasks(TaskType.MAP).length).add("numSlotsPerMap", job.getNumSlotsPerMap()).add("numReduces", job.getTasks(TaskType.REDUCE).length).add("numSlotsPerReduce", job.getNumSlotsPerReduce()).add("user", profile.getUser()).add("queue", profile.getQueueName()).add("status", JobStatus.getJobRunState(status.getRunState())).add("mapSlotSeconds", mapSlotSeconds).add("reduceSlotsSeconds", reduceSlotSeconds).add("clusterMapCapacity", cluster.getMaxMapTasks()).add("clusterReduceCapacity", cluster.getMaxReduceTasks());
            LOG.info((Object)summary);
        }

        static class SummaryBuilder {
            final StringBuilder buffer = new StringBuilder();

            SummaryBuilder() {
            }

            SummaryBuilder add(String key, long value) {
                return this._add(key, Long.toString(value));
            }

            <T> SummaryBuilder add(String key, T value) {
                return this._add(key, StringUtils.escapeString(String.valueOf(value), '\\', charsToEscape));
            }

            SummaryBuilder add(SummaryBuilder summary) {
                if (this.buffer.length() > 0) {
                    this.buffer.append(',');
                }
                this.buffer.append((CharSequence)summary.buffer);
                return this;
            }

            SummaryBuilder _add(String key, String value) {
                if (this.buffer.length() > 0) {
                    this.buffer.append(',');
                }
                this.buffer.append(key).append('=').append(value);
                return this;
            }

            public String toString() {
                return this.buffer.toString();
            }
        }
    }

    private static class JobInitKillStatus {
        boolean killed;
        boolean initStarted;
        boolean initDone;

        private JobInitKillStatus() {
        }
    }

    private static class FallowSlotInfo {
        long timestamp;
        int numSlots;

        public FallowSlotInfo(long timestamp, int numSlots) {
            this.timestamp = timestamp;
            this.numSlots = numSlots;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public int getNumSlots() {
            return this.numSlots;
        }

        public void setNumSlots(int numSlots) {
            this.numSlots = numSlots;
        }
    }

    public static enum Counter {
        NUM_FAILED_MAPS,
        NUM_FAILED_REDUCES,
        TOTAL_LAUNCHED_MAPS,
        TOTAL_LAUNCHED_REDUCES,
        OTHER_LOCAL_MAPS,
        DATA_LOCAL_MAPS,
        RACK_LOCAL_MAPS,
        SLOTS_MILLIS_MAPS,
        SLOTS_MILLIS_REDUCES,
        FALLOW_SLOTS_MILLIS_MAPS,
        FALLOW_SLOTS_MILLIS_REDUCES;

    }

    static class KillInterruptedException
    extends InterruptedException {
        public KillInterruptedException(String msg) {
            super(msg);
        }
    }
}

