/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskID;

class MapOutputFile {
    private JobConf conf;
    static final String REDUCE_INPUT_FILE_FORMAT_STRING = "%s/map_%d.out";
    private LocalDirAllocator lDirAlloc = new LocalDirAllocator("mapred.local.dir");

    MapOutputFile() {
    }

    public Path getOutputFile() throws IOException {
        return this.lDirAlloc.getLocalPathToRead("output/file.out", this.conf);
    }

    public Path getOutputFileForWrite(long size2) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite("output/file.out", size2, this.conf);
    }

    public Path getOutputIndexFile() throws IOException {
        return this.lDirAlloc.getLocalPathToRead("output/file.out.index", this.conf);
    }

    public Path getOutputIndexFileForWrite(long size2) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite("output/file.out.index", size2, this.conf);
    }

    public Path getSpillFile(int spillNumber) throws IOException {
        return this.lDirAlloc.getLocalPathToRead("output/spill" + spillNumber + ".out", this.conf);
    }

    public Path getSpillFileForWrite(int spillNumber, long size2) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite("output/spill" + spillNumber + ".out", size2, this.conf);
    }

    public Path getSpillIndexFile(int spillNumber) throws IOException {
        return this.lDirAlloc.getLocalPathToRead("output/spill" + spillNumber + ".out.index", this.conf);
    }

    public Path getSpillIndexFileForWrite(int spillNumber, long size2) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite("output/spill" + spillNumber + ".out.index", size2, this.conf);
    }

    public Path getInputFile(int mapId) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(String.format(REDUCE_INPUT_FILE_FORMAT_STRING, "output", mapId), this.conf);
    }

    public Path getInputFileForWrite(TaskID mapId, long size2) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(String.format(REDUCE_INPUT_FILE_FORMAT_STRING, "output", mapId.getId()), size2, this.conf);
    }

    public void removeAll() throws IOException {
        this.conf.deleteLocalFiles("output");
    }

    public void setConf(Configuration conf) {
        this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
    }
}

