/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskTracker;

class ReduceTaskRunner
extends TaskRunner {
    public ReduceTaskRunner(TaskTracker.TaskInProgress task2, TaskTracker tracker, JobConf conf, TaskTracker.RunningJob rjob) throws IOException {
        super(task2, tracker, conf, rjob);
    }

    @Override
    public boolean prepare() throws IOException {
        if (!super.prepare()) {
            return false;
        }
        this.mapOutputFile.removeAll();
        return true;
    }

    @Override
    public void close() throws IOException {
        LOG.info((Object)(this.getTask() + " done; removing files."));
        this.getTask().getProgress().setStatus("closed");
        this.mapOutputFile.removeAll();
    }

    @Override
    public String getChildJavaOpts(JobConf jobConf, String defaultValue) {
        String user = jobConf.get("mapred.reduce.child.java.opts", super.getChildJavaOpts(jobConf, "-Xmx200m"));
        String admin = jobConf.get("mapreduce.admin.reduce.child.java.opts", "-Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN ");
        return user + " " + admin;
    }

    @Override
    public int getChildUlimit(JobConf jobConf) {
        return jobConf.getInt("mapred.reduce.child.ulimit", super.getChildUlimit(jobConf));
    }

    @Override
    public String getChildEnv(JobConf jobConf) {
        return jobConf.get("mapred.reduce.child.env", super.getChildEnv(jobConf));
    }
}

