/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.SaslInputStream;
import org.apache.hadoop.security.SaslOutputStream;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

public class SaslRpcClient {
    public static final Log LOG = LogFactory.getLog(SaslRpcClient.class);
    private final SaslClient saslClient;

    public SaslRpcClient(SaslRpcServer.AuthMethod method, Token<? extends TokenIdentifier> token, String serverPrincipal) throws IOException {
        switch (method) {
            case DIGEST: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Creating SASL " + SaslRpcServer.AuthMethod.DIGEST.getMechanismName() + " client to authenticate to service at " + token.getService()));
                }
                this.saslClient = Sasl.createSaslClient(new String[]{SaslRpcServer.AuthMethod.DIGEST.getMechanismName()}, null, null, "default", SaslRpcServer.SASL_PROPS, new SaslClientCallbackHandler(token));
                break;
            }
            case KERBEROS: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Creating SASL " + SaslRpcServer.AuthMethod.KERBEROS.getMechanismName() + " client. Server's Kerberos principal name is " + serverPrincipal));
                }
                if (serverPrincipal == null || serverPrincipal.length() == 0) {
                    throw new IOException("Failed to specify server's Kerberos principal name");
                }
                String[] names = SaslRpcServer.splitKerberosName(serverPrincipal);
                if (names.length != 3) {
                    throw new IOException("Kerberos principal name does NOT have the expected hostname part: " + serverPrincipal);
                }
                this.saslClient = Sasl.createSaslClient(new String[]{SaslRpcServer.AuthMethod.KERBEROS.getMechanismName()}, null, names[0], names[1], SaslRpcServer.SASL_PROPS, null);
                break;
            }
            default: {
                throw new IOException("Unknown authentication method " + (Object)((Object)method));
            }
        }
        if (this.saslClient == null) {
            throw new IOException("Unable to find SASL client implementation");
        }
    }

    private static void readStatus(DataInputStream inStream) throws IOException {
        int status = inStream.readInt();
        if (status != SaslRpcServer.SaslStatus.SUCCESS.state) {
            throw new RemoteException(WritableUtils.readString(inStream), WritableUtils.readString(inStream));
        }
    }

    public boolean saslConnect(InputStream inS, OutputStream outS) throws IOException {
        DataInputStream inStream = new DataInputStream(new BufferedInputStream(inS));
        DataOutputStream outStream = new DataOutputStream(new BufferedOutputStream(outS));
        try {
            byte[] saslToken = new byte[]{};
            if (this.saslClient.hasInitialResponse()) {
                saslToken = this.saslClient.evaluateChallenge(saslToken);
            }
            if (saslToken != null) {
                outStream.writeInt(saslToken.length);
                outStream.write(saslToken, 0, saslToken.length);
                outStream.flush();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Have sent token of size " + saslToken.length + " from initSASLContext."));
                }
            }
            if (!this.saslClient.isComplete()) {
                SaslRpcClient.readStatus(inStream);
                int len = inStream.readInt();
                if (len == -88) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Server asks us to fall back to simple auth.");
                    }
                    this.saslClient.dispose();
                    return false;
                }
                saslToken = new byte[len];
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Will read input token of size " + saslToken.length + " for processing by initSASLContext"));
                }
                inStream.readFully(saslToken);
            }
            while (!this.saslClient.isComplete()) {
                if ((saslToken = this.saslClient.evaluateChallenge(saslToken)) != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Will send token of size " + saslToken.length + " from initSASLContext."));
                    }
                    outStream.writeInt(saslToken.length);
                    outStream.write(saslToken, 0, saslToken.length);
                    outStream.flush();
                }
                if (this.saslClient.isComplete()) continue;
                SaslRpcClient.readStatus(inStream);
                saslToken = new byte[inStream.readInt()];
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Will read input token of size " + saslToken.length + " for processing by initSASLContext"));
                }
                inStream.readFully(saslToken);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("SASL client context established. Negotiated QoP: " + this.saslClient.getNegotiatedProperty("javax.security.sasl.qop")));
            }
            return true;
        }
        catch (IOException e) {
            try {
                this.saslClient.dispose();
            }
            catch (SaslException ignored) {
                // empty catch block
            }
            throw e;
        }
    }

    public InputStream getInputStream(InputStream in) throws IOException {
        if (!this.saslClient.isComplete()) {
            throw new IOException("Sasl authentication exchange hasn't completed yet");
        }
        return new SaslInputStream(in, this.saslClient);
    }

    public OutputStream getOutputStream(OutputStream out) throws IOException {
        if (!this.saslClient.isComplete()) {
            throw new IOException("Sasl authentication exchange hasn't completed yet");
        }
        return new SaslOutputStream(out, this.saslClient);
    }

    public void dispose() throws SaslException {
        this.saslClient.dispose();
    }

    private static class SaslClientCallbackHandler
    implements CallbackHandler {
        private final String userName;
        private final char[] userPassword;

        public SaslClientCallbackHandler(Token<? extends TokenIdentifier> token) {
            this.userName = SaslRpcServer.encodeIdentifier(token.getIdentifier());
            this.userPassword = SaslRpcServer.encodePassword(token.getPassword());
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            NameCallback nc = null;
            PasswordCallback pc = null;
            TextInputCallback rc = null;
            for (Callback callback2 : callbacks) {
                if (callback2 instanceof RealmChoiceCallback) continue;
                if (callback2 instanceof NameCallback) {
                    nc = (NameCallback)callback2;
                    continue;
                }
                if (callback2 instanceof PasswordCallback) {
                    pc = (PasswordCallback)callback2;
                    continue;
                }
                if (callback2 instanceof RealmCallback) {
                    rc = (RealmCallback)callback2;
                    continue;
                }
                throw new UnsupportedCallbackException(callback2, "Unrecognized SASL client callback");
            }
            if (nc != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SASL client callback: setting username: " + this.userName));
                }
                nc.setName(this.userName);
            }
            if (pc != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"SASL client callback: setting userPassword");
                }
                pc.setPassword(this.userPassword);
            }
            if (rc != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SASL client callback: setting realm: " + rc.getDefaultText()));
                }
                rc.setText(rc.getDefaultText());
            }
        }
    }
}

