/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import java.net.URI;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.Service;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.ra.ActiveMQConnectionSupport;
import org.apache.activemq.ra.ActiveMQEndpointActivationKey;
import org.apache.activemq.ra.ActiveMQEndpointWorker;
import org.apache.activemq.ra.MessageActivationSpec;
import org.apache.activemq.ra.MessageResourceAdapter;
import org.apache.activemq.util.ServiceSupport;

public class ActiveMQResourceAdapter
extends ActiveMQConnectionSupport
implements MessageResourceAdapter {
    private final HashMap<ActiveMQEndpointActivationKey, ActiveMQEndpointWorker> endpointWorkers = new HashMap();
    private BootstrapContext bootstrapContext;
    private String brokerXmlConfig;
    private BrokerService broker;
    private Thread brokerStartThread;
    private ActiveMQConnectionFactory connectionFactory;

    public void start(BootstrapContext bootstrapContext) throws ResourceAdapterInternalException {
        this.bootstrapContext = bootstrapContext;
        if (this.brokerXmlConfig != null && this.brokerXmlConfig.trim().length() > 0) {
            this.brokerStartThread = new Thread("Starting ActiveMQ Broker"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        ActiveMQResourceAdapter activeMQResourceAdapter = ActiveMQResourceAdapter.this;
                        synchronized (activeMQResourceAdapter) {
                            ActiveMQResourceAdapter.this.broker = BrokerFactory.createBroker((URI)new URI(ActiveMQResourceAdapter.this.brokerXmlConfig));
                        }
                        ActiveMQResourceAdapter.this.broker.start();
                    }
                    catch (Throwable e) {
                        ActiveMQResourceAdapter.this.log.warn((Object)("Could not start up embeded ActiveMQ Broker '" + ActiveMQResourceAdapter.this.brokerXmlConfig + "': " + e.getMessage()));
                        ActiveMQResourceAdapter.this.log.debug((Object)("Reason for: " + e.getMessage()), e);
                    }
                }
            };
            this.brokerStartThread.setDaemon(true);
            this.brokerStartThread.start();
            try {
                this.brokerStartThread.join(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public ActiveMQConnection makeConnection() throws JMSException {
        if (this.connectionFactory == null) {
            return this.makeConnection(this.getInfo());
        }
        return this.makeConnection(this.getInfo(), this.connectionFactory);
    }

    public ActiveMQConnection makeConnection(MessageActivationSpec activationSpec) throws JMSException {
        ActiveMQConnectionFactory connectionFactory = this.connectionFactory;
        if (connectionFactory == null) {
            connectionFactory = this.createConnectionFactory(this.getInfo());
        }
        String userName = this.defaultValue(activationSpec.getUserName(), this.getInfo().getUserName());
        String password = this.defaultValue(activationSpec.getPassword(), this.getInfo().getPassword());
        String clientId = activationSpec.getClientId();
        if (clientId != null) {
            connectionFactory.setClientID(clientId);
        } else if (activationSpec.isDurableSubscription()) {
            this.log.warn((Object)("No clientID specified for durable subscription: " + activationSpec));
        }
        ActiveMQConnection physicalConnection = (ActiveMQConnection)connectionFactory.createConnection(userName, password);
        RedeliveryPolicy redeliveryPolicy = activationSpec.redeliveryPolicy();
        if (redeliveryPolicy != null) {
            physicalConnection.setRedeliveryPolicy(redeliveryPolicy);
        }
        return physicalConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        while (this.endpointWorkers.size() > 0) {
            ActiveMQEndpointActivationKey key = this.endpointWorkers.keySet().iterator().next();
            this.endpointDeactivation(key.getMessageEndpointFactory(), key.getActivationSpec());
        }
        ActiveMQResourceAdapter activeMQResourceAdapter = this;
        synchronized (activeMQResourceAdapter) {
            if (this.broker != null) {
                if (this.brokerStartThread.isAlive()) {
                    this.brokerStartThread.interrupt();
                }
                ServiceSupport.dispose((Service)this.broker);
                this.broker = null;
            }
        }
        this.bootstrapContext = null;
    }

    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec activationSpec) throws ResourceException {
        if (!this.equals(activationSpec.getResourceAdapter())) {
            throw new ResourceException("Activation spec not initialized with this ResourceAdapter instance (" + activationSpec.getResourceAdapter() + " != " + this + ")");
        }
        if (!(activationSpec instanceof MessageActivationSpec)) {
            throw new NotSupportedException("That type of ActicationSpec not supported: " + activationSpec.getClass());
        }
        ActiveMQEndpointActivationKey key = new ActiveMQEndpointActivationKey(endpointFactory, (MessageActivationSpec)activationSpec);
        if (this.endpointWorkers.containsKey(key)) {
            throw new IllegalStateException("Endpoint previously activated");
        }
        ActiveMQEndpointWorker worker = new ActiveMQEndpointWorker(this, key);
        this.endpointWorkers.put(key, worker);
        worker.start();
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec activationSpec) {
        if (activationSpec instanceof MessageActivationSpec) {
            ActiveMQEndpointActivationKey key = new ActiveMQEndpointActivationKey(endpointFactory, (MessageActivationSpec)activationSpec);
            ActiveMQEndpointWorker worker = this.endpointWorkers.remove(key);
            if (worker == null) {
                return;
            }
            try {
                worker.stop();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] activationSpecs) throws ResourceException {
        XAResource[] session2;
        ActiveMQConnection connection = null;
        try {
            connection = this.makeConnection();
            if (connection instanceof XAConnection) {
                XASession session2 = ((XAConnection)connection).createXASession();
                XAResource xaResource = session2.getXAResource();
                XAResource[] xAResourceArray = new XAResource[]{xaResource};
                return xAResourceArray;
            }
            session2 = new XAResource[]{};
        }
        catch (JMSException e) {
            throw new ResourceException((Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (Throwable ignore) {}
        }
        return session2;
    }

    public String getBrokerXmlConfig() {
        return this.brokerXmlConfig;
    }

    public void setBrokerXmlConfig(String brokerXmlConfig) {
        this.brokerXmlConfig = brokerXmlConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessageResourceAdapter)) {
            return false;
        }
        MessageResourceAdapter activeMQResourceAdapter = (MessageResourceAdapter)o;
        if (!this.getInfo().equals(activeMQResourceAdapter.getInfo())) {
            return false;
        }
        return !this.notEqual(this.brokerXmlConfig, activeMQResourceAdapter.getBrokerXmlConfig());
    }

    public int hashCode() {
        int result = this.getInfo().hashCode();
        if (this.brokerXmlConfig != null) {
            result ^= this.brokerXmlConfig.hashCode();
        }
        return result;
    }

    public ActiveMQConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ActiveMQConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }
}

