/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Session;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectiveMBeanRegistrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(SelectiveMBeanRegistrationTest.class);
    BrokerService brokerService;
    protected MBeanServer mbeanServer;
    protected String domain = "org.apache.activemq";
    protected ConnectionFactory connectionFactory;
    protected Connection connection;
    protected boolean transacted;

    @Before
    public void createBroker() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
        this.brokerService.setUseJmx(true);
        ManagementContext managementContext = new ManagementContext();
        managementContext.setCreateConnector(false);
        managementContext.setSuppressMBean("endpoint=dynamicProducer,endpoint=Consumer");
        this.brokerService.setManagementContext(managementContext);
        this.brokerService.start();
        this.connectionFactory = new ActiveMQConnectionFactory("vm://localhost");
        this.mbeanServer = managementContext.getMBeanServer();
    }

    @Test
    public void testSuppression() throws Exception {
        this.connection = this.connectionFactory.createConnection("admin", "admin");
        this.connection.setClientID("MBeanTest");
        Session session = this.connection.createSession(false, 1);
        Queue queue = session.createQueue("AQueue");
        session.createConsumer((Destination)queue);
        ObjectName brokerName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost");
        final BrokerViewMBean broker = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, brokerName, BrokerViewMBean.class, true);
        Assert.assertTrue((String)"one sub", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return broker.getQueueSubscribers().length == 1;
            }
        }));
        Assert.assertFalse((boolean)this.mbeanServer.isRegistered(broker.getQueueSubscribers()[0]));
        session.createProducer(null);
        Assert.assertTrue((String)"one sub", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return broker.getDynamicDestinationProducers().length == 1;
            }
        }));
        ObjectName query = new ObjectName(this.domain + ":type=Broker,brokerName=localhost,endpoint=dynamicProducer,*");
        Set<ObjectInstance> mbeans = this.mbeanServer.queryMBeans(query, null);
        Assert.assertEquals((long)0L, (long)mbeans.size());
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        if (this.brokerService != null) {
            this.brokerService.stop();
        }
    }

    protected ObjectName assertRegisteredObjectName(String name) throws Exception {
        final ObjectName objectName = new ObjectName(name);
        final AtomicBoolean result = new AtomicBoolean(false);
        Assert.assertTrue((String)("Bean registered: " + objectName), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                try {
                    result.set(SelectiveMBeanRegistrationTest.this.mbeanServer.isRegistered(objectName));
                }
                catch (Exception ignored) {
                    LOG.debug(ignored.toString());
                }
                return result.get();
            }
        }));
        return objectName;
    }
}

