/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DestinationGCTest {
    private final ActiveMQQueue queue = new ActiveMQQueue("TEST");
    private final ActiveMQQueue otherQueue = new ActiveMQQueue("TEST-OTHER");
    private BrokerService brokerService;

    @Before
    public void setUp() throws Exception {
        this.brokerService = this.createBroker();
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
    }

    @After
    public void tearDown() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
            this.brokerService.waitUntilStopped();
        }
    }

    protected BrokerService createBroker() throws Exception {
        PolicyEntry entry = new PolicyEntry();
        entry.setGcInactiveDestinations(true);
        entry.setInactiveTimeoutBeforeGC(3000L);
        PolicyMap map = new PolicyMap();
        map.setDefaultEntry(entry);
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        broker.setUseJmx(true);
        broker.setDestinations(new ActiveMQDestination[]{this.queue});
        broker.setSchedulePeriodForDestinationPurge(1000);
        broker.setMaxPurgedDestinationsPerSweep(1);
        broker.setDestinationPolicy(map);
        return broker;
    }

    @Test(timeout=60000L)
    public void testDestinationGCWithActiveConsumers() throws Exception {
        Assert.assertEquals((long)1L, (long)this.brokerService.getAdminView().getQueues().length);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost?create=false");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        session.createProducer((Destination)this.otherQueue).close();
        MessageConsumer consumer = session.createConsumer((Destination)this.queue);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
            }
        });
        connection.start();
        Assert.assertTrue((String)"After GC runs there should be one Queue.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return DestinationGCTest.this.brokerService.getAdminView().getQueues().length == 1;
            }
        }));
        connection.close();
    }

    @Test(timeout=60000L)
    public void testDestinationGc() throws Exception {
        Assert.assertEquals((long)1L, (long)this.brokerService.getAdminView().getQueues().length);
        Assert.assertTrue((String)"After GC runs the Queue should be empty.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return DestinationGCTest.this.brokerService.getAdminView().getQueues().length == 0;
            }
        }));
    }

    @Test(timeout=60000L)
    public void testDestinationGcLimit() throws Exception {
        this.brokerService.getAdminView().addQueue("TEST1");
        this.brokerService.getAdminView().addQueue("TEST2");
        this.brokerService.getAdminView().addQueue("TEST3");
        this.brokerService.getAdminView().addQueue("TEST4");
        Assert.assertEquals((long)5L, (long)this.brokerService.getAdminView().getQueues().length);
        Thread.sleep(7000L);
        int queues = this.brokerService.getAdminView().getQueues().length;
        Assert.assertTrue((queues > 0 && queues < 5 ? 1 : 0) != 0);
        Assert.assertTrue((String)"After GC runs the Queue should be empty.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return DestinationGCTest.this.brokerService.getAdminView().getQueues().length == 0;
            }
        }));
    }
}

