/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerMBeanSupport;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ5274Test {
    private static Logger LOG = LoggerFactory.getLogger(AMQ5274Test.class);
    private String activemqURL;
    private BrokerService brokerService;
    private final ActiveMQQueue dest = new ActiveMQQueue("TestQ");

    @Before
    public void startBroker() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
        this.brokerService.getManagementContext().setCreateConnector(false);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultPolicy = new PolicyEntry();
        defaultPolicy.setExpireMessagesPeriod(1000L);
        policyMap.setDefaultEntry(defaultPolicy);
        this.brokerService.setDestinationPolicy(policyMap);
        this.activemqURL = this.brokerService.addConnector("tcp://localhost:0").getPublishableConnectString();
        this.brokerService.start();
    }

    @After
    public void stopBroker() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
        }
    }

    @Test
    public void test() throws Exception {
        LOG.info("Starting Test");
        Assert.assertTrue((boolean)this.brokerService.isStarted());
        this.produce();
        this.consumeAndRollback();
        long queueSize = this.getQueueSize();
        Assert.assertEquals((String)("Queue " + this.dest.getPhysicalName() + " not empty, reporting " + queueSize + " messages."), (long)0L, (long)queueSize);
    }

    private void consumeAndRollback() throws JMSException, InterruptedException {
        Message m;
        ActiveMQConnection connection = this.createConnection();
        RedeliveryPolicy noRedelivery = new RedeliveryPolicy();
        noRedelivery.setMaximumRedeliveries(0);
        connection.setRedeliveryPolicy(noRedelivery);
        connection.start();
        Session session = connection.createSession(true, 0);
        MessageConsumer consumer = session.createConsumer((Destination)this.dest);
        while ((m = consumer.receive(4000L)) != null) {
            LOG.info("Got:" + m);
            TimeUnit.SECONDS.sleep(1L);
            session.rollback();
        }
        connection.close();
    }

    private void produce() throws Exception {
        ActiveMQConnection connection = this.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)this.dest);
        producer.setTimeToLive(10000L);
        for (int i = 0; i < 20; ++i) {
            producer.send((Message)session.createTextMessage("i=" + i));
        }
        connection.close();
    }

    private ActiveMQConnection createConnection() throws JMSException {
        return (ActiveMQConnection)new ActiveMQConnectionFactory(this.activemqURL).createConnection();
    }

    public long getQueueSize() throws Exception {
        long queueSize = 0L;
        try {
            QueueViewMBean queueViewMBean = (QueueViewMBean)this.brokerService.getManagementContext().newProxyInstance(BrokerMBeanSupport.createDestinationName((ObjectName)this.brokerService.getBrokerObjectName(), (ActiveMQDestination)this.dest), QueueViewMBean.class, false);
            queueSize = queueViewMBean.getQueueSize();
            LOG.info("QueueSize for destination {} is {}", (Object)this.dest, (Object)queueSize);
        }
        catch (Exception ex) {
            LOG.error("Error retrieving QueueSize from JMX ", (Throwable)ex);
            throw ex;
        }
        return queueSize;
    }
}

