/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQMapMessageTest {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQMapMessageTest.class);
    private final String name = "testName";

    @Test(timeout=10000L)
    public void testBytesConversion() throws JMSException, IOException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        msg.setBoolean("boolean", true);
        msg.setByte("byte", (byte)1);
        msg.setBytes("bytes", new byte[1]);
        msg.setChar("char", 'a');
        msg.setDouble("double", 1.5);
        msg.setFloat("float", 1.5f);
        msg.setInt("int", 1);
        msg.setLong("long", 1L);
        msg.setObject("object", (Object)"stringObj");
        msg.setShort("short", (short)1);
        msg.setString("string", "string");
        StringBuffer bigSB = new StringBuffer(0x100000);
        for (int i = 0; i < 0x100000; ++i) {
            bigSB.append(97 + i % 26);
        }
        String bigString = bigSB.toString();
        msg.setString("bigString", bigString);
        msg = (ActiveMQMapMessage)msg.copy();
        Assert.assertEquals((Object)msg.getBoolean("boolean"), (Object)true);
        Assert.assertEquals((long)msg.getByte("byte"), (long)1L);
        Assert.assertEquals((long)msg.getBytes("bytes").length, (long)1L);
        Assert.assertEquals((long)msg.getChar("char"), (long)97L);
        Assert.assertEquals((double)msg.getDouble("double"), (double)1.5, (double)0.0);
        Assert.assertEquals((float)msg.getFloat("float"), (float)1.5f, (float)0.0f);
        Assert.assertEquals((long)msg.getInt("int"), (long)1L);
        Assert.assertEquals((long)msg.getLong("long"), (long)1L);
        Assert.assertEquals((Object)msg.getObject("object"), (Object)"stringObj");
        Assert.assertEquals((long)msg.getShort("short"), (long)1L);
        Assert.assertEquals((Object)msg.getString("string"), (Object)"string");
        Assert.assertEquals((Object)msg.getString("bigString"), (Object)bigString);
    }

    @Test(timeout=10000L)
    public void testGetBoolean() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        msg.setBoolean("testName", true);
        msg.setReadOnlyBody(true);
        Assert.assertTrue((boolean)msg.getBoolean("testName"));
        msg.clearBody();
        msg.setString("testName", "true");
        msg = (ActiveMQMapMessage)msg.copy();
        Assert.assertTrue((boolean)msg.getBoolean("testName"));
    }

    @Test(timeout=10000L)
    public void testGetByte() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        msg.setByte(this.name, (byte)1);
        msg = (ActiveMQMapMessage)msg.copy();
        Assert.assertTrue((msg.getByte(this.name) == 1 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testGetShort() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        msg.setShort(this.name, (short)1);
        msg = (ActiveMQMapMessage)msg.copy();
        Assert.assertTrue((msg.getShort(this.name) == 1 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testGetChar() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        msg.setChar(this.name, 'a');
        msg = (ActiveMQMapMessage)msg.copy();
        Assert.assertTrue((msg.getChar(this.name) == 'a' ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testGetInt() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        msg.setInt(this.name, 1);
        msg = (ActiveMQMapMessage)msg.copy();
        Assert.assertTrue((msg.getInt(this.name) == 1 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testGetLong() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        msg.setLong(this.name, 1L);
        msg = (ActiveMQMapMessage)msg.copy();
        Assert.assertTrue((msg.getLong(this.name) == 1L ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testGetFloat() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        msg.setFloat(this.name, 1.5f);
        msg = (ActiveMQMapMessage)msg.copy();
        Assert.assertTrue((msg.getFloat(this.name) == 1.5f ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testGetDouble() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        msg.setDouble(this.name, 1.5);
        msg = (ActiveMQMapMessage)msg.copy();
        Assert.assertTrue((msg.getDouble(this.name) == 1.5 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testGetDoubleWithMaxValue() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        msg.setDouble(this.name, Double.MAX_VALUE);
        msg = (ActiveMQMapMessage)msg.copy();
        Assert.assertEquals((double)Double.MAX_VALUE, (double)msg.getDouble(this.name), (double)1.0);
    }

    @Test(timeout=10000L)
    public void testGetDoubleWithMaxValueAsString() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        msg.setString(this.name, String.valueOf(Double.MAX_VALUE));
        msg = (ActiveMQMapMessage)msg.copy();
        Assert.assertEquals((double)Double.MAX_VALUE, (double)msg.getDouble(this.name), (double)1.0);
    }

    @Test(timeout=10000L)
    public void testGetString() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        String str = "test";
        msg.setString(this.name, str);
        msg = (ActiveMQMapMessage)msg.copy();
        Assert.assertEquals((Object)msg.getString(this.name), (Object)str);
    }

    @Test(timeout=10000L)
    public void testGetBytes() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        byte[] bytes1 = new byte[3];
        byte[] bytes2 = new byte[2];
        System.arraycopy(bytes1, 0, bytes2, 0, 2);
        msg.setBytes(this.name, bytes1);
        msg.setBytes(this.name + "2", bytes1, 0, 2);
        msg = (ActiveMQMapMessage)msg.copy();
        Assert.assertTrue((boolean)Arrays.equals(msg.getBytes(this.name), bytes1));
        Assert.assertEquals((long)msg.getBytes(this.name + "2").length, (long)bytes2.length);
    }

    @Test(timeout=10000L)
    public void testGetBytesWithNullValue() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        Assert.assertNull((Object)msg.getBytes(this.name));
    }

    @Test(timeout=10000L)
    public void testGetObject() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        Boolean booleanValue = Boolean.TRUE;
        Byte byteValue = Byte.valueOf("1");
        byte[] bytesValue = new byte[3];
        Character charValue = new Character('a');
        Double doubleValue = Double.valueOf("1.5");
        Float floatValue = Float.valueOf("1.5");
        Integer intValue = Integer.valueOf("1");
        Long longValue = Long.valueOf("1");
        Short shortValue = Short.valueOf("1");
        String stringValue = "string";
        try {
            msg.setObject("boolean", (Object)booleanValue);
            msg.setObject("byte", (Object)byteValue);
            msg.setObject("bytes", (Object)bytesValue);
            msg.setObject("char", (Object)charValue);
            msg.setObject("double", (Object)doubleValue);
            msg.setObject("float", (Object)floatValue);
            msg.setObject("int", (Object)intValue);
            msg.setObject("long", (Object)longValue);
            msg.setObject("short", (Object)shortValue);
            msg.setObject("string", (Object)stringValue);
        }
        catch (MessageFormatException mfe) {
            LOG.warn("Caught: " + (Object)((Object)mfe));
            mfe.printStackTrace();
            Assert.fail((String)"object formats should be correct");
        }
        msg = (ActiveMQMapMessage)msg.copy();
        Assert.assertTrue((boolean)(msg.getObject("boolean") instanceof Boolean));
        Assert.assertEquals((Object)msg.getObject("boolean"), (Object)booleanValue);
        Assert.assertEquals((Object)msg.getBoolean("boolean"), (Object)booleanValue);
        Assert.assertTrue((boolean)(msg.getObject("byte") instanceof Byte));
        Assert.assertEquals((Object)msg.getObject("byte"), (Object)byteValue);
        Assert.assertEquals((long)msg.getByte("byte"), (long)byteValue.byteValue());
        Assert.assertTrue((boolean)(msg.getObject("bytes") instanceof byte[]));
        Assert.assertEquals((long)((byte[])msg.getObject("bytes")).length, (long)bytesValue.length);
        Assert.assertEquals((long)msg.getBytes("bytes").length, (long)bytesValue.length);
        Assert.assertTrue((boolean)(msg.getObject("char") instanceof Character));
        Assert.assertEquals((Object)msg.getObject("char"), (Object)charValue);
        Assert.assertEquals((long)msg.getChar("char"), (long)charValue.charValue());
        Assert.assertTrue((boolean)(msg.getObject("double") instanceof Double));
        Assert.assertEquals((Object)msg.getObject("double"), (Object)doubleValue);
        Assert.assertEquals((double)msg.getDouble("double"), (double)doubleValue, (double)0.0);
        Assert.assertTrue((boolean)(msg.getObject("float") instanceof Float));
        Assert.assertEquals((Object)msg.getObject("float"), (Object)floatValue);
        Assert.assertEquals((float)msg.getFloat("float"), (float)floatValue.floatValue(), (float)0.0f);
        Assert.assertTrue((boolean)(msg.getObject("int") instanceof Integer));
        Assert.assertEquals((Object)msg.getObject("int"), (Object)intValue);
        Assert.assertEquals((long)msg.getInt("int"), (long)intValue.intValue());
        Assert.assertTrue((boolean)(msg.getObject("long") instanceof Long));
        Assert.assertEquals((Object)msg.getObject("long"), (Object)longValue);
        Assert.assertEquals((long)msg.getLong("long"), (long)longValue);
        Assert.assertTrue((boolean)(msg.getObject("short") instanceof Short));
        Assert.assertEquals((Object)msg.getObject("short"), (Object)shortValue);
        Assert.assertEquals((long)msg.getShort("short"), (long)shortValue.shortValue());
        Assert.assertTrue((boolean)(msg.getObject("string") instanceof String));
        Assert.assertEquals((Object)msg.getObject("string"), (Object)stringValue);
        Assert.assertEquals((Object)msg.getString("string"), (Object)stringValue);
        msg.clearBody();
        try {
            msg.setObject("object", new Object());
            Assert.fail((String)"should have thrown exception");
        }
        catch (MessageFormatException e) {
            // empty catch block
        }
    }

    @Test(timeout=10000L)
    public void testGetMapNames() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        msg.setBoolean("boolean", true);
        msg.setByte("byte", (byte)1);
        msg.setBytes("bytes1", new byte[1]);
        msg.setBytes("bytes2", new byte[3], 0, 2);
        msg.setChar("char", 'a');
        msg.setDouble("double", 1.5);
        msg.setFloat("float", 1.5f);
        msg.setInt("int", 1);
        msg.setLong("long", 1L);
        msg.setObject("object", (Object)"stringObj");
        msg.setShort("short", (short)1);
        msg.setString("string", "string");
        msg = (ActiveMQMapMessage)msg.copy();
        Enumeration mapNamesEnum = msg.getMapNames();
        ArrayList mapNamesList = Collections.list(mapNamesEnum);
        Assert.assertEquals((long)mapNamesList.size(), (long)12L);
        Assert.assertTrue((boolean)mapNamesList.contains("boolean"));
        Assert.assertTrue((boolean)mapNamesList.contains("byte"));
        Assert.assertTrue((boolean)mapNamesList.contains("bytes1"));
        Assert.assertTrue((boolean)mapNamesList.contains("bytes2"));
        Assert.assertTrue((boolean)mapNamesList.contains("char"));
        Assert.assertTrue((boolean)mapNamesList.contains("double"));
        Assert.assertTrue((boolean)mapNamesList.contains("float"));
        Assert.assertTrue((boolean)mapNamesList.contains("int"));
        Assert.assertTrue((boolean)mapNamesList.contains("long"));
        Assert.assertTrue((boolean)mapNamesList.contains("object"));
        Assert.assertTrue((boolean)mapNamesList.contains("short"));
        Assert.assertTrue((boolean)mapNamesList.contains("string"));
    }

    @Test(timeout=10000L)
    public void testItemExists() throws JMSException {
        ActiveMQMapMessage mapMessage = new ActiveMQMapMessage();
        mapMessage.setString("exists", "test");
        mapMessage = (ActiveMQMapMessage)mapMessage.copy();
        Assert.assertTrue((boolean)mapMessage.itemExists("exists"));
        Assert.assertFalse((boolean)mapMessage.itemExists("doesntExist"));
    }

    @Test(timeout=10000L)
    public void testClearBody() throws JMSException {
        ActiveMQMapMessage mapMessage = new ActiveMQMapMessage();
        mapMessage.setString("String", "String");
        mapMessage.clearBody();
        Assert.assertFalse((boolean)mapMessage.isReadOnlyBody());
        mapMessage.onSend();
        mapMessage.setContent(mapMessage.getContent());
        Assert.assertNull((Object)mapMessage.getString("String"));
        mapMessage.clearBody();
        mapMessage.setString("String", "String");
        mapMessage = (ActiveMQMapMessage)mapMessage.copy();
        mapMessage.getString("String");
    }

    @Test(timeout=10000L)
    public void testReadOnlyBody() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        msg.setBoolean("boolean", true);
        msg.setByte("byte", (byte)1);
        msg.setBytes("bytes", new byte[1]);
        msg.setBytes("bytes2", new byte[3], 0, 2);
        msg.setChar("char", 'a');
        msg.setDouble("double", 1.5);
        msg.setFloat("float", 1.5f);
        msg.setInt("int", 1);
        msg.setLong("long", 1L);
        msg.setObject("object", (Object)"stringObj");
        msg.setShort("short", (short)1);
        msg.setString("string", "string");
        msg.setReadOnlyBody(true);
        try {
            msg.getBoolean("boolean");
            msg.getByte("byte");
            msg.getBytes("bytes");
            msg.getChar("char");
            msg.getDouble("double");
            msg.getFloat("float");
            msg.getInt("int");
            msg.getLong("long");
            msg.getObject("object");
            msg.getShort("short");
            msg.getString("string");
        }
        catch (MessageNotReadableException mnre) {
            Assert.fail((String)"should be readable");
        }
        try {
            msg.setBoolean("boolean", true);
            Assert.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            msg.setByte("byte", (byte)1);
            Assert.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            msg.setBytes("bytes", new byte[1]);
            Assert.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            msg.setBytes("bytes2", new byte[3], 0, 2);
            Assert.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            msg.setChar("char", 'a');
            Assert.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            msg.setDouble("double", 1.5);
            Assert.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            msg.setFloat("float", 1.5f);
            Assert.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            msg.setInt("int", 1);
            Assert.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            msg.setLong("long", 1L);
            Assert.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            msg.setObject("object", (Object)"stringObj");
            Assert.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            msg.setShort("short", (short)1);
            Assert.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            msg.setString("string", "string");
            Assert.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
    }

    @Test(timeout=10000L)
    public void testWriteOnlyBody() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        msg.setReadOnlyBody(false);
        msg.setBoolean("boolean", true);
        msg.setByte("byte", (byte)1);
        msg.setBytes("bytes", new byte[1]);
        msg.setBytes("bytes2", new byte[3], 0, 2);
        msg.setChar("char", 'a');
        msg.setDouble("double", 1.5);
        msg.setFloat("float", 1.5f);
        msg.setInt("int", 1);
        msg.setLong("long", 1L);
        msg.setObject("object", (Object)"stringObj");
        msg.setShort("short", (short)1);
        msg.setString("string", "string");
        msg.setReadOnlyBody(true);
        msg.getBoolean("boolean");
        msg.getByte("byte");
        msg.getBytes("bytes");
        msg.getChar("char");
        msg.getDouble("double");
        msg.getFloat("float");
        msg.getInt("int");
        msg.getLong("long");
        msg.getObject("object");
        msg.getShort("short");
        msg.getString("string");
    }
}

