/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.SocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketTstFactory
extends SocketFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SocketTstFactory.class);
    private static final ConcurrentMap<InetAddress, Integer> closeIter = new ConcurrentHashMap<InetAddress, Integer>();
    private final Random rnd;
    private static final SocketTstFactory client = new SocketTstFactory();

    public SocketTstFactory() {
        LOG.info("Creating a new SocketTstFactory");
        this.rnd = new Random();
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SocketTst sockTst = new SocketTst(host, port, this.rnd);
        sockTst.startBagot();
        return sockTst.getSocket();
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress localAddress, int localPort) throws IOException {
        SocketTst sockTst = new SocketTst(host, port, localAddress, localPort, this.rnd);
        sockTst.startBagot();
        return sockTst.getSocket();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SocketTst sockTst = new SocketTst(host, port, this.rnd);
        sockTst.startBagot();
        return sockTst.getSocket();
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        SocketTst sockTst = new SocketTst(host, port, localAddress, localPort, this.rnd);
        sockTst.startBagot();
        return sockTst.getSocket();
    }

    public static SocketFactory getDefault() {
        return client;
    }

    private class SocketTst {
        private final Bagot bagot;
        private final Socket socket;

        public SocketTst(InetAddress address, int port, Random rnd) throws IOException {
            this.socket = new Socket(address, port);
            this.bagot = new Bagot(rnd, this.socket, address);
        }

        public SocketTst(InetAddress address, int port, InetAddress localAddr, int localPort, Random rnd) throws IOException {
            this.socket = new Socket(address, port, localAddr, localPort);
            this.bagot = new Bagot(rnd, this.socket, address);
        }

        public SocketTst(String address, int port, Random rnd) throws UnknownHostException, IOException {
            this.socket = new Socket(address, port);
            this.bagot = new Bagot(rnd, this.socket, InetAddress.getByName(address));
        }

        public SocketTst(String address, int port, InetAddress localAddr, int localPort, Random rnd) throws IOException {
            this.socket = new Socket(address, port, localAddr, localPort);
            this.bagot = new Bagot(rnd, this.socket, InetAddress.getByName(address));
        }

        public Socket getSocket() {
            return this.socket;
        }

        public void startBagot() {
            this.bagot.start();
        }

        private class Bagot
        implements Runnable {
            private final Thread processus = new Thread((Runnable)this, "Network Faults maker : undefined");
            private final Socket socket;
            private final InetAddress address;

            public Bagot(Random rnd, Socket socket, InetAddress address) {
                this.socket = socket;
                this.address = address;
            }

            public void start() {
                this.processus.setName("Network Faults maker : " + this.socket.toString());
                this.processus.start();
            }

            @Override
            public void run() {
                while (!this.processus.isInterrupted()) {
                    if (!this.socket.isClosed()) {
                        try {
                            int lastDelayVal;
                            Integer lastDelay = (Integer)closeIter.get(this.address);
                            lastDelayVal = lastDelay == null ? 0 : ((lastDelayVal = lastDelay.intValue()) > 10 ? (lastDelayVal += 20) : ++lastDelayVal);
                            lastDelay = new Integer(lastDelayVal);
                            LOG.info("Trying to close client socket " + this.socket.toString() + " in " + lastDelayVal + " milliseconds");
                            try {
                                Thread.sleep(lastDelayVal);
                            }
                            catch (InterruptedException e) {
                                this.processus.interrupt();
                                Thread.currentThread().interrupt();
                            }
                            catch (IllegalArgumentException e) {
                                // empty catch block
                            }
                            this.socket.close();
                            closeIter.put(this.address, lastDelay);
                            LOG.info("Client socket " + this.socket.toString() + " is closed.");
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.processus.interrupt();
                }
            }
        }
    }
}

