/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.vm;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.BrokerService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VMTransportWaitForTest {
    static final Logger LOG = LoggerFactory.getLogger(VMTransportWaitForTest.class);
    private static final int WAIT_TIME = 20000;
    private static final int SHORT_WAIT_TIME = 5000;
    private static final String VM_BROKER_URI_NO_WAIT = "vm://localhost?broker.persistent=false&create=false";
    private static final String VM_BROKER_URI_WAIT_FOR_START = "vm://localhost?broker.persistent=false&create=false&waitForStart=20000";
    private static final String VM_BROKER_URI_SHORT_WAIT_FOR_START = "vm://localhost?broker.persistent=false&create=false&waitForStart=5000";
    CountDownLatch started = new CountDownLatch(1);
    CountDownLatch gotConnection = new CountDownLatch(1);

    @After
    public void after() throws IOException {
        BrokerRegistry.getInstance().unbind("localhost");
    }

    @Test(timeout=90000L)
    public void testWaitFor() throws Exception {
        try {
            ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(new URI(VM_BROKER_URI_NO_WAIT));
            cf.createConnection();
            Assert.fail((String)"expect broker not exist exception");
        }
        catch (JMSException expectedOnNoBrokerAndNoCreate) {
            // empty catch block
        }
        Thread t = new Thread("ClientConnectionThread"){

            @Override
            public void run() {
                try {
                    VMTransportWaitForTest.this.started.countDown();
                    ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(new URI(VMTransportWaitForTest.VM_BROKER_URI_WAIT_FOR_START));
                    cf.createConnection();
                    VMTransportWaitForTest.this.gotConnection.countDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)("unexpected exception: " + e));
                }
            }
        };
        t.start();
        this.started.await(20L, TimeUnit.SECONDS);
        Thread.yield();
        Assert.assertFalse((String)"has not got connection", (boolean)this.gotConnection.await(2L, TimeUnit.SECONDS));
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        broker.start();
        Assert.assertTrue((String)"has got connection", (boolean)this.gotConnection.await(5L, TimeUnit.SECONDS));
        broker.stop();
    }

    @Test(timeout=90000L)
    public void testWaitForNoBrokerInRegistry() throws Exception {
        long startTime = System.currentTimeMillis();
        try {
            ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(new URI(VM_BROKER_URI_SHORT_WAIT_FOR_START));
            cf.createConnection();
            Assert.fail((String)"expect broker not exist exception");
        }
        catch (JMSException expectedOnNoBrokerAndNoCreate) {
            // empty catch block
        }
        long endTime = System.currentTimeMillis();
        LOG.info("Total wait time was: {}", (Object)(endTime - startTime));
        Assert.assertTrue((endTime - startTime >= 4900L ? 1 : 0) != 0);
    }

    @Test(timeout=90000L)
    public void testWaitForNotStartedButInRegistry() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        BrokerRegistry.getInstance().bind("localhost", broker);
        long startTime = System.currentTimeMillis();
        try {
            ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(new URI(VM_BROKER_URI_SHORT_WAIT_FOR_START));
            cf.createConnection();
            Assert.fail((String)"expect broker not exist exception");
        }
        catch (JMSException expectedOnNoBrokerAndNoCreate) {
            // empty catch block
        }
        long endTime = System.currentTimeMillis();
        LOG.info("Total wait time was: {}", (Object)(endTime - startTime));
        Assert.assertTrue((endTime - startTime >= 4900L ? 1 : 0) != 0);
    }
}

