/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.MessageIdList;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvisoryViaNetworkTest
extends JmsMultipleBrokersTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AdvisoryViaNetworkTest.class);

    @Override
    protected BrokerService createBroker(String brokerName) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        broker.setUseJmx(false);
        broker.setBrokerName(brokerName);
        broker.addConnector(new URI("tcp://localhost:0"));
        this.brokers.put(brokerName, new JmsMultipleBrokersTestSupport.BrokerItem(broker));
        return broker;
    }

    public void testAdvisoryForwarding() throws Exception {
        ActiveMQTopic advisoryTopic = new ActiveMQTopic("ActiveMQ.Advisory.Producer.Topic.FOO");
        this.createBroker("A");
        this.createBroker("B");
        NetworkConnector networkBridge = this.bridgeBrokers("A", "B");
        networkBridge.addStaticallyIncludedDestination((ActiveMQDestination)advisoryTopic);
        this.startAllBrokers();
        this.verifyPeerBrokerInfo((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get("A"), 1);
        MessageConsumer consumerA = this.createConsumer("A", (Destination)advisoryTopic);
        MessageConsumer consumerB = this.createConsumer("B", (Destination)advisoryTopic);
        this.sendMessages("A", (Destination)new ActiveMQTopic("FOO"), 1);
        MessageIdList messagesA = this.getConsumerMessages("A", consumerA);
        MessageIdList messagesB = this.getConsumerMessages("B", consumerB);
        LOG.info("consumerA = " + (Object)((Object)messagesA));
        LOG.info("consumerB = " + (Object)((Object)messagesB));
        messagesA.assertMessagesReceived(2);
        messagesB.assertMessagesReceived(2);
    }

    public void testBridgeRelevantAdvisoryNotAvailable() throws Exception {
        ActiveMQTopic advisoryTopic = new ActiveMQTopic("ActiveMQ.Advisory.Consumer.Topic.FOO");
        this.createBroker("A");
        this.createBroker("B");
        NetworkConnector networkBridge = this.bridgeBrokers("A", "B");
        networkBridge.addStaticallyIncludedDestination((ActiveMQDestination)advisoryTopic);
        this.startAllBrokers();
        this.verifyPeerBrokerInfo((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get("A"), 1);
        MessageConsumer consumerA = this.createConsumer("A", (Destination)advisoryTopic);
        MessageConsumer consumerB = this.createConsumer("B", (Destination)advisoryTopic);
        this.createConsumer("A", (Destination)new ActiveMQTopic("FOO"));
        MessageIdList messagesA = this.getConsumerMessages("A", consumerA);
        MessageIdList messagesB = this.getConsumerMessages("B", consumerB);
        LOG.info("consumerA = " + (Object)((Object)messagesA));
        LOG.info("consumerB = " + (Object)((Object)messagesB));
        messagesA.assertMessagesReceived(1);
        messagesB.assertMessagesReceived(0);
    }

    private void verifyPeerBrokerInfo(JmsMultipleBrokersTestSupport.BrokerItem brokerItem, final int max) throws Exception {
        final BrokerService broker = brokerItem.broker;
        final RegionBroker regionBroker = (RegionBroker)broker.getRegionBroker();
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.info("verify infos " + broker.getBrokerName() + ", len: " + regionBroker.getPeerBrokerInfos().length);
                return max == regionBroker.getPeerBrokerInfos().length;
            }
        }, (long)120000L);
        LOG.info("verify infos " + broker.getBrokerName() + ", len: " + regionBroker.getPeerBrokerInfos().length);
        for (BrokerInfo info : regionBroker.getPeerBrokerInfos()) {
            LOG.info(info.getBrokerName());
        }
        AdvisoryViaNetworkTest.assertEquals((String)broker.getBrokerName(), (int)max, (int)regionBroker.getPeerBrokerInfos().length);
    }

    @Override
    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
    }
}

