/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ConnectionFailedException;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.security.SimpleAuthenticationPlugin;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionListenerTest
implements ExceptionListener {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionListenerTest.class);
    BrokerService brokerService;
    URI brokerUri;
    LinkedList<Throwable> exceptionsViaListener = new LinkedList();

    @Before
    public void startBroker() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setAdvisorySupport(false);
        this.brokerService.setUseJmx(false);
        this.brokerService.setPersistent(false);
        this.brokerService.setPlugins(new BrokerPlugin[]{new SimpleAuthenticationPlugin(new ArrayList())});
        this.brokerUri = this.brokerService.addConnector("tcp://0.0.0.0:0").getConnectUri();
        this.brokerService.start();
    }

    @After
    public void stopBroker() throws Exception {
        this.exceptionsViaListener.clear();
        if (this.brokerService != null) {
            this.brokerService.stop();
        }
    }

    @Test
    public void fireOnSecurityException() throws Exception {
        this.doFireOnSecurityException(new ActiveMQConnectionFactory(this.brokerUri));
    }

    @Test
    public void fireOnSecurityExceptionFailover() throws Exception {
        this.doFireOnSecurityException(new ActiveMQConnectionFactory("failover://" + this.brokerUri));
    }

    public void doFireOnSecurityException(ActiveMQConnectionFactory factory) throws Exception {
        factory.setWatchTopicAdvisories(false);
        Connection connection = factory.createConnection();
        connection.setExceptionListener((ExceptionListener)this);
        try {
            connection.start();
            Assert.fail((String)"Expect securityException");
        }
        catch (JMSSecurityException expected) {
            expected.printStackTrace();
            Assert.assertTrue((String)("nested security exception: " + (Object)((Object)expected)), (boolean)(expected.getCause() instanceof SecurityException));
        }
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return !ExceptionListenerTest.this.exceptionsViaListener.isEmpty();
            }
        });
        Throwable expected = this.exceptionsViaListener.getFirst();
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)expected.getCause());
        Assert.assertTrue((String)("expected exception: " + expected), (boolean)(expected.getCause().getCause() instanceof SecurityException));
        try {
            connection.createSession(false, 1);
            Assert.fail((String)"Expect error b/c connection is auto closed on security exception above");
        }
        catch (ConnectionFailedException e) {
            // empty catch block
        }
    }

    public void onException(JMSException e) {
        LOG.info("onException:" + (Object)((Object)e), new Throwable("FromHere"));
        this.exceptionsViaListener.add(e);
    }
}

