/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.ClientInternalExceptionListener;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQConnectionFactoryTest
extends CombinationTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQConnectionFactoryTest.class);
    private ActiveMQConnection connection;
    private BrokerService broker;

    public void testUseURIToSetUseClientIDPrefixOnConnectionFactory() throws URISyntaxException, JMSException {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost?jms.clientIDPrefix=Cheese&broker.persistent=false");
        ActiveMQConnectionFactoryTest.assertEquals((String)"Cheese", (String)cf.getClientIDPrefix());
        this.connection = (ActiveMQConnection)cf.createConnection();
        this.connection.start();
        String clientID = this.connection.getClientID();
        LOG.info("Got client ID: " + clientID);
        ActiveMQConnectionFactoryTest.assertTrue((String)("should start with Cheese! but was: " + clientID), (boolean)clientID.startsWith("Cheese"));
    }

    public void setUp() throws Exception {
        LOG.info("=========== Start test " + this.getName());
        super.setUp();
    }

    public void tearDown() throws Exception {
        try {
            this.connection.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.broker.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LOG.info("=========== Finished test " + this.getName());
    }

    public void testUseURIToSetOptionsOnConnectionFactory() throws URISyntaxException, JMSException {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost?jms.useAsyncSend=true");
        ActiveMQConnectionFactoryTest.assertTrue((boolean)cf.isUseAsyncSend());
        ActiveMQConnectionFactoryTest.assertEquals((String)"vm://localhost", (String)cf.getBrokerURL());
        cf = new ActiveMQConnectionFactory("vm://localhost?jms.useAsyncSend=false");
        ActiveMQConnectionFactoryTest.assertFalse((boolean)cf.isUseAsyncSend());
        ActiveMQConnectionFactoryTest.assertEquals((String)"vm://localhost", (String)cf.getBrokerURL());
        cf = new ActiveMQConnectionFactory("vm:(broker:()/localhost)?jms.useAsyncSend=true");
        ActiveMQConnectionFactoryTest.assertTrue((boolean)cf.isUseAsyncSend());
        ActiveMQConnectionFactoryTest.assertEquals((String)"vm:(broker:()/localhost)", (String)cf.getBrokerURL());
        cf = new ActiveMQConnectionFactory("vm://localhost?jms.auditDepth=5000");
        ActiveMQConnectionFactoryTest.assertEquals((int)5000, (int)cf.getAuditDepth());
    }

    public void testUseURIToConfigureRedeliveryPolicy() throws URISyntaxException, JMSException {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false&broker.useJmx=false&jms.redeliveryPolicy.maximumRedeliveries=2");
        ActiveMQConnectionFactoryTest.assertEquals((String)"connection redeliveries", (int)2, (int)cf.getRedeliveryPolicy().getMaximumRedeliveries());
        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        ActiveMQConnectionFactoryTest.assertEquals((String)"connection redeliveries", (int)2, (int)connection.getRedeliveryPolicy().getMaximumRedeliveries());
        Session session = connection.createSession(false, 1);
        ActiveMQMessageConsumer consumer = (ActiveMQMessageConsumer)session.createConsumer((Destination)session.createQueue("FOO.BAR"));
        ActiveMQConnectionFactoryTest.assertEquals((String)"consumer redeliveries", (int)2, (int)consumer.getRedeliveryPolicy().getMaximumRedeliveries());
        connection.close();
    }

    public void testCreateVMConnectionWithEmbdeddBroker() throws URISyntaxException, JMSException {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://myBroker2?broker.persistent=false&broker.useJmx=false");
        ActiveMQConnectionFactoryTest.assertNull((Object)BrokerRegistry.getInstance().lookup("myBroker2"));
        this.connection = (ActiveMQConnection)cf.createConnection();
        ActiveMQConnectionFactoryTest.assertNotNull((Object)this.connection);
        ActiveMQConnectionFactoryTest.assertNotNull((Object)BrokerRegistry.getInstance().lookup("myBroker2"));
        this.connection.close();
        ActiveMQConnectionFactoryTest.assertNull((Object)BrokerRegistry.getInstance().lookup("myBroker2"));
    }

    public void testGetBrokerName() throws URISyntaxException, JMSException {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false&broker.useJmx=false");
        this.connection = (ActiveMQConnection)cf.createConnection();
        this.connection.start();
        String brokerName = this.connection.getBrokerName();
        LOG.info("Got broker name: " + brokerName);
        ActiveMQConnectionFactoryTest.assertNotNull((String)"No broker name available!", (Object)brokerName);
    }

    public void testCreateTcpConnectionUsingAllocatedPort() throws Exception {
        this.assertCreateConnection("tcp://localhost:0?wireFormat.tcpNoDelayEnabled=true");
    }

    public void testCreateTcpConnectionUsingKnownPort() throws Exception {
        this.assertCreateConnection("tcp://localhost:61610?wireFormat.tcpNoDelayEnabled=true");
    }

    public void testCreateTcpConnectionUsingKnownLocalPort() throws Exception {
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.setUseJmx(false);
        this.broker.addConnector("tcp://localhost:61610?wireFormat.tcpNoDelayEnabled=true");
        this.broker.start();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("tcp://localhost:61610/localhost:51610");
        this.connection = (ActiveMQConnection)cf.createConnection();
        ActiveMQConnectionFactoryTest.assertNotNull((Object)this.connection);
        this.connection.close();
        this.broker.stop();
    }

    public void testConnectionFailsToConnectToVMBrokerThatIsNotRunning() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost?create=false");
        try {
            factory.createConnection();
            ActiveMQConnectionFactoryTest.fail((String)"Expected connection failure.");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void testFactorySerializable() throws Exception {
        String clientID = "TestClientID";
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory();
        cf.setClientID(clientID);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream objectsOut = new ObjectOutputStream(bytesOut);
        objectsOut.writeObject(cf);
        objectsOut.flush();
        byte[] data = bytesOut.toByteArray();
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(data);
        ObjectInputStream objectsIn = new ObjectInputStream(bytesIn);
        cf = (ActiveMQConnectionFactory)objectsIn.readObject();
        ActiveMQConnectionFactoryTest.assertEquals((String)cf.getClientID(), (String)clientID);
    }

    public void testSetExceptionListener() throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        this.connection = (ActiveMQConnection)cf.createConnection();
        ActiveMQConnectionFactoryTest.assertNull((Object)this.connection.getExceptionListener());
        ExceptionListener exListener = new ExceptionListener(){

            public void onException(JMSException arg0) {
            }
        };
        cf.setExceptionListener(exListener);
        this.connection.close();
        this.connection = (ActiveMQConnection)cf.createConnection();
        ActiveMQConnectionFactoryTest.assertNotNull((Object)this.connection.getExceptionListener());
        ActiveMQConnectionFactoryTest.assertEquals((Object)exListener, (Object)this.connection.getExceptionListener());
        this.connection.close();
        this.connection = (ActiveMQConnection)cf.createConnection();
        ActiveMQConnectionFactoryTest.assertEquals((Object)exListener, (Object)this.connection.getExceptionListener());
        ActiveMQConnectionFactoryTest.assertEquals((Object)exListener, (Object)cf.getExceptionListener());
        this.connection.close();
    }

    public void testSetClientInternalExceptionListener() throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        this.connection = (ActiveMQConnection)cf.createConnection();
        ActiveMQConnectionFactoryTest.assertNull((Object)this.connection.getClientInternalExceptionListener());
        ClientInternalExceptionListener listener = new ClientInternalExceptionListener(){

            public void onException(Throwable exception) {
            }
        };
        this.connection.setClientInternalExceptionListener(listener);
        cf.setClientInternalExceptionListener(listener);
        this.connection.close();
        this.connection = (ActiveMQConnection)cf.createConnection();
        ActiveMQConnectionFactoryTest.assertNotNull((Object)this.connection.getClientInternalExceptionListener());
        ActiveMQConnectionFactoryTest.assertEquals((Object)listener, (Object)this.connection.getClientInternalExceptionListener());
        this.connection.close();
        this.connection = (ActiveMQConnection)cf.createConnection();
        ActiveMQConnectionFactoryTest.assertEquals((Object)listener, (Object)this.connection.getClientInternalExceptionListener());
        ActiveMQConnectionFactoryTest.assertEquals((Object)listener, (Object)cf.getClientInternalExceptionListener());
        this.connection.close();
    }

    protected void assertCreateConnection(String uri) throws Exception {
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.setUseJmx(false);
        this.broker.setAdvisorySupport(false);
        this.broker.setSchedulerSupport(false);
        TransportConnector connector = this.broker.addConnector(uri);
        this.broker.start();
        URI temp = new URI(uri);
        URI currentURI = new URI(connector.getPublishableConnectString());
        URI connectURI = new URI(temp.getScheme(), temp.getUserInfo(), temp.getHost(), currentURI.getPort(), temp.getPath(), temp.getQuery(), temp.getFragment());
        LOG.info("connection URI is: " + connectURI);
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(connectURI);
        this.connection = (ActiveMQConnection)cf.createConnection();
        ActiveMQConnectionFactoryTest.assertNotNull((Object)this.connection);
    }
}

