/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.blob;

import java.io.File;
import java.util.ArrayList;
import javax.jms.Connection;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.util.IOHelper;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.WritePermission;
import org.jmock.Mockery;

public abstract class FTPTestSupport
extends EmbeddedBrokerTestSupport {
    protected static final String ftpServerListenerName = "default";
    protected Connection connection;
    protected FtpServer server;
    String userNamePass = "activemq";
    Mockery context = null;
    String ftpUrl;
    int ftpPort;
    final File ftpHomeDirFile = new File("target/FTPBlobTest/ftptest");

    @Override
    protected void setUp() throws Exception {
        if (this.ftpHomeDirFile.getParentFile().exists()) {
            IOHelper.deleteFile((File)this.ftpHomeDirFile.getParentFile());
        }
        this.ftpHomeDirFile.mkdirs();
        this.ftpHomeDirFile.getParentFile().deleteOnExit();
        FtpServerFactory serverFactory = new FtpServerFactory();
        ListenerFactory factory = new ListenerFactory();
        PropertiesUserManagerFactory userManagerFactory = new PropertiesUserManagerFactory();
        UserManager userManager = userManagerFactory.createUserManager();
        BaseUser user = new BaseUser();
        user.setName("activemq");
        user.setPassword("activemq");
        user.setHomeDirectory(this.ftpHomeDirFile.getParent());
        ArrayList<WritePermission> auths = new ArrayList<WritePermission>();
        WritePermission auth = new WritePermission();
        auths.add(auth);
        user.setAuthorities(auths);
        userManager.save((User)user);
        BaseUser guest = new BaseUser();
        guest.setName("guest");
        guest.setPassword("guest");
        guest.setHomeDirectory(this.ftpHomeDirFile.getParent());
        userManager.save((User)guest);
        serverFactory.setUserManager(userManager);
        factory.setPort(0);
        serverFactory.addListener(ftpServerListenerName, factory.createListener());
        this.server = serverFactory.createServer();
        this.server.start();
        this.ftpPort = serverFactory.getListener(ftpServerListenerName).getPort();
        super.setUp();
    }

    public void setConnection() throws Exception {
        this.ftpUrl = "ftp://" + this.userNamePass + ":" + this.userNamePass + "@localhost:" + this.ftpPort + "/ftptest/";
        this.bindAddress = "vm://localhost?jms.blobTransferPolicy.defaultUploadUrl=" + this.ftpUrl;
        this.connectionFactory = this.createConnectionFactory();
        this.connection = this.createConnection();
        this.connection.start();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.stop();
        }
        super.tearDown();
        if (this.server != null) {
            this.server.stop();
        }
        IOHelper.deleteFile((File)this.ftpHomeDirFile.getParentFile());
    }
}

