/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.util.Iterator;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.cursors.PrioritizedPendingList;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.util.IdGenerator;
import org.junit.Assert;
import org.junit.Test;

public class PrioritizedPendingListTest {
    @Test
    public void testAddMessageFirst() {
        PrioritizedPendingList list = new PrioritizedPendingList();
        list.addMessageFirst((MessageReference)new TestMessageReference(1));
        list.addMessageFirst((MessageReference)new TestMessageReference(2));
        list.addMessageFirst((MessageReference)new TestMessageReference(3));
        list.addMessageFirst((MessageReference)new TestMessageReference(4));
        list.addMessageFirst((MessageReference)new TestMessageReference(5));
        Assert.assertTrue((list.size() == 5 ? 1 : 0) != 0);
        Iterator iter = list.iterator();
        int lastId = list.size();
        while (iter.hasNext()) {
            Assert.assertEquals((long)lastId--, (long)((MessageReference)iter.next()).getMessageId().getProducerSequenceId());
        }
    }

    @Test
    public void testAddMessageLast() {
        PrioritizedPendingList list = new PrioritizedPendingList();
        list.addMessageLast((MessageReference)new TestMessageReference(1));
        list.addMessageLast((MessageReference)new TestMessageReference(2));
        list.addMessageLast((MessageReference)new TestMessageReference(3));
        list.addMessageLast((MessageReference)new TestMessageReference(4));
        list.addMessageLast((MessageReference)new TestMessageReference(5));
        Assert.assertTrue((list.size() == 5 ? 1 : 0) != 0);
        Iterator iter = list.iterator();
        int lastId = 1;
        while (iter.hasNext()) {
            Assert.assertEquals((long)lastId++, (long)((MessageReference)iter.next()).getMessageId().getProducerSequenceId());
        }
    }

    @Test
    public void testClear() {
        PrioritizedPendingList list = new PrioritizedPendingList();
        list.addMessageFirst((MessageReference)new TestMessageReference(1));
        list.addMessageFirst((MessageReference)new TestMessageReference(2));
        list.addMessageFirst((MessageReference)new TestMessageReference(3));
        list.addMessageFirst((MessageReference)new TestMessageReference(4));
        list.addMessageFirst((MessageReference)new TestMessageReference(5));
        Assert.assertFalse((boolean)list.isEmpty());
        Assert.assertTrue((list.size() == 5 ? 1 : 0) != 0);
        list.clear();
        Assert.assertTrue((boolean)list.isEmpty());
        Assert.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        list.addMessageFirst((MessageReference)new TestMessageReference(1));
        list.addMessageLast((MessageReference)new TestMessageReference(2));
        list.addMessageLast((MessageReference)new TestMessageReference(3));
        list.addMessageFirst((MessageReference)new TestMessageReference(4));
        list.addMessageLast((MessageReference)new TestMessageReference(5));
        Assert.assertFalse((boolean)list.isEmpty());
        Assert.assertTrue((list.size() == 5 ? 1 : 0) != 0);
    }

    @Test
    public void testIsEmpty() {
        PrioritizedPendingList list = new PrioritizedPendingList();
        Assert.assertTrue((boolean)list.isEmpty());
        list.addMessageFirst((MessageReference)new TestMessageReference(1));
        list.addMessageFirst((MessageReference)new TestMessageReference(2));
        list.addMessageFirst((MessageReference)new TestMessageReference(3));
        list.addMessageFirst((MessageReference)new TestMessageReference(4));
        list.addMessageFirst((MessageReference)new TestMessageReference(5));
        Assert.assertFalse((boolean)list.isEmpty());
        list.clear();
        Assert.assertTrue((boolean)list.isEmpty());
    }

    @Test
    public void testRemove() {
        PrioritizedPendingList list = new PrioritizedPendingList();
        TestMessageReference toRemove = new TestMessageReference(6);
        list.addMessageFirst((MessageReference)new TestMessageReference(1));
        list.addMessageFirst((MessageReference)new TestMessageReference(2));
        list.addMessageFirst((MessageReference)new TestMessageReference(3));
        list.addMessageFirst((MessageReference)new TestMessageReference(4));
        list.addMessageFirst((MessageReference)new TestMessageReference(5));
        Assert.assertTrue((list.size() == 5 ? 1 : 0) != 0);
        list.addMessageLast((MessageReference)toRemove);
        list.remove((MessageReference)toRemove);
        Assert.assertTrue((list.size() == 5 ? 1 : 0) != 0);
        list.remove((MessageReference)toRemove);
        Assert.assertTrue((list.size() == 5 ? 1 : 0) != 0);
        Iterator iter = list.iterator();
        int lastId = list.size();
        while (iter.hasNext()) {
            Assert.assertEquals((long)lastId--, (long)((MessageReference)iter.next()).getMessageId().getProducerSequenceId());
        }
        list.remove(null);
    }

    @Test
    public void testSize() {
        PrioritizedPendingList list = new PrioritizedPendingList();
        Assert.assertTrue((boolean)list.isEmpty());
        Assert.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        list.addMessageFirst((MessageReference)new TestMessageReference(1));
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        list.addMessageLast((MessageReference)new TestMessageReference(2));
        Assert.assertTrue((list.size() == 2 ? 1 : 0) != 0);
        list.addMessageFirst((MessageReference)new TestMessageReference(3));
        Assert.assertTrue((list.size() == 3 ? 1 : 0) != 0);
        list.addMessageLast((MessageReference)new TestMessageReference(4));
        Assert.assertTrue((list.size() == 4 ? 1 : 0) != 0);
        list.addMessageFirst((MessageReference)new TestMessageReference(5));
        Assert.assertTrue((list.size() == 5 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)list.isEmpty());
        list.clear();
        Assert.assertTrue((boolean)list.isEmpty());
        Assert.assertTrue((list.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPrioritization() {
        PrioritizedPendingList list = new PrioritizedPendingList();
        list.addMessageFirst((MessageReference)new TestMessageReference(1, 5));
        list.addMessageFirst((MessageReference)new TestMessageReference(2, 4));
        list.addMessageFirst((MessageReference)new TestMessageReference(3, 3));
        list.addMessageFirst((MessageReference)new TestMessageReference(4, 2));
        list.addMessageFirst((MessageReference)new TestMessageReference(5, 1));
        Assert.assertTrue((list.size() == 5 ? 1 : 0) != 0);
        Iterator iter = list.iterator();
        int lastId = list.size();
        while (iter.hasNext()) {
            Assert.assertEquals((long)lastId--, (long)((MessageReference)iter.next()).getMessage().getPriority());
        }
    }

    static class TestMessageReference
    implements MessageReference {
        private static final IdGenerator id = new IdGenerator();
        private Message message;
        private MessageId messageId;
        private int referenceCount = 0;

        public TestMessageReference(int sequenceId) {
            this.messageId = new MessageId(id.generateId() + ":1", (long)sequenceId);
            this.message = new ActiveMQMessage();
            this.message.setPriority((byte)4);
        }

        public TestMessageReference(int sequenceId, int priority) {
            this.messageId = new MessageId(id.generateId() + ":1", (long)sequenceId);
            this.message = new ActiveMQMessage();
            this.message.setPriority((byte)priority);
        }

        public MessageId getMessageId() {
            return this.messageId;
        }

        public Message getMessageHardRef() {
            return null;
        }

        public Message getMessage() {
            return this.message;
        }

        public boolean isPersistent() {
            return false;
        }

        public Destination getRegionDestination() {
            return null;
        }

        public int getRedeliveryCounter() {
            return 0;
        }

        public void incrementRedeliveryCounter() {
        }

        public int getReferenceCount() {
            return this.referenceCount;
        }

        public int incrementReferenceCount() {
            return this.referenceCount++;
        }

        public int decrementReferenceCount() {
            return this.referenceCount--;
        }

        public ConsumerId getTargetConsumerId() {
            return null;
        }

        public int getSize() {
            return 1;
        }

        public long getExpiration() {
            return 0L;
        }

        public String getGroupID() {
            return null;
        }

        public int getGroupSequence() {
            return 0;
        }

        public boolean isExpired() {
            return false;
        }

        public boolean isDropped() {
            return false;
        }

        public boolean isAdvisory() {
            return false;
        }
    }
}

