/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.net.URI;
import java.util.concurrent.Semaphore;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.util.MessageIdList;
import org.apache.activemq.util.Wait;

public class AMQ4147Test
extends JmsMultipleBrokersTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVMTransportRemoteMemoryUsage() throws Exception {
        BrokerService broker1 = this.createBroker(new URI("broker:(vm://broker1)/broker1?persistent=false"));
        BrokerService broker2 = this.createBroker(new URI("broker:(vm://broker2)/broker2?persistent=false"));
        this.startAllBrokers();
        this.bridgeBrokers("broker1", "broker2").start();
        ActiveMQDestination testQueue = this.createDestination(AMQ4147Test.class.getSimpleName() + ".queue", false);
        final org.apache.activemq.broker.region.Destination broker1TestQueue = broker1.getDestination(testQueue);
        final org.apache.activemq.broker.region.Destination broker2TestQueue = broker2.getDestination(testQueue);
        AMQ4147Test.assertEquals((long)0L, (long)broker1TestQueue.getMemoryUsage().getUsage());
        AMQ4147Test.assertEquals((long)0L, (long)broker2TestQueue.getMemoryUsage().getUsage());
        this.sendMessages("broker1", (Destination)testQueue, 1);
        AMQ4147Test.assertTrue((broker1TestQueue.getMemoryUsage().getUsage() > 0L ? 1 : 0) != 0);
        AMQ4147Test.assertEquals((long)0L, (long)broker2TestQueue.getMemoryUsage().getUsage());
        MessageIdList broker2Messages = this.getBrokerMessages("broker2");
        final Semaphore consumerReady = new Semaphore(0);
        final Semaphore consumerProceed = new Semaphore(0);
        broker2Messages.setParent(new MessageListener(){

            public void onMessage(Message message) {
                consumerReady.release();
                try {
                    consumerProceed.acquire();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        this.createConsumer("broker2", (Destination)testQueue);
        consumerReady.acquire();
        try {
            AMQ4147Test.assertTrue((String)"Memory Usage Should be Zero: ", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    return broker1TestQueue.getMemoryUsage().getUsage() == 0L;
                }
            }));
            AMQ4147Test.assertTrue((broker2TestQueue.getMemoryUsage().getUsage() > 0L ? 1 : 0) != 0);
        }
        finally {
            consumerProceed.release();
        }
        AMQ4147Test.assertTrue((String)"Memory Usage Should be Zero: ", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return broker1TestQueue.getMemoryUsage().getUsage() == 0L;
            }
        }));
        AMQ4147Test.assertTrue((String)"Memory Usage Should be Zero: ", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return broker2TestQueue.getMemoryUsage().getUsage() == 0L;
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTcpTransportRemoteMemoryUsage() throws Exception {
        BrokerService broker1 = this.createBroker(new URI("broker:(vm://broker1)/broker1?persistent=false"));
        BrokerService broker2 = this.createBroker(new URI("broker:(tcp://localhost:61616)/broker2?persistent=false"));
        this.startAllBrokers();
        this.bridgeBrokers("broker1", "broker2").start();
        ActiveMQDestination testQueue = this.createDestination(AMQ4147Test.class.getSimpleName() + ".queue", false);
        final org.apache.activemq.broker.region.Destination broker1TestQueue = broker1.getDestination(testQueue);
        final org.apache.activemq.broker.region.Destination broker2TestQueue = broker2.getDestination(testQueue);
        AMQ4147Test.assertEquals((long)0L, (long)broker1TestQueue.getMemoryUsage().getUsage());
        AMQ4147Test.assertEquals((long)0L, (long)broker2TestQueue.getMemoryUsage().getUsage());
        this.sendMessages("broker1", (Destination)testQueue, 1);
        AMQ4147Test.assertTrue((broker1TestQueue.getMemoryUsage().getUsage() > 0L ? 1 : 0) != 0);
        AMQ4147Test.assertEquals((long)0L, (long)broker2TestQueue.getMemoryUsage().getUsage());
        MessageIdList broker2Messages = this.getBrokerMessages("broker2");
        final Semaphore consumerReady = new Semaphore(0);
        final Semaphore consumerProceed = new Semaphore(0);
        broker2Messages.setParent(new MessageListener(){

            public void onMessage(Message message) {
                consumerReady.release();
                try {
                    consumerProceed.acquire();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        this.createConsumer("broker2", (Destination)testQueue);
        consumerReady.acquire();
        try {
            AMQ4147Test.assertTrue((String)"Memory Usage Should be Zero: ", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    return broker1TestQueue.getMemoryUsage().getUsage() == 0L;
                }
            }));
            AMQ4147Test.assertTrue((broker2TestQueue.getMemoryUsage().getUsage() > 0L ? 1 : 0) != 0);
        }
        finally {
            consumerProceed.release();
        }
        AMQ4147Test.assertTrue((String)"Memory Usage Should be Zero: ", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return broker1TestQueue.getMemoryUsage().getUsage() == 0L;
            }
        }));
        AMQ4147Test.assertTrue((String)"Memory Usage Should be Zero: ", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return broker2TestQueue.getMemoryUsage().getUsage() == 0L;
            }
        }));
    }
}

