/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.config;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.command.ActiveMQQueue;

public class ConfigUsingDestinationOptions
extends TestCase {
    public void testValidSelectorConfig() throws JMSException {
        ActiveMQQueue queue = new ActiveMQQueue("TEST.FOO?consumer.selector=test=1");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        Connection conn = factory.createConnection();
        Session sess = conn.createSession(false, 1);
        ActiveMQMessageConsumer cons = (ActiveMQMessageConsumer)sess.createConsumer((Destination)queue, "test=2");
        ConfigUsingDestinationOptions.assertEquals((String)"test=2", (String)cons.getMessageSelector());
        cons = (ActiveMQMessageConsumer)sess.createConsumer((Destination)queue);
        ConfigUsingDestinationOptions.assertEquals((String)"test=1", (String)cons.getMessageSelector());
    }

    public void testInvalidSelectorConfig() throws JMSException {
        ActiveMQMessageConsumer cons;
        ActiveMQQueue queue = new ActiveMQQueue("TEST.FOO?consumer.selector=test||1");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        Connection conn = factory.createConnection();
        Session sess = conn.createSession(false, 1);
        try {
            cons = (ActiveMQMessageConsumer)sess.createConsumer((Destination)queue, "test||1");
            ConfigUsingDestinationOptions.fail((String)("Selector should be invalid" + cons));
        }
        catch (InvalidSelectorException invalidSelectorException) {
            // empty catch block
        }
        try {
            cons = (ActiveMQMessageConsumer)sess.createConsumer((Destination)queue);
            ConfigUsingDestinationOptions.fail((String)("Selector should be invalid" + cons));
        }
        catch (InvalidSelectorException invalidSelectorException) {
            // empty catch block
        }
    }
}

