/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InactiveQueueTest
extends TestCase {
    private static final transient Logger LOG = LoggerFactory.getLogger(InactiveQueueTest.class);
    private static final int MESSAGE_COUNT = 0;
    private static final String DEFAULT_PASSWORD = "";
    private static final String USERNAME = "testuser";
    private static final String QUEUE_NAME = "testevent";
    private static final int DELIVERY_MODE = 2;
    private static final int DELIVERY_PRIORITY = 4;
    ActiveMQConnectionFactory connectionFactory;
    BrokerService broker;
    private Connection connection;
    private MessageProducer publisher;
    private Destination destination;
    private Session session;

    protected void setUp() throws Exception {
        super.setUp();
        this.broker = new BrokerService();
        this.broker.addConnector(ActiveMQConnectionFactory.DEFAULT_BROKER_BIND_URL);
        this.broker.start();
        this.connectionFactory = new ActiveMQConnectionFactory(ActiveMQConnectionFactory.DEFAULT_BROKER_URL);
        this.connectionFactory.setUseAsyncSend(true);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.broker.stop();
    }

    public void testNoSubscribers() throws Exception {
        int loop;
        this.connection = this.connectionFactory.createConnection(USERNAME, DEFAULT_PASSWORD);
        InactiveQueueTest.assertNotNull((Object)this.connection);
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        InactiveQueueTest.assertNotNull((Object)this.session);
        this.destination = this.session.createQueue(QUEUE_NAME);
        InactiveQueueTest.assertNotNull((Object)this.destination);
        this.publisher = this.session.createProducer(this.destination);
        InactiveQueueTest.assertNotNull((Object)this.publisher);
        MapMessage msg = this.session.createMapMessage();
        InactiveQueueTest.assertNotNull((Object)msg);
        msg.setString("key1", "value1");
        for (loop = 0; loop < 0; ++loop) {
            msg.setInt("key2", loop);
            this.publisher.send((Message)msg, 2, 4, 0L);
            if (loop % 500 != 0) continue;
            LOG.debug("Sent " + loop + " messages");
        }
        Thread.sleep(1000000L);
        InactiveQueueTest.assertEquals((int)loop, (int)0);
        this.publisher.close();
        this.session.close();
        this.connection.stop();
        this.connection.stop();
    }
}

