/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.apache.activemq.store.jdbc.JDBCCommitExceptionTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCXACommitExceptionTest
extends JDBCCommitExceptionTest {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCXACommitExceptionTest.class);
    private long txGenerator = System.currentTimeMillis();
    protected ActiveMQXAConnectionFactory factory;
    boolean onePhase = true;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.factory = new ActiveMQXAConnectionFactory(this.connectionUri + "?jms.prefetchPolicy.all=0&jms.redeliveryPolicy.maximumRedeliveries=" + 10);
    }

    public void testTwoPhaseSqlException() throws Exception {
        this.onePhase = false;
        this.doTestSqlException();
    }

    @Override
    protected int receiveMessages(int messagesExpected) throws Exception {
        XAConnection connection = this.factory.createXAConnection();
        connection.start();
        XASession session = connection.createXASession();
        this.jdbc.setShouldBreak(true);
        this.receiveMessages(messagesExpected, session, this.onePhase);
        this.jdbc.setShouldBreak(false);
        return this.receiveMessages(messagesExpected, session, this.onePhase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int receiveMessages(int messagesExpected, XASession session, boolean onePhase) throws Exception {
        int messagesReceived = 0;
        for (int i = 0; i < messagesExpected; ++i) {
            Queue destination = session.createQueue("TEST");
            MessageConsumer consumer = session.createConsumer((Destination)destination);
            XAResource resource = session.getXAResource();
            resource.recover(0x1000000);
            resource.recover(0);
            Xid tid = this.createXid();
            Message message = null;
            try {
                LOG.debug("Receiving message " + (messagesReceived + 1) + " of " + messagesExpected);
                resource.start(tid, 0);
                message = consumer.receive(2000L);
                LOG.info("Received : " + message);
                resource.end(tid, 0x4000000);
                if (message == null) continue;
                if (onePhase) {
                    resource.commit(tid, true);
                } else {
                    resource.prepare(tid);
                    resource.commit(tid, false);
                }
                ++messagesReceived;
                continue;
            }
            catch (Exception e) {
                LOG.debug("Caught exception:", (Throwable)e);
                try {
                    LOG.debug("Rolling back transaction (just in case, no need to do this as it is implicit in a 1pc commit failure) " + tid);
                    resource.rollback(tid);
                }
                catch (XAException ex) {
                    try {
                        LOG.debug("Caught exception during rollback: " + ex + " forgetting transaction " + tid);
                        resource.forget(tid);
                    }
                    catch (XAException ex1) {
                        LOG.debug("rollback/forget failed: " + ex1.errorCode);
                    }
                }
                continue;
            }
            finally {
                if (consumer != null) {
                    consumer.close();
                }
            }
        }
        return messagesReceived;
    }

    public Xid createXid() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        os.writeLong(++this.txGenerator);
        os.close();
        final byte[] bs = baos.toByteArray();
        return new Xid(){

            @Override
            public int getFormatId() {
                return 86;
            }

            @Override
            public byte[] getGlobalTransactionId() {
                return bs;
            }

            @Override
            public byte[] getBranchQualifier() {
                return bs;
            }
        };
    }
}

