/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.network.NetworkConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverClusterTestSupport
extends TestCase {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final int NUMBER_OF_CLIENTS = 30;
    private String clientUrl;
    private final Map<String, BrokerService> brokers = new HashMap<String, BrokerService>();
    private final List<ActiveMQConnection> connections = new ArrayList<ActiveMQConnection>();

    protected void assertClientsConnectedToTwoBrokers() {
        HashSet<String> set = new HashSet<String>();
        for (ActiveMQConnection c : this.connections) {
            if (c.getTransportChannel().getRemoteAddress() == null) continue;
            set.add(c.getTransportChannel().getRemoteAddress());
        }
        FailoverClusterTestSupport.assertTrue((String)("Only 2 connections should be found: " + set), (set.size() == 2 ? 1 : 0) != 0);
    }

    protected void assertClientsConnectedToThreeBrokers() {
        HashSet<String> set = new HashSet<String>();
        for (ActiveMQConnection c : this.connections) {
            if (c.getTransportChannel().getRemoteAddress() == null) continue;
            set.add(c.getTransportChannel().getRemoteAddress());
        }
        FailoverClusterTestSupport.assertTrue((String)("Only 3 connections should be found: " + set), (set.size() == 3 ? 1 : 0) != 0);
    }

    protected void assertClientsConnectionsEvenlyDistributed(double minimumPercentage) {
        double count;
        HashMap<String, Double> clientConnectionCounts = new HashMap<String, Double>();
        int total = 0;
        for (ActiveMQConnection c : this.connections) {
            String key = c.getTransportChannel().getRemoteAddress();
            if (key == null) continue;
            ++total;
            if (clientConnectionCounts.containsKey(key)) {
                count = (Double)clientConnectionCounts.get(key);
                clientConnectionCounts.put(key, count += 1.0);
                continue;
            }
            clientConnectionCounts.put(key, 1.0);
        }
        Set keys = clientConnectionCounts.keySet();
        for (String key : keys) {
            count = (Double)clientConnectionCounts.get(key);
            double percentage = count / (double)total;
            this.logger.info(count + " of " + total + " connections for " + key + " = " + percentage);
            FailoverClusterTestSupport.assertTrue((String)("Connections distribution expected to be >= than " + minimumPercentage + ".  Actuall distribution was " + percentage + " for connection " + key), (percentage >= minimumPercentage ? 1 : 0) != 0);
        }
    }

    protected void assertAllConnectedTo(String url) throws Exception {
        for (ActiveMQConnection c : this.connections) {
            FailoverClusterTestSupport.assertEquals((String)url, (String)c.getTransportChannel().getRemoteAddress());
        }
    }

    protected void addBroker(String name, BrokerService brokerService) {
        this.brokers.put(name, brokerService);
    }

    protected BrokerService getBroker(String name) {
        return this.brokers.get(name);
    }

    protected void stopBroker(String name) throws Exception {
        BrokerService broker = this.brokers.remove(name);
        broker.stop();
        broker.waitUntilStopped();
    }

    protected BrokerService removeBroker(String name) {
        return this.brokers.remove(name);
    }

    protected void destroyBrokerCluster() throws JMSException, Exception {
        for (BrokerService b : this.brokers.values()) {
            try {
                b.stop();
                b.waitUntilStopped();
            }
            catch (Exception e) {
                this.logger.info("Error while stopping broker[" + b.getBrokerName() + "] continuing...");
            }
        }
        this.brokers.clear();
    }

    protected void shutdownClients() throws JMSException {
        for (Connection connection : this.connections) {
            connection.close();
        }
    }

    protected BrokerService createBroker(String brokerName) throws Exception {
        BrokerService answer = new BrokerService();
        answer.setPersistent(false);
        answer.setUseJmx(false);
        answer.setBrokerName(brokerName);
        answer.setUseShutdownHook(false);
        return answer;
    }

    protected void addTransportConnector(BrokerService brokerService, String connectorName, String uri, boolean clustered) throws Exception {
        TransportConnector connector = brokerService.addConnector(uri);
        connector.setName(connectorName);
        if (clustered) {
            connector.setRebalanceClusterClients(true);
            connector.setUpdateClusterClients(true);
            connector.setUpdateClusterClientsOnRemove(true);
        } else {
            connector.setRebalanceClusterClients(false);
            connector.setUpdateClusterClients(false);
            connector.setUpdateClusterClientsOnRemove(false);
        }
    }

    protected void addNetworkBridge(BrokerService answer, String bridgeName, String uri, boolean duplex, String destinationFilter) throws Exception {
        NetworkConnector network = answer.addNetworkConnector(uri);
        network.setName(bridgeName);
        network.setDuplex(duplex);
        if (destinationFilter != null && !destinationFilter.equals("")) {
            network.setDestinationFilter(bridgeName);
        }
    }

    protected void createClients() throws Exception {
        this.createClients(30);
    }

    protected void createClients(int numOfClients) throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.clientUrl);
        for (int i = 0; i < numOfClients; ++i) {
            ActiveMQConnection c = (ActiveMQConnection)factory.createConnection();
            c.start();
            Session s = c.createSession(false, 1);
            Queue queue = s.createQueue(((Object)((Object)this)).getClass().getName());
            MessageConsumer consumer = s.createConsumer((Destination)queue);
            this.connections.add(c);
        }
    }

    public String getClientUrl() {
        return this.clientUrl;
    }

    public void setClientUrl(String clientUrl) {
        this.clientUrl = clientUrl;
    }
}

