/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.udp;

import java.net.URI;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.udp.UdpTestSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpTransportUsingServerTest
extends UdpTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(UdpTransportUsingServerTest.class);
    protected int consumerPort = 9123;
    protected String producerURI;
    protected String serverURI = this.producerURI = "udp://localhost:" + this.consumerPort;

    public void testRequestResponse() throws Exception {
        ConsumerInfo expected = new ConsumerInfo();
        expected.setSelector("Edam");
        expected.setResponseRequired(true);
        LOG.info("About to send: " + expected);
        Response response = (Response)this.producer.request((Object)expected, 2000);
        LOG.info("Received: " + response);
        UdpTransportUsingServerTest.assertNotNull((String)"Received a response", (Object)response);
        UdpTransportUsingServerTest.assertTrue((String)"Should not be an exception", (!response.isException() ? 1 : 0) != 0);
    }

    @Override
    protected Transport createProducer() throws Exception {
        LOG.info("Producer using URI: " + this.producerURI);
        URI uri = new URI(this.producerURI);
        return TransportFactory.connect((URI)uri);
    }

    @Override
    protected TransportServer createServer() throws Exception {
        return TransportFactory.bind((URI)new URI(this.serverURI));
    }

    @Override
    protected Transport createConsumer() throws Exception {
        return null;
    }
}

