/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatchMultipleConsumersTest
extends TestCase {
    private static final Logger logger = LoggerFactory.getLogger(DispatchMultipleConsumersTest.class);
    BrokerService broker;
    Destination dest;
    String destinationName = "TEST.Q";
    String msgStr = "Test text message";
    int messagesPerThread = 20;
    int producerThreads = 50;
    int consumerCount = 2;
    AtomicInteger sentCount;
    AtomicInteger consumedCount;
    CountDownLatch producerLatch;
    CountDownLatch consumerLatch;
    String brokerURL;
    String userName = "";
    String password = "";

    protected void setUp() throws Exception {
        super.setUp();
        this.broker = new BrokerService();
        this.broker.setPersistent(true);
        this.broker.setUseJmx(true);
        this.broker.deleteAllMessages();
        this.broker.addConnector("tcp://localhost:0");
        this.broker.start();
        this.broker.waitUntilStarted();
        this.dest = new ActiveMQQueue(this.destinationName);
        this.resetCounters();
        this.brokerURL = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
    }

    protected void tearDown() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
        super.tearDown();
    }

    private void resetCounters() {
        this.sentCount = new AtomicInteger(0);
        this.consumedCount = new AtomicInteger(0);
        this.producerLatch = new CountDownLatch(this.producerThreads);
        this.consumerLatch = new CountDownLatch(this.consumerCount);
    }

    public void testDispatch1() {
        for (int i = 1; i <= 5; ++i) {
            this.resetCounters();
            this.dispatch();
            DispatchMultipleConsumersTest.assertEquals((String)("Incorrect messages in Iteration " + i), (int)this.sentCount.get(), (int)this.consumedCount.get());
        }
    }

    private void dispatch() {
        this.startConsumers();
        this.startProducers();
        try {
            this.producerLatch.await();
            this.consumerLatch.await();
        }
        catch (InterruptedException e) {
            DispatchMultipleConsumersTest.fail((String)"test interrupted!");
        }
    }

    private void startConsumers() {
        ActiveMQConnectionFactory connFactory = new ActiveMQConnectionFactory(this.userName, this.password, this.brokerURL);
        try {
            Connection conn = connFactory.createConnection();
            conn.start();
            for (int i = 0; i < this.consumerCount; ++i) {
                new ConsumerThread(conn, "ConsumerThread" + i);
            }
        }
        catch (JMSException e) {
            logger.error("Failed to start consumers", (Throwable)e);
        }
    }

    private void startProducers() {
        ActiveMQConnectionFactory connFactory = new ActiveMQConnectionFactory(this.userName, this.password, this.brokerURL);
        for (int i = 0; i < this.producerThreads; ++i) {
            new ProducerThread(connFactory, this.messagesPerThread, "ProducerThread" + i);
        }
    }

    private class ProducerThread
    extends Thread {
        int count;
        Connection conn;
        Session session;
        MessageProducer producer;

        public ProducerThread(ActiveMQConnectionFactory connFactory, int count, String name) {
            this.count = count;
            this.setName(name);
            logger.trace("Created new producer thread:" + name);
            try {
                this.conn = connFactory.createConnection();
                this.conn.start();
                this.session = this.conn.createSession(false, 1);
                this.producer = this.session.createProducer(DispatchMultipleConsumersTest.this.dest);
                this.start();
            }
            catch (JMSException e) {
                logger.error("Failed to start producer thread:" + name, (Throwable)e);
            }
        }

        @Override
        public void run() {
            int i;
            try {
                for (i = 0; i < this.count; ++i) {
                    this.producer.send((Message)this.session.createTextMessage(DispatchMultipleConsumersTest.this.msgStr));
                    Thread.sleep(500L);
                }
                this.conn.close();
            }
            catch (JMSException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (InterruptedException e) {
                logger.error("Interrupted!", (Throwable)e);
            }
            DispatchMultipleConsumersTest.this.sentCount.addAndGet(i);
            DispatchMultipleConsumersTest.this.producerLatch.countDown();
            if (logger.isTraceEnabled()) {
                logger.trace("Sent " + i + " messages from thread " + this.getName());
            }
        }
    }

    private class ConsumerThread
    extends Thread {
        Session session;
        MessageConsumer consumer;

        public ConsumerThread(Connection conn, String name) {
            this.setName(name);
            logger.trace("Created new consumer thread:" + name);
            try {
                this.session = conn.createSession(false, 1);
                this.consumer = this.session.createConsumer(DispatchMultipleConsumersTest.this.dest);
                this.start();
            }
            catch (JMSException e) {
                logger.error("Failed to start consumer thread:" + name, (Throwable)e);
            }
        }

        @Override
        public void run() {
            int msgCount = 0;
            int nullCount = 0;
            block5: while (true) {
                try {
                    while (true) {
                        Message msg;
                        if ((msg = this.consumer.receive(1000L)) == null) {
                            if (DispatchMultipleConsumersTest.this.producerLatch.getCount() > 0L || ++nullCount <= 10) continue;
                            break block5;
                        }
                        nullCount = 0;
                        Thread.sleep(100L);
                        if (logger.isTraceEnabled()) {
                            logger.trace("Message received:" + msg.getJMSMessageID());
                        }
                        ++msgCount;
                    }
                }
                catch (JMSException e) {
                    logger.error("Failed to consume:", (Throwable)e);
                    continue;
                }
                catch (InterruptedException e) {
                    logger.error("Interrupted!", (Throwable)e);
                    continue;
                }
                break;
            }
            try {
                this.consumer.close();
            }
            catch (JMSException e) {
                logger.error("Failed to close consumer " + this.getName(), (Throwable)e);
            }
            DispatchMultipleConsumersTest.this.consumedCount.addAndGet(msgCount);
            DispatchMultipleConsumersTest.this.consumerLatch.countDown();
            logger.trace("Consumed " + msgCount + " messages using thread " + this.getName());
        }
    }
}

