/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.management.ObjectName;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyNetworkConsumersDisconnectTest
extends JmsMultipleBrokersTestSupport
implements Thread.UncaughtExceptionHandler {
    public static final int BROKER_COUNT = 3;
    public static final int CONSUMER_COUNT = 5;
    public static final int MESSAGE_COUNT = 0;
    public static final boolean DUPLEX = false;
    public static final boolean CONDUIT = true;
    public static final int NETWORK_TTL = 6;
    private static final Logger LOG = LoggerFactory.getLogger(VerifyNetworkConsumersDisconnectTest.class);
    public static final int TIMEOUT = 30000;
    protected Map<String, MessageConsumer> consumerMap;
    Map<Thread, Throwable> unhandledExceptions = new HashMap<Thread, Throwable>();

    private void assertNoUnhandledExceptions() {
        for (Map.Entry<Thread, Throwable> e : this.unhandledExceptions.entrySet()) {
            LOG.error("Thread:" + e.getKey() + " Had unexpected: " + e.getValue());
        }
        VerifyNetworkConsumersDisconnectTest.assertTrue((String)("There are no unhandled exceptions, see: log for detail on: " + this.unhandledExceptions), (boolean)this.unhandledExceptions.isEmpty());
    }

    public NetworkConnector bridge(String from, String to) throws Exception {
        NetworkConnector networkConnector = this.bridgeBrokers(from, to, true, 6, true);
        networkConnector.setSuppressDuplicateQueueSubscriptions(true);
        networkConnector.setDecreaseNetworkConsumerPriority(true);
        networkConnector.setDuplex(false);
        return networkConnector;
    }

    public void testConsumerOnEachBroker() throws Exception {
        int i;
        this.bridge("Broker0", "Broker1");
        this.bridge("Broker1", "Broker0");
        this.bridge("Broker1", "Broker2");
        this.bridge("Broker2", "Broker1");
        this.startAllBrokers();
        this.waitForBridgeFormation(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker0")).broker, 1, 0);
        this.waitForBridgeFormation(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker2")).broker, 1, 0);
        this.waitForBridgeFormation(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker1")).broker, 1, 0);
        this.waitForBridgeFormation(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker1")).broker, 1, 1);
        ActiveMQDestination dest = this.createDestination("TEST.FOO", false);
        for (int i2 = 0; i2 < 3; ++i2) {
            this.consumerMap.put("Consumer:" + i2 + ":0", this.createConsumer("Broker" + i2, (Destination)dest));
        }
        this.assertExactConsumersConnect("Broker0", 3, 1, 30000L);
        this.assertExactConsumersConnect("Broker2", 3, 1, 30000L);
        this.assertExactConsumersConnect("Broker1", 3, 1, 30000L);
        this.assertNoUnhandledExceptions();
        LOG.info("Complete the mesh - 0->2");
        NetworkConnector nc = this.bridge("Broker0", "Broker2");
        nc.setBrokerName("Broker0");
        nc.start();
        LOG.info("... complete the mesh - 2->0");
        nc = this.bridge("Broker2", "Broker0");
        nc.setBrokerName("Broker2");
        nc.start();
        for (i = 0; i < 3; ++i) {
            this.assertExactConsumersConnect("Broker" + i, 3, 1, 30000L);
        }
        this.consumerMap.get("Consumer:2:0").close();
        TimeUnit.SECONDS.sleep(1L);
        this.consumerMap.get("Consumer:1:0").close();
        TimeUnit.SECONDS.sleep(1L);
        this.consumerMap.get("Consumer:0:0").close();
        LOG.info("Check for no consumers..");
        for (i = 0; i < 3; ++i) {
            this.assertExactConsumersConnect("Broker" + i, 0, 0, 30000L);
        }
    }

    public void testXConsumerOnEachBroker() throws Exception {
        int i;
        int i2;
        this.bridge("Broker0", "Broker1");
        this.bridge("Broker1", "Broker0");
        this.bridge("Broker1", "Broker2");
        this.bridge("Broker2", "Broker1");
        this.startAllBrokers();
        this.waitForBridgeFormation(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker0")).broker, 1, 0);
        this.waitForBridgeFormation(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker2")).broker, 1, 0);
        this.waitForBridgeFormation(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker1")).broker, 1, 0);
        this.waitForBridgeFormation(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker1")).broker, 1, 1);
        ActiveMQDestination dest = this.createDestination("TEST.FOO", false);
        for (i2 = 0; i2 < 3; ++i2) {
            for (int j = 0; j < 5; ++j) {
                this.consumerMap.put("Consumer:" + i2 + ":" + j, this.createConsumer("Broker" + i2, (Destination)dest));
            }
        }
        for (i2 = 0; i2 < 3; ++i2) {
            this.assertExactConsumersConnect("Broker" + i2, 7, 1, 30000L);
        }
        this.assertNoUnhandledExceptions();
        LOG.info("Complete the mesh - 0->2");
        NetworkConnector nc = this.bridge("Broker0", "Broker2");
        nc.setBrokerName("Broker0");
        nc.start();
        this.waitForBridgeFormation(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker0")).broker, 1, 1);
        LOG.info("... complete the mesh - 2->0");
        nc = this.bridge("Broker2", "Broker0");
        nc.setBrokerName("Broker2");
        nc.start();
        this.waitForBridgeFormation(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker2")).broker, 1, 1);
        for (i = 0; i < 3; ++i) {
            this.assertExactConsumersConnect("Broker" + i, 7, 1, 30000L);
        }
        for (i = 0; i < 5; ++i) {
            this.consumerMap.get("Consumer:2:" + i).close();
            TimeUnit.SECONDS.sleep(1L);
            this.consumerMap.get("Consumer:1:" + i).close();
            TimeUnit.SECONDS.sleep(1L);
            this.consumerMap.get("Consumer:0:" + i).close();
        }
        LOG.info("Check for no consumers..");
        for (i = 0; i < 3; ++i) {
            this.assertExactConsumersConnect("Broker" + i, 0, 0, 30000L);
        }
    }

    protected void assertExactConsumersConnect(final String brokerName, final int count, final int numChecks, long timeout) throws Exception {
        final ManagementContext context = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)brokerName)).broker.getManagementContext();
        final AtomicInteger stability = new AtomicInteger(0);
        VerifyNetworkConsumersDisconnectTest.assertTrue((String)("Expected consumers count: " + count + " on: " + brokerName), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                try {
                    QueueViewMBean queueViewMBean = (QueueViewMBean)context.newProxyInstance(((JmsMultipleBrokersTestSupport.BrokerItem)((VerifyNetworkConsumersDisconnectTest)VerifyNetworkConsumersDisconnectTest.this).brokers.get((Object)brokerName)).broker.getAdminView().getQueues()[0], QueueViewMBean.class, false);
                    long currentCount = queueViewMBean.getConsumerCount();
                    LOG.info("On " + brokerName + " current consumer count for " + queueViewMBean + ", " + currentCount);
                    LinkedList<String> consumerIds = new LinkedList<String>();
                    for (ObjectName objectName : queueViewMBean.getSubscriptions()) {
                        consumerIds.add(objectName.getKeyProperty("consumerId"));
                    }
                    LOG.info("Sub IDs: " + consumerIds);
                    if (currentCount == (long)count) {
                        stability.incrementAndGet();
                    } else {
                        stability.set(0);
                    }
                    return stability.get() > numChecks;
                }
                catch (Exception e) {
                    LOG.warn(": ", (Throwable)e);
                    return false;
                }
            }
        }, (long)timeout));
    }

    @Override
    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        this.unhandledExceptions.clear();
        Thread.setDefaultUncaughtExceptionHandler(this);
        for (int i = 0; i < 3; ++i) {
            this.createBroker(new URI("broker:(tcp://localhost:6161" + i + ")/Broker" + i + "?persistent=false&useJmx=true&brokerId=Broker" + i));
        }
        this.consumerMap = new LinkedHashMap<String, MessageConsumer>();
    }

    @Override
    protected void configureBroker(BrokerService brokerService) {
        PolicyEntry policyEntry = new PolicyEntry();
        policyEntry.setExpireMessagesPeriod(0L);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setDefaultEntry(policyEntry);
        brokerService.setDestinationPolicy(policyMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Map<Thread, Throwable> map = this.unhandledExceptions;
        synchronized (map) {
            this.unhandledExceptions.put(t, e);
        }
    }
}

