/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.activemq.JmsTopicRedeliverTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSDurableTopicRedeliverTest
extends JmsTopicRedeliverTest {
    private static final Logger LOG = LoggerFactory.getLogger(JMSDurableTopicRedeliverTest.class);

    @Override
    protected void setUp() throws Exception {
        this.durable = true;
        super.setUp();
    }

    public void testRedeliverNewSession() throws Exception {
        String text = "TEST: " + System.currentTimeMillis();
        TextMessage sendMessage = this.session.createTextMessage(text);
        if (this.verbose) {
            LOG.info("About to send a message: " + sendMessage + " with text: " + text);
        }
        this.producer.send(this.producerDestination, (Message)sendMessage);
        Message unackMessage = this.consumer.receive(1000L);
        JMSDurableTopicRedeliverTest.assertNotNull((Object)unackMessage);
        String unackId = unackMessage.getJMSMessageID();
        JMSDurableTopicRedeliverTest.assertEquals((String)((TextMessage)unackMessage).getText(), (String)text);
        JMSDurableTopicRedeliverTest.assertFalse((boolean)unackMessage.getJMSRedelivered());
        JMSDurableTopicRedeliverTest.assertEquals((int)unackMessage.getIntProperty("JMSXDeliveryCount"), (int)1);
        this.consumeSession.close();
        this.consumer.close();
        this.consumeSession = this.connection.createSession(false, 2);
        this.consumer = this.createConsumer();
        Message ackMessage = this.consumer.receive(1000L);
        JMSDurableTopicRedeliverTest.assertNotNull((Object)ackMessage);
        ackMessage.acknowledge();
        String ackId = ackMessage.getJMSMessageID();
        JMSDurableTopicRedeliverTest.assertEquals((String)((TextMessage)ackMessage).getText(), (String)text);
        JMSDurableTopicRedeliverTest.assertTrue((boolean)ackMessage.getJMSRedelivered());
        JMSDurableTopicRedeliverTest.assertEquals((int)ackMessage.getIntProperty("JMSXDeliveryCount"), (int)2);
        JMSDurableTopicRedeliverTest.assertEquals((String)unackId, (String)ackId);
        this.consumeSession.close();
        this.consumer.close();
        this.consumeSession = this.connection.createSession(false, 2);
        this.consumer = this.createConsumer();
        JMSDurableTopicRedeliverTest.assertNull((Object)this.consumer.receive(1000L));
    }
}

