/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.springframework.context.support.AbstractApplicationContext;

public abstract class SpringTestSupport
extends TestCase {
    protected AbstractApplicationContext context;

    protected void setUp() throws Exception {
        this.context = this.createApplicationContext();
    }

    protected abstract AbstractApplicationContext createApplicationContext();

    protected void tearDown() throws Exception {
        if (this.context != null) {
            this.context.destroy();
        }
    }

    protected Object getBean(String name) {
        Object bean = this.context.getBean(name);
        if (bean == null) {
            SpringTestSupport.fail((String)("Should have found bean named '" + name + "' in the Spring ApplicationContext"));
        }
        return bean;
    }

    protected void assertSetEquals(String description, Object[] expected, Set<?> actual) {
        HashSet<Object> expectedSet = new HashSet<Object>();
        expectedSet.addAll(Arrays.asList(expected));
        SpringTestSupport.assertEquals((String)description, expectedSet, actual);
    }
}

