/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import java.io.IOException;
import java.net.URI;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.ft.QueueMasterSlaveTestSupport;
import org.apache.activemq.broker.ft.SyncCreateDataSource;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.DataSourceServiceSupport;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.util.DefaultIOExceptionHandler;
import org.apache.activemq.util.IOExceptionHandler;
import org.apache.activemq.util.IOHelper;
import org.apache.derby.jdbc.EmbeddedDataSource;

public class JDBCQueueMasterSlaveTest
extends QueueMasterSlaveTestSupport {
    protected SyncCreateDataSource sharedDs;
    protected String MASTER_URL = "tcp://localhost:62001";
    protected String SLAVE_URL = "tcp://localhost:62002";

    @Override
    protected void setUp() throws Exception {
        this.sharedDs = new SyncCreateDataSource((EmbeddedDataSource)DataSourceServiceSupport.createDataSource((String)IOHelper.getDefaultDataDirectory()));
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        DataSourceServiceSupport.shutdownDefaultDataSource((DataSource)this.sharedDs.delegate);
    }

    @Override
    protected void createMaster() throws Exception {
        this.master = new BrokerService();
        this.master.setBrokerName("master");
        this.master.addConnector(this.MASTER_URL);
        this.master.setUseJmx(false);
        this.master.setPersistent(true);
        this.master.setDeleteAllMessagesOnStartup(true);
        JDBCPersistenceAdapter persistenceAdapter = new JDBCPersistenceAdapter();
        persistenceAdapter.setDataSource(this.getExistingDataSource());
        this.configureJdbcPersistenceAdapter(persistenceAdapter);
        this.master.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
        this.configureBroker(this.master);
        this.master.start();
    }

    protected void configureBroker(BrokerService brokerService) {
        DefaultIOExceptionHandler stopBrokerOnStoreException = new DefaultIOExceptionHandler();
        stopBrokerOnStoreException.setIgnoreSQLExceptions(false);
        brokerService.setIoExceptionHandler((IOExceptionHandler)stopBrokerOnStoreException);
    }

    @Override
    protected void createSlave() throws Exception {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    BrokerService broker = new BrokerService();
                    broker.setBrokerName("slave");
                    TransportConnector connector = new TransportConnector();
                    connector.setUri(new URI(JDBCQueueMasterSlaveTest.this.SLAVE_URL));
                    broker.addConnector(connector);
                    broker.setUseJmx(false);
                    broker.setPersistent(true);
                    JDBCPersistenceAdapter persistenceAdapter = new JDBCPersistenceAdapter();
                    persistenceAdapter.setDataSource(JDBCQueueMasterSlaveTest.this.getExistingDataSource());
                    persistenceAdapter.setCreateTablesOnStartup(false);
                    broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
                    JDBCQueueMasterSlaveTest.this.configureJdbcPersistenceAdapter(persistenceAdapter);
                    JDBCQueueMasterSlaveTest.this.configureBroker(broker);
                    broker.start();
                    JDBCQueueMasterSlaveTest.this.slave.set(broker);
                    JDBCQueueMasterSlaveTest.this.slaveStarted.countDown();
                }
                catch (IllegalStateException expectedOnShutdown) {
                }
                catch (Exception e) {
                    TestCase.fail((String)("failed to start slave broker, reason:" + e));
                }
            }
        };
        t.start();
    }

    protected void configureJdbcPersistenceAdapter(JDBCPersistenceAdapter persistenceAdapter) throws IOException {
        persistenceAdapter.setLockKeepAlivePeriod(500L);
        persistenceAdapter.getLocker().setLockAcquireSleepInterval(500L);
    }

    protected DataSource getExistingDataSource() throws Exception {
        return this.sharedDs;
    }
}

