/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.Locker;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.ft.QueueMasterSlaveTestSupport;
import org.apache.activemq.broker.ft.SyncCreateDataSource;
import org.apache.activemq.store.jdbc.DataSourceServiceSupport;
import org.apache.activemq.store.jdbc.LeaseDatabaseLocker;
import org.apache.activemq.store.jdbc.Statements;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.util.DefaultIOExceptionHandler;
import org.apache.activemq.util.IOExceptionHandler;
import org.apache.activemq.util.IOHelper;
import org.apache.derby.jdbc.EmbeddedDataSource;

public class kahaDbJdbcLeaseQueueMasterSlaveTest
extends QueueMasterSlaveTestSupport {
    protected DataSource sharedDs;
    protected String MASTER_URL = "tcp://localhost:62001";
    protected String SLAVE_URL = "tcp://localhost:62002";
    File sharedDbDirFile;

    @Override
    protected void setUp() throws Exception {
        this.sharedDs = new SyncCreateDataSource((EmbeddedDataSource)DataSourceServiceSupport.createDataSource((String)IOHelper.getDefaultDataDirectory()));
        this.sharedDbDirFile = new File(new File(IOHelper.getDefaultDataDirectory()), "sharedKahaDB");
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        DataSourceServiceSupport.shutdownDefaultDataSource((DataSource)((SyncCreateDataSource)this.sharedDs).getDelegate());
    }

    @Override
    protected void createMaster() throws Exception {
        this.master = new BrokerService();
        this.master.setBrokerName("master");
        this.master.addConnector(this.MASTER_URL);
        this.master.setUseJmx(false);
        this.master.setPersistent(true);
        this.master.setDeleteAllMessagesOnStartup(true);
        KahaDBPersistenceAdapter kahaDBPersistenceAdapter = (KahaDBPersistenceAdapter)this.master.getPersistenceAdapter();
        kahaDBPersistenceAdapter.setDirectory(this.sharedDbDirFile);
        LeaseDatabaseLocker leaseDatabaseLocker = new LeaseDatabaseLocker();
        leaseDatabaseLocker.setCreateTablesOnStartup(true);
        leaseDatabaseLocker.setDataSource(this.getExistingDataSource());
        leaseDatabaseLocker.setStatements(new Statements());
        kahaDBPersistenceAdapter.setLocker((Locker)leaseDatabaseLocker);
        this.configureLocker(kahaDBPersistenceAdapter);
        this.configureBroker(this.master);
        this.master.start();
        this.master.waitUntilStarted();
    }

    protected void configureBroker(BrokerService brokerService) {
        DefaultIOExceptionHandler stopBrokerOnStoreException = new DefaultIOExceptionHandler();
        stopBrokerOnStoreException.setIgnoreSQLExceptions(false);
        brokerService.setIoExceptionHandler((IOExceptionHandler)stopBrokerOnStoreException);
    }

    @Override
    protected void createSlave() throws Exception {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    BrokerService broker = new BrokerService();
                    broker.setBrokerName("slave");
                    TransportConnector connector = new TransportConnector();
                    connector.setUri(new URI(kahaDbJdbcLeaseQueueMasterSlaveTest.this.SLAVE_URL));
                    broker.addConnector(connector);
                    broker.setUseJmx(false);
                    broker.setPersistent(true);
                    KahaDBPersistenceAdapter kahaDBPersistenceAdapter = (KahaDBPersistenceAdapter)broker.getPersistenceAdapter();
                    kahaDBPersistenceAdapter.setDirectory(kahaDbJdbcLeaseQueueMasterSlaveTest.this.sharedDbDirFile);
                    LeaseDatabaseLocker leaseDatabaseLocker = new LeaseDatabaseLocker();
                    leaseDatabaseLocker.setDataSource(kahaDbJdbcLeaseQueueMasterSlaveTest.this.getExistingDataSource());
                    leaseDatabaseLocker.setStatements(new Statements());
                    kahaDBPersistenceAdapter.setLocker((Locker)leaseDatabaseLocker);
                    kahaDbJdbcLeaseQueueMasterSlaveTest.this.configureLocker(kahaDBPersistenceAdapter);
                    kahaDbJdbcLeaseQueueMasterSlaveTest.this.configureBroker(broker);
                    kahaDbJdbcLeaseQueueMasterSlaveTest.this.slave.set(broker);
                    broker.start();
                    kahaDbJdbcLeaseQueueMasterSlaveTest.this.slaveStarted.countDown();
                }
                catch (IllegalStateException expectedOnShutdown) {
                }
                catch (Exception e) {
                    TestCase.fail((String)("failed to start slave broker, reason:" + e));
                }
            }
        };
        t.start();
    }

    protected void configureLocker(KahaDBPersistenceAdapter kahaDBPersistenceAdapter) throws IOException {
        kahaDBPersistenceAdapter.setLockKeepAlivePeriod(500L);
        kahaDBPersistenceAdapter.getLocker().setLockAcquireSleepInterval(500L);
    }

    protected DataSource getExistingDataSource() throws Exception {
        return this.sharedDs;
    }
}

