/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.Assert;
import org.junit.Test;

public class AMQ2383Test {
    @Test
    public void activeMQTest() throws Exception {
        ActiveMQDestination dest = ActiveMQQueue.createDestination((String)"testQueue", (byte)1);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost?broker.useJmx=false&broker.persistent=false");
        Connection producerConnection = factory.createConnection();
        producerConnection.start();
        Connection consumerConnection = factory.createConnection();
        consumerConnection.start();
        Session producerSession = producerConnection.createSession(false, 1);
        MessageProducer producer = producerSession.createProducer((Destination)dest);
        TextMessage sentMsg = producerSession.createTextMessage("test...");
        producer.send((Message)sentMsg);
        producerSession.close();
        Session consumerSession = consumerConnection.createSession(true, 0);
        MessageConsumer consumer = consumerSession.createConsumer((Destination)dest);
        TextMessage receivedMsg = (TextMessage)consumer.receive();
        consumerSession.rollback();
        consumerSession.close();
        Assert.assertEquals((Object)sentMsg, (Object)receivedMsg);
        producerConnection.close();
        consumerConnection.close();
    }
}

