/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Connection;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerView;
import org.apache.activemq.broker.jmx.DurableSubscriptionViewMBean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ3992Test {
    private static final transient Logger LOG = LoggerFactory.getLogger(AMQ3992Test.class);
    private static BrokerService brokerService;
    private static String BROKER_ADDRESS;
    private String connectionUri;

    @Before
    public void setUp() throws Exception {
        brokerService = new BrokerService();
        brokerService.setPersistent(false);
        brokerService.setUseJmx(true);
        brokerService.setDeleteAllMessagesOnStartup(true);
        this.connectionUri = brokerService.addConnector(BROKER_ADDRESS).getPublishableConnectString();
        brokerService.start();
        brokerService.waitUntilStarted();
    }

    @After
    public void tearDown() throws Exception {
        brokerService.stop();
        brokerService.waitUntilStopped();
    }

    @Test
    public void testDurableConsumerEnqueueCountWithZeroPrefetch() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.connectionUri);
        connectionFactory.getPrefetchPolicy().setAll(0);
        Connection connection = connectionFactory.createConnection();
        connection.setClientID(this.getClass().getName());
        connection.start();
        Session session = connection.createSession(false, 1);
        Topic destination = session.createTopic("DurableTopic");
        TopicSubscriber consumer = session.createDurableSubscriber(destination, "EnqueueSub");
        BrokerView view = brokerService.getAdminView();
        view.getDurableTopicSubscribers();
        ObjectName subName = view.getDurableTopicSubscribers()[0];
        DurableSubscriptionViewMBean sub = (DurableSubscriptionViewMBean)brokerService.getManagementContext().newProxyInstance(subName, DurableSubscriptionViewMBean.class, true);
        Assert.assertEquals((long)0L, (long)sub.getEnqueueCounter());
        LOG.info("Enqueue counter for sub before pull requests: " + sub.getEnqueueCounter());
        consumer.receive(500L);
        consumer.receive(500L);
        consumer.receive(500L);
        consumer.receive(500L);
        consumer.receive(500L);
        Thread.sleep(600L);
        LOG.info("Enqueue counter for sub after pull requests: " + sub.getEnqueueCounter());
        Assert.assertEquals((long)0L, (long)sub.getEnqueueCounter());
        consumer.close();
        session.close();
        connection.close();
    }

    static {
        BROKER_ADDRESS = "tcp://localhost:0";
    }
}

