/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerPluginSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ProducerInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ4213Test {
    private static BrokerService brokerService;
    private static String TEST_QUEUE;
    private static ActiveMQQueue queue;

    @Before
    public void setUp() throws Exception {
        brokerService = new BrokerService();
        brokerService.setPersistent(false);
        brokerService.setUseJmx(false);
        brokerService.setAdvisorySupport(false);
        brokerService.setPlugins(new BrokerPlugin[]{new BrokerPluginSupport(){

            public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
                throw new JMSSecurityException(brokerService.getVmConnectorURI().toString());
            }
        }});
        brokerService.start();
        brokerService.waitUntilStarted();
    }

    @After
    public void tearDown() throws Exception {
        brokerService.stop();
        brokerService.waitUntilStopped();
    }

    @Test(timeout=30000L)
    public void testExceptionOnProducerCreateThrows() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(brokerService.getVmConnectorURI());
        ActiveMQConnection connection = (ActiveMQConnection)factory.createConnection();
        Session session = connection.createSession(false, 2);
        connection.start();
        try {
            session.createProducer((Destination)queue);
            Assert.fail((String)"Should not be able to create this producer.");
        }
        catch (JMSException ex) {
            // empty catch block
        }
    }

    static {
        TEST_QUEUE = "testQueue";
        queue = new ActiveMQQueue(TEST_QUEUE);
    }
}

