/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.broker.LockableServiceSupport;
import org.apache.activemq.broker.Locker;
import org.apache.activemq.store.SharedFileLocker;
import org.apache.activemq.util.DefaultTestAppender;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.LockFile;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.Wait;
import org.apache.log4j.Appender;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedFileLockerTest {
    private static final Logger LOG = LoggerFactory.getLogger(SharedFileLockerTest.class);
    @Rule
    public TemporaryFolder testFolder;

    public SharedFileLockerTest() {
        File file = new File(IOHelper.getDefaultDataDirectory());
        file.mkdir();
        this.testFolder = new TemporaryFolder(file);
    }

    @Test
    public void testStopNoStart() throws Exception {
        SharedFileLocker locker1 = new SharedFileLocker();
        locker1.setDirectory(this.testFolder.getRoot());
        locker1.stop();
    }

    @Test
    public void testLoop() throws Exception {
        for (int i = 0; i < 100; ++i) {
            this.internalLoop(5L);
        }
    }

    @Test
    public void testLogging() throws Exception {
        this.internalLoop(100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalLoop(long timewait) throws Exception {
        final AtomicInteger logCounts = new AtomicInteger(0);
        DefaultTestAppender appender = new DefaultTestAppender(){

            public void doAppend(LoggingEvent event) {
                logCounts.incrementAndGet();
            }
        };
        org.apache.log4j.Logger.getRootLogger().addAppender((Appender)appender);
        final AtomicInteger errors = new AtomicInteger(0);
        Thread thread = null;
        SharedFileLocker locker1 = new SharedFileLocker();
        locker1.setDirectory(this.testFolder.getRoot());
        final SharedFileLocker locker2 = new SharedFileLocker();
        locker2.setLockAcquireSleepInterval(1L);
        locker2.setDirectory(this.testFolder.getRoot());
        try {
            locker1.doStart();
            Assert.assertTrue((boolean)locker1.keepAlive());
            thread = new Thread("Locker Thread"){

                @Override
                public void run() {
                    try {
                        locker2.doStart();
                    }
                    catch (Throwable e) {
                        errors.incrementAndGet();
                    }
                }
            };
            thread.start();
            long timeout = System.currentTimeMillis() + 5000L;
            while (logCounts.get() < 1 && System.currentTimeMillis() < timeout) {
                Thread.sleep(1L);
            }
            if (timewait > 0L) {
                Thread.sleep(timewait);
            }
            Assert.assertTrue((boolean)thread.isAlive());
            locker1.stop();
            thread.join(5000L);
            Assert.assertEquals((String)"Extra logs in place", (long)1L, (long)logCounts.get());
            timeout = System.currentTimeMillis() + 5000L;
            while (timeout > System.currentTimeMillis() && !locker2.keepAlive()) {
                Thread.sleep(1L);
            }
            Assert.assertTrue((boolean)locker2.keepAlive());
            locker2.stop();
            Assert.assertEquals((long)0L, (long)errors.get());
        }
        finally {
            org.apache.log4j.Logger.getRootLogger().removeAppender((Appender)appender);
            thread.join(1000L);
            if (thread.isAlive()) {
                thread.interrupt();
            }
            File lockFile = new File(this.testFolder.getRoot(), "lock");
            lockFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifyLockAcquireWaitsForLockDrop() throws Exception {
        final AtomicInteger logCounts = new AtomicInteger(0);
        DefaultTestAppender appender = new DefaultTestAppender(){

            public void doAppend(LoggingEvent event) {
                logCounts.incrementAndGet();
            }
        };
        org.apache.log4j.Logger sharedFileLogger = org.apache.log4j.Logger.getLogger(SharedFileLocker.class);
        sharedFileLogger.addAppender((Appender)appender);
        LockableServiceSupport config = new LockableServiceSupport(){

            public long getLockKeepAlivePeriod() {
                return 500L;
            }

            public Locker createDefaultLocker() throws IOException {
                return null;
            }

            public void init() throws Exception {
            }

            protected void doStop(ServiceStopper stopper) throws Exception {
            }

            protected void doStart() throws Exception {
            }
        };
        final SharedFileLocker underTest = new SharedFileLocker();
        underTest.setDirectory(this.testFolder.getRoot());
        underTest.setLockAcquireSleepInterval(5L);
        underTest.setLockable(config);
        File lockFile = new File(this.testFolder.getRoot(), "lock");
        String jvmProp = LockFile.class.getName() + ".lock." + lockFile.getCanonicalPath();
        System.getProperties().put(jvmProp, jvmProp);
        final CountDownLatch locked = new CountDownLatch(1);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            final AtomicLong acquireTime = new AtomicLong(0L);
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        underTest.start();
                        acquireTime.set(System.currentTimeMillis());
                        locked.countDown();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            junit.framework.Assert.assertTrue((String)"locker failed to obtain lock", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    return logCounts.get() > 0;
                }
            }, (long)5000L, (long)10L));
            long releaseTime = System.currentTimeMillis();
            System.getProperties().remove(jvmProp);
            junit.framework.Assert.assertTrue((String)"locker got lock", (boolean)locked.await(5L, TimeUnit.SECONDS));
            LOG.info("ReleaseTime: " + releaseTime + ", AcquireTime:" + acquireTime.get());
            junit.framework.Assert.assertTrue((String)("acquire delayed for keepAlive: " + config.getLockKeepAlivePeriod()), (acquireTime.get() >= releaseTime + config.getLockKeepAlivePeriod() ? 1 : 0) != 0);
        }
        finally {
            executorService.shutdownNow();
            underTest.stop();
            lockFile.delete();
            sharedFileLogger.removeAppender((Appender)appender);
        }
    }
}

