/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.leveldb.LevelDBStoreFactory;
import org.apache.activemq.perf.PerfConsumer;
import org.apache.activemq.perf.PerfProducer;
import org.apache.activemq.perf.SimpleTopicTest;
import org.apache.activemq.store.PersistenceAdapterFactory;

public class SimpleDurableTopicTest
extends SimpleTopicTest {
    protected long initialConsumerDelay = 0L;

    @Override
    protected void setUp() throws Exception {
        this.numberOfDestinations = 1;
        this.numberOfConsumers = 1;
        this.numberofProducers = Integer.parseInt(System.getProperty("SimpleDurableTopicTest.numberofProducers", "20"), 20);
        this.sampleCount = Integer.parseInt(System.getProperty("SimpleDurableTopicTest.sampleCount", "1000"), 10);
        this.playloadSize = 1024;
        super.setUp();
    }

    @Override
    protected void configureBroker(BrokerService answer, String uri) throws Exception {
        LevelDBStoreFactory persistenceFactory = new LevelDBStoreFactory();
        answer.setPersistenceFactory((PersistenceAdapterFactory)persistenceFactory);
        answer.addConnector(uri);
        answer.setUseShutdownHook(false);
    }

    @Override
    protected PerfProducer createProducer(ConnectionFactory fac, Destination dest, int number, byte[] payload) throws JMSException {
        PerfProducer pp = new PerfProducer(fac, dest, payload);
        pp.setDeliveryMode(2);
        return pp;
    }

    @Override
    protected PerfConsumer createConsumer(ConnectionFactory fac, Destination dest, int number) throws JMSException {
        PerfConsumer result = new PerfConsumer(fac, dest, "subs:" + number);
        result.setInitialDelay(this.initialConsumerDelay);
        return result;
    }

    @Override
    protected ActiveMQConnectionFactory createConnectionFactory(String uri) throws Exception {
        ActiveMQConnectionFactory result = super.createConnectionFactory(uri);
        return result;
    }
}

