/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.virtual.CompositeTopic;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.broker.region.virtual.VirtualDestinationInterceptor;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.util.ByteSequence;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualDestPerfTest {
    private static final Logger LOG = LoggerFactory.getLogger(VirtualDestPerfTest.class);
    public int messageSize = 5120;
    public int messageCount = 10000;
    ActiveMQTopic target = new ActiveMQTopic("target");
    BrokerService brokerService;
    ActiveMQConnectionFactory connectionFactory;

    @Test
    @Ignore(value="comparison test - 'new' no wait on future with async send broker side is always on")
    public void testAsyncSendBurstToFillCache() throws Exception {
        this.startBroker(4, true, true);
        this.connectionFactory.setUseAsyncSend(true);
        this.messageCount = 22000;
        this.messageSize = 10240;
        LinkedHashMap<Integer, Long> results = new LinkedHashMap<Integer, Long>();
        final ActiveMQQueue queue = new ActiveMQQueue("targetQ");
        for (Integer numThreads : new Integer[]{1, 2}) {
            ExecutorService executor = Executors.newFixedThreadPool(numThreads);
            final AtomicLong numMessagesToSend = new AtomicLong(this.messageCount);
            this.purge();
            long startTime = System.currentTimeMillis();
            for (int i = 0; i < numThreads; ++i) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            VirtualDestPerfTest.this.produceMessages(numMessagesToSend, (ActiveMQDestination)queue);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            executor.shutdown();
            executor.awaitTermination(5L, TimeUnit.MINUTES);
            long endTime = System.currentTimeMillis();
            long seconds = (endTime - startTime) / 1000L;
            LOG.info("For numThreads {} duration {}", (Object)numThreads, (Object)seconds);
            results.put(numThreads, seconds);
            LOG.info("Broker got {} messages", (Object)this.brokerService.getAdminView().getTotalEnqueueCount());
        }
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
        LOG.info("Results: {}", results);
    }

    private void purge() throws Exception {
        ObjectName[] queues = this.brokerService.getAdminView().getQueues();
        if (queues.length == 1) {
            QueueViewMBean queueViewMBean = (QueueViewMBean)this.brokerService.getManagementContext().newProxyInstance(queues[0], QueueViewMBean.class, false);
            queueViewMBean.purge();
        }
    }

    @Test
    @Ignore(value="comparison test - takes too long and really needs a peek at the graph")
    public void testPerf() throws Exception {
        LinkedHashMap<Integer, Long> resultsT = new LinkedHashMap<Integer, Long>();
        LinkedHashMap<Integer, Long> resultsF = new LinkedHashMap<Integer, Long>();
        for (int i = 2; i < 11; ++i) {
            for (Boolean concurrent : new Boolean[]{true, false}) {
                this.startBroker(i, concurrent, false);
                long startTime = System.currentTimeMillis();
                this.produceMessages(new AtomicLong(this.messageCount), (ActiveMQDestination)this.target);
                long endTime = System.currentTimeMillis();
                long seconds = (endTime - startTime) / 1000L;
                LOG.info("For routes {} duration {}", (Object)i, (Object)seconds);
                if (concurrent.booleanValue()) {
                    resultsT.put(i, seconds);
                } else {
                    resultsF.put(i, seconds);
                }
                this.brokerService.stop();
                this.brokerService.waitUntilStopped();
            }
        }
        LOG.info("results T{} F{}", resultsT, resultsF);
        LOG.info("http://www.chartgo.com/samples.do?chart=line&border=1&show3d=0&width=600&height=500&roundedge=1&transparency=1&legend=1&title=Send:10k::Concurrent-v-Serial&xtitle=routes&ytitle=Duration(seconds)&chrtbkgndcolor=white&threshold=0.0&lang=en&xaxis1=" + this.toStr(resultsT.keySet()) + "&yaxis1=" + this.toStr(resultsT.values()) + "&group1=concurrent" + "&xaxis2=" + this.toStr(resultsF.keySet()) + "&yaxis2=" + this.toStr(resultsF.values()) + "&group2=serial" + "&from=linejsp");
    }

    private String toStr(Collection set) {
        return set.toString().replace(",", "%0D%0A").replace("[", "").replace("]", "").replace(" ", "");
    }

    protected void produceMessages(AtomicLong messageCount, ActiveMQDestination destination) throws Exception {
        ByteSequence payLoad = new ByteSequence(new byte[this.messageSize]);
        Connection connection = this.connectionFactory.createConnection();
        MessageProducer messageProducer = connection.createSession(false, 1).createProducer((Destination)destination);
        messageProducer.setDeliveryMode(2);
        ActiveMQBytesMessage message = new ActiveMQBytesMessage();
        message.setContent(payLoad);
        while (messageCount.decrementAndGet() >= 0L) {
            messageProducer.send((Message)message);
        }
        connection.close();
    }

    private void startBroker(int fanoutCount, boolean concurrentSend, boolean concurrentStoreAndDispatchQueues) throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setDeleteAllMessagesOnStartup(true);
        this.brokerService.setUseVirtualTopics(true);
        this.brokerService.addConnector("tcp://0.0.0.0:0");
        this.brokerService.setAdvisorySupport(false);
        PolicyMap destPolicyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setExpireMessagesPeriod(0L);
        defaultEntry.setOptimizedDispatch(true);
        defaultEntry.setCursorMemoryHighWaterMark(110);
        destPolicyMap.setDefaultEntry(defaultEntry);
        this.brokerService.setDestinationPolicy(destPolicyMap);
        CompositeTopic route = new CompositeTopic();
        route.setName("target");
        route.setForwardOnly(true);
        route.setConcurrentSend(concurrentSend);
        ArrayList<ActiveMQQueue> routes = new ArrayList<ActiveMQQueue>();
        for (int i = 0; i < fanoutCount; ++i) {
            routes.add(new ActiveMQQueue("route." + i));
        }
        route.setForwardTo(routes);
        VirtualDestinationInterceptor interceptor = new VirtualDestinationInterceptor();
        interceptor.setVirtualDestinations(new VirtualDestination[]{route});
        this.brokerService.setDestinationInterceptors(new DestinationInterceptor[]{interceptor});
        this.brokerService.start();
        this.connectionFactory = new ActiveMQConnectionFactory(((TransportConnector)this.brokerService.getTransportConnectors().get(0)).getPublishableConnectString());
        this.connectionFactory.setWatchTopicAdvisories(false);
        if (this.brokerService.getPersistenceAdapter() instanceof KahaDBPersistenceAdapter) {
            ((KahaDBPersistenceAdapter)this.brokerService.getPersistenceAdapter()).setConcurrentStoreAndDispatchQueues(concurrentStoreAndDispatchQueues);
        }
    }
}

