/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ2213Test {
    BrokerService broker;
    ConnectionFactory factory;
    Connection connection;
    Session session;
    Queue queue;
    MessageConsumer consumer;

    public void createBroker(boolean deleteAll) throws Exception {
        this.broker = new BrokerService();
        this.broker.setDeleteAllMessagesOnStartup(deleteAll);
        this.broker.setDataDirectory("target/AMQ3145Test");
        this.broker.setUseJmx(true);
        this.broker.getManagementContext().setCreateConnector(false);
        this.broker.addConnector("tcp://localhost:0");
        this.broker.start();
        this.broker.waitUntilStarted();
        this.factory = new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getConnectUri().toString());
        this.connection = this.factory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 2);
    }

    @Before
    public void createBroker() throws Exception {
        this.createBroker(true);
    }

    @After
    public void tearDown() throws Exception {
        if (this.consumer != null) {
            this.consumer.close();
        }
        this.session.close();
        this.connection.stop();
        this.connection.close();
        this.broker.stop();
    }

    @Test
    public void testEqualsGenericSession() throws JMSException {
        Assert.assertNotNull((Object)this.connection);
        Session sess = this.connection.createSession(false, 1);
        Assert.assertTrue((boolean)sess.equals(sess));
    }

    @Test
    public void testEqualsTopicSession() throws JMSException {
        Assert.assertNotNull((Object)this.connection);
        Assert.assertTrue((boolean)(this.connection instanceof TopicConnection));
        TopicSession sess = ((TopicConnection)this.connection).createTopicSession(false, 1);
        Assert.assertTrue((boolean)sess.equals(sess));
    }

    @Test
    public void testEqualsQueueSession() throws JMSException {
        Assert.assertNotNull((Object)this.connection);
        Assert.assertTrue((boolean)(this.connection instanceof QueueConnection));
        QueueSession sess = ((QueueConnection)this.connection).createQueueSession(false, 1);
        Assert.assertTrue((boolean)sess.equals(sess));
    }
}

