/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.File;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.usecases.PublishOnTopicConsumedMessageTest;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class PublishOnTopicConsumerMessageUsingActivemqXMLTest
extends PublishOnTopicConsumedMessageTest {
    protected static final String JOURNAL_ROOT = "../data/";
    private static final transient Logger LOG = LoggerFactory.getLogger(PublishOnTopicConsumerMessageUsingActivemqXMLTest.class);
    BrokerService broker;

    @Override
    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("tcp://localhost:61616");
    }

    @Override
    protected void setUp() throws Exception {
        File journalFile = new File(JOURNAL_ROOT);
        PublishOnTopicConsumerMessageUsingActivemqXMLTest.recursiveDelete(journalFile);
        LOG.info("Creating broker... ");
        this.broker = this.createBroker("org/apache/activemq/usecases/activemq.xml");
        LOG.info("Success");
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        LOG.info("Closing Broker");
        if (this.broker != null) {
            this.broker.stop();
        }
        LOG.info("Broker closed...");
    }

    protected BrokerService createBroker(String resource) throws Exception {
        return this.createBroker((Resource)new ClassPathResource(resource));
    }

    protected BrokerService createBroker(Resource resource) throws Exception {
        BrokerFactoryBean factory = new BrokerFactoryBean(resource);
        factory.afterPropertiesSet();
        BrokerService broker = factory.getBroker();
        return broker;
    }
}

