/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import java.io.IOException;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.Locker;
import org.apache.activemq.broker.ft.DbRestartJDBCQueueMasterSlaveTest;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.LeaseDatabaseLocker;
import org.apache.activemq.util.IOExceptionHandler;
import org.apache.activemq.util.LeaseLockerIOExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbRestartJDBCQueueMasterSlaveLeaseTest
extends DbRestartJDBCQueueMasterSlaveTest {
    private static final transient Logger LOG = LoggerFactory.getLogger(DbRestartJDBCQueueMasterSlaveLeaseTest.class);

    @Override
    protected void configureJdbcPersistenceAdapter(JDBCPersistenceAdapter persistenceAdapter) throws IOException {
        super.configureJdbcPersistenceAdapter(persistenceAdapter);
        persistenceAdapter.setLocker((Locker)new LeaseDatabaseLocker());
        persistenceAdapter.getLocker().setLockAcquireSleepInterval(this.getLockAcquireSleepInterval());
        persistenceAdapter.setLockKeepAlivePeriod(this.getLockKeepAlivePeriod());
    }

    @Override
    protected void configureBroker(BrokerService brokerService) {
        LeaseLockerIOExceptionHandler ioExceptionHandler = new LeaseLockerIOExceptionHandler();
        ioExceptionHandler.setIgnoreSQLExceptions(false);
        ioExceptionHandler.setStopStartConnectors(false);
        ioExceptionHandler.setResumeCheckSleepPeriod(500L);
        brokerService.setIoExceptionHandler((IOExceptionHandler)ioExceptionHandler);
    }

    private long getLockKeepAlivePeriod() {
        return 1000L;
    }

    private long getLockAcquireSleepInterval() {
        return 8000L;
    }
}

