/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.TopicSubscriptionViewMBean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ2200Test {
    private static final String bindAddress = "tcp://0.0.0.0:0";
    private BrokerService broker;
    private ActiveMQConnectionFactory cf;

    @Before
    public void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDataDirectory("target" + File.separator + "activemq-data");
        this.broker.setPersistent(true);
        this.broker.setUseJmx(true);
        this.broker.setAdvisorySupport(false);
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.addConnector(bindAddress);
        String address = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
        this.broker.start();
        this.broker.waitUntilStarted();
        this.cf = new ActiveMQConnectionFactory(address);
    }

    @After
    public void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    @Test
    public void testTopicSubscriptionView() throws Exception {
        TopicConnection connection = this.cf.createTopicConnection();
        TopicSession session = connection.createTopicSession(false, 1);
        Topic destination = session.createTopic("TopicViewTestTopic");
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        Assert.assertNotNull((Object)consumer);
        TimeUnit.SECONDS.sleep(1L);
        ObjectName[] subscriptionNames = this.broker.getAdminView().getTopicSubscribers();
        Assert.assertTrue((subscriptionNames.length > 0 ? 1 : 0) != 0);
        boolean fail = true;
        for (ObjectName name : subscriptionNames) {
            if (!name.toString().contains("TopicViewTestTopic")) continue;
            TopicSubscriptionViewMBean sub = (TopicSubscriptionViewMBean)this.broker.getManagementContext().newProxyInstance(name, TopicSubscriptionViewMBean.class, true);
            Assert.assertNotNull((Object)sub);
            Assert.assertTrue((sub.getSessionId() != -1L ? 1 : 0) != 0);
            Assert.assertTrue((sub.getMaximumPendingQueueSize() == -1 ? 1 : 0) != 0);
            sub.setMaximumPendingQueueSize(1000);
            Assert.assertTrue((sub.getMaximumPendingQueueSize() != -1 ? 1 : 0) != 0);
            fail = false;
        }
        if (fail) {
            Assert.fail((String)"Didn't find the TopicSubscriptionView");
        }
    }
}

