/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.util.concurrent.CountDownLatch;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ4531Test
extends TestCase {
    private final Logger LOG = LoggerFactory.getLogger(AMQ4531Test.class);
    private String connectionURI;
    private MBeanServer mbeanServer;
    private BrokerService broker;

    protected void setUp() throws Exception {
        super.setUp();
        this.broker = new BrokerService();
        this.connectionURI = this.broker.addConnector("tcp://0.0.0.0:0?maximumConnections=1").getPublishableConnectString();
        this.broker.setPersistent(false);
        this.broker.start();
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    protected void tearDown() throws Exception {
        this.broker.stop();
        super.tearDown();
    }

    public AMQ4531Test(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(AMQ4531Test.class);
    }

    public void testFDSLeak() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.connectionURI);
        ActiveMQConnection connection = (ActiveMQConnection)factory.createConnection();
        connection.start();
        int connections = 100;
        final long original = this.openFileDescriptorCount();
        this.LOG.info("FD count: " + original);
        final CountDownLatch done = new CountDownLatch(connections);
        for (int i = 0; i < connections; ++i) {
            new Thread("worker: " + i){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ActiveMQConnection connection = null;
                    try {
                        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(AMQ4531Test.this.connectionURI);
                        connection = (ActiveMQConnection)factory.createConnection();
                        connection.start();
                    }
                    catch (Exception e) {
                        AMQ4531Test.this.LOG.debug(AMQ4531Test.this.getStack(e));
                    }
                    finally {
                        try {
                            connection.close();
                        }
                        catch (Exception e) {
                            AMQ4531Test.this.LOG.debug(AMQ4531Test.this.getStack(e));
                        }
                        done.countDown();
                        AMQ4531Test.this.LOG.debug("Latch count down called.");
                    }
                }
            }.start();
        }
        this.LOG.info("Waiting for latch...");
        done.await();
        this.LOG.info("Latch complete.");
        this.LOG.info("FD count: " + this.openFileDescriptorCount());
        AMQ4531Test.assertTrue((String)("Too many open file descriptors: " + this.openFileDescriptorCount()), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                long openFDs = AMQ4531Test.this.openFileDescriptorCount();
                AMQ4531Test.this.LOG.info("Current FD count [{}], original FD count[{}]", (Object)openFDs, (Object)original);
                return openFDs - original < 10L;
            }
        }));
    }

    private long openFileDescriptorCount() throws Exception {
        return (Long)this.mbeanServer.getAttribute(new ObjectName("java.lang:type=OperatingSystem"), "OpenFileDescriptorCount");
    }

    private String getStack(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }
}

