/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.nio;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.DestinationView;
import org.apache.activemq.broker.jmx.QueueView;
import org.apache.activemq.broker.region.policy.PendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.VMPendingQueueMessageStoragePolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOAsyncSendWithPFCTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(NIOAsyncSendWithPFCTest.class);
    private static String TRANSPORT_URL = "nio://0.0.0.0:0";
    private static final String DESTINATION_ONE = "testQ1";
    private static final String DESTINATION_TWO = "testQ2";
    private static final int MESSAGES_TO_SEND = 100;
    private static int NUMBER_OF_PRODUCERS = 10;

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setDeleteAllMessagesOnStartup(true);
        PolicyMap policyMap = new PolicyMap();
        ArrayList<PolicyEntry> entries = new ArrayList<PolicyEntry>();
        PolicyEntry pe = new PolicyEntry();
        pe.setMemoryLimit(256000L);
        pe.setPendingQueuePolicy((PendingQueueMessageStoragePolicy)new VMPendingQueueMessageStoragePolicy());
        pe.setQueue(">");
        entries.add(pe);
        policyMap.setPolicyEntries(entries);
        broker.setDestinationPolicy(policyMap);
        broker.addConnector(TRANSPORT_URL);
        broker.setDestinations(new ActiveMQDestination[]{new ActiveMQQueue(DESTINATION_ONE)});
        broker.start();
        TRANSPORT_URL = broker.getTransportConnectorByScheme("nio").getPublishableConnectString();
        return broker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAsyncSendPFCNewConnection() throws Exception {
        BrokerService broker = this.createBroker();
        broker.waitUntilStarted();
        ExecutorService executorService = Executors.newFixedThreadPool(NUMBER_OF_PRODUCERS);
        QueueView queueView = this.getQueueView(broker, DESTINATION_ONE);
        try {
            for (int i = 0; i < NUMBER_OF_PRODUCERS; ++i) {
                executorService.submit(new ProducerTask());
            }
            this.waitForProducerFlowControl(broker, queueView);
            try {
                this.sendMessagesAsync(1, DESTINATION_TWO);
            }
            catch (Exception ex) {
                LOG.error("Ex on send  new connection", (Throwable)ex);
                NIOAsyncSendWithPFCTest.fail((String)("*** received the following exception when creating addition producer new connection:" + ex));
            }
        }
        finally {
            broker.stop();
            broker.waitUntilStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAsyncSendPFCExistingConnection() throws Exception {
        BrokerService broker = this.createBroker();
        broker.waitUntilStarted();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("admin", "admin", TRANSPORT_URL + "?wireFormat.maxInactivityDuration=5000");
        ActiveMQConnection exisitngConnection = (ActiveMQConnection)connectionFactory.createConnection();
        ExecutorService executorService = Executors.newFixedThreadPool(NUMBER_OF_PRODUCERS);
        QueueView queueView = this.getQueueView(broker, DESTINATION_ONE);
        try {
            for (int i = 0; i < NUMBER_OF_PRODUCERS; ++i) {
                executorService.submit(new ProducerTask());
            }
            this.waitForProducerFlowControl(broker, queueView);
            try {
                Session i = exisitngConnection.createSession(false, 1);
            }
            catch (Exception ex) {
                LOG.error("Ex on create session", (Throwable)ex);
                NIOAsyncSendWithPFCTest.fail((String)("*** received the following exception when creating producer session:" + ex));
            }
        }
        finally {
            broker.stop();
            broker.waitUntilStopped();
        }
    }

    private void waitForProducerFlowControl(BrokerService broker, QueueView queueView) throws Exception {
        boolean blockingAllSends;
        do {
            blockingAllSends = queueView.getBlockedSends() > 10L;
            Thread.sleep(1000L);
        } while (!blockingAllSends);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long sendMessagesAsync(int messageCount, String destination) throws Exception {
        long numberOfMessageSent = 0L;
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("admin", "admin", TRANSPORT_URL);
        ActiveMQConnection connection = (ActiveMQConnection)connectionFactory.createConnection();
        connection.setUseAsyncSend(true);
        connection.start();
        try {
            Session producerSession = connection.createSession(false, 1);
            MessageProducer jmsProducer = producerSession.createProducer((Destination)producerSession.createQueue(destination));
            TextMessage sendMessage = this.createTextMessage(producerSession);
            for (int i = 0; i < messageCount; ++i) {
                jmsProducer.send((Message)sendMessage);
                ++numberOfMessageSent;
            }
            LOG.info(" Finished after producing : " + numberOfMessageSent);
            Long l = numberOfMessageSent;
            return l;
        }
        catch (Exception ex) {
            LOG.info("Exception received producing ", (Throwable)ex);
            LOG.info("finishing after exception :" + numberOfMessageSent);
            Long l = numberOfMessageSent;
            return l;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private TextMessage createTextMessage(Session session) throws JMSException {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 1000; ++i) {
            buffer.append("1234567890");
        }
        return session.createTextMessage(buffer.toString());
    }

    private QueueView getQueueView(BrokerService broker, String queueName) throws Exception {
        Map queueViews = broker.getAdminView().getBroker().getQueueViews();
        for (ObjectName key : queueViews.keySet()) {
            QueueView queueView;
            DestinationView destinationView = (DestinationView)queueViews.get(key);
            if (!(destinationView instanceof QueueView) || !(queueView = (QueueView)destinationView).getName().equals(queueName)) continue;
            return queueView;
        }
        return null;
    }

    class ProducerTask
    implements Runnable {
        ProducerTask() {
        }

        @Override
        public void run() {
            try {
                NIOAsyncSendWithPFCTest.this.sendMessagesAsync(100, NIOAsyncSendWithPFCTest.DESTINATION_ONE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

