/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import junit.textui.TestRunner;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.BlobMessage;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.BrokerMBeanSupport;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.CompositeDataHelper;
import org.apache.activemq.broker.jmx.ConnectionViewMBean;
import org.apache.activemq.broker.jmx.ConnectorViewMBean;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.broker.jmx.ProducerViewMBean;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.jmx.SubscriptionViewMBean;
import org.apache.activemq.broker.jmx.TopicViewMBean;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTempQueue;
import org.apache.activemq.util.JMXSupport;
import org.apache.activemq.util.URISupport;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanTest
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MBeanTest.class);
    private static boolean waitForKeyPress;
    protected MBeanServer mbeanServer;
    protected String domain = "org.apache.activemq";
    protected String clientID = "foo";
    protected Connection connection;
    protected boolean transacted;
    protected int authMode = 1;
    protected static final int MESSAGE_COUNT = 400;
    static final String QUEUE_WITH_OPTIONS = "QueueWithOptions";

    public static void main(String[] args) {
        waitForKeyPress = true;
        TestRunner.run(MBeanTest.class);
    }

    public void testConnectors() throws Exception {
        ObjectName brokerName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost");
        BrokerViewMBean broker = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, brokerName, BrokerViewMBean.class, true);
        MBeanTest.assertEquals((String)"openwire URL port doesn't equal bind Address", (int)new URI(broker.getTransportConnectorByType("tcp")).getPort(), (int)new URI(((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString()).getPort());
    }

    public void testMBeans() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.useConnection(this.connection);
        this.assertSendViaMBean();
        this.assertSendCsnvViaMBean();
        this.assertQueueBrowseWorks();
        this.assertCreateAndDestroyDurableSubscriptions();
        this.assertConsumerCounts();
        this.assertProducerCounts();
    }

    public void testMoveMessages() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.useConnection(this.connection);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + this.getDestinationString());
        QueueViewMBean queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        CompositeData[] compdatalist = queue.browse();
        int initialQueueSize = compdatalist.length;
        if (initialQueueSize == 0) {
            MBeanTest.fail((String)"There is no message in the queue:");
        } else {
            this.echo("Current queue size: " + initialQueueSize);
        }
        int messageCount = initialQueueSize;
        String[] messageIDs = new String[messageCount];
        for (int i = 0; i < messageCount; ++i) {
            CompositeData cdata = compdatalist[i];
            String messageID = (String)cdata.get("JMSMessageID");
            MBeanTest.assertNotNull((String)("Should have a message ID for message " + i), (Object)messageID);
            messageIDs[i] = messageID;
        }
        MBeanTest.assertTrue((String)"dest has some memory usage", (queue.getMemoryPercentUsage() > 0 ? 1 : 0) != 0);
        this.echo("About to move " + messageCount + " messages");
        String newDestination = this.getSecondDestinationString();
        for (String messageID : messageIDs) {
            queue.moveMessageTo(messageID, newDestination);
        }
        this.echo("Now browsing the queue");
        compdatalist = queue.browse();
        int actualCount = compdatalist.length;
        this.echo("Current queue size: " + actualCount);
        MBeanTest.assertEquals((String)"Should now have empty queue but was", (int)(initialQueueSize - messageCount), (int)actualCount);
        this.echo("Now browsing the second queue");
        queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + newDestination);
        QueueViewMBean queueNew = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        long newQueuesize = queueNew.getQueueSize();
        this.echo("Second queue size: " + newQueuesize);
        MBeanTest.assertEquals((String)"Unexpected number of messages ", (long)messageCount, (long)newQueuesize);
        MBeanTest.assertTrue((String)"new dest has some memory usage", (queueNew.getMemoryPercentUsage() > 0 ? 1 : 0) != 0);
        MBeanTest.assertEquals((String)"old dest has no memory usage", (int)0, (int)queue.getMemoryPercentUsage());
        MBeanTest.assertTrue((String)"use cache", (boolean)queueNew.isUseCache());
        MBeanTest.assertTrue((String)"cache enabled", (boolean)queueNew.isCacheEnabled());
        MBeanTest.assertEquals((String)"no forwards", (long)0L, (long)queueNew.getForwardCount());
    }

    public void Broken_testMoveDuplicateDoesNotDelete() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.useConnection(this.connection);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + this.getDestinationString());
        QueueViewMBean queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        CompositeData[] compdatalist = queue.browse();
        int initialQueueSize = compdatalist.length;
        CompositeData cdata = compdatalist[0];
        String messageID = (String)cdata.get("JMSMessageID");
        String newDestination = this.getSecondDestinationString();
        queue.copyMessageTo(messageID, newDestination);
        compdatalist = queue.browse();
        int actualCount = compdatalist.length;
        this.echo("Current queue size: " + actualCount);
        MBeanTest.assertEquals((String)"no change", (int)initialQueueSize, (int)actualCount);
        this.echo("Now browsing the second queue");
        queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + newDestination);
        QueueViewMBean queueNew = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        long newQueuesize = queueNew.getQueueSize();
        MBeanTest.assertEquals((String)"Expect one", (long)1L, (long)newQueuesize);
        boolean moveResult = queue.moveMessageTo(messageID, newDestination);
        MBeanTest.assertFalse((String)"move of duplicate should fail", (boolean)moveResult);
        newQueuesize = queueNew.getQueueSize();
        MBeanTest.assertEquals((String)"Expect one", (long)1L, (long)newQueuesize);
        compdatalist = queue.browse();
        actualCount = compdatalist.length;
        this.echo("Current queue size: " + actualCount);
        MBeanTest.assertEquals((String)"no change", (int)initialQueueSize, (int)actualCount);
    }

    public void testMoveCopyToSameDestFails() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.useConnection(this.connection);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + this.getDestinationString());
        QueueViewMBean queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        CompositeData[] compdatalist = queue.browse();
        int initialQueueSize = compdatalist.length;
        CompositeData cdata = compdatalist[0];
        String messageID = (String)cdata.get("JMSMessageID");
        MBeanTest.assertFalse((String)"fail to copy to self", (boolean)queue.copyMessageTo(messageID, this.getDestinationString()));
        MBeanTest.assertEquals((String)"fail to copy to self", (int)0, (int)queue.copyMatchingMessagesTo("", this.getDestinationString()));
        MBeanTest.assertEquals((String)"fail to copy x to self", (int)0, (int)queue.copyMatchingMessagesTo("", this.getDestinationString(), initialQueueSize));
        MBeanTest.assertFalse((String)"fail to move to self", (boolean)queue.moveMessageTo(messageID, this.getDestinationString()));
        MBeanTest.assertEquals((String)"fail to move to self", (int)0, (int)queue.moveMatchingMessagesTo("", this.getDestinationString()));
        MBeanTest.assertEquals((String)"fail to move x to self", (int)0, (int)queue.moveMatchingMessagesTo("", this.getDestinationString(), initialQueueSize));
        compdatalist = queue.browse();
        int actualCount = compdatalist.length;
        this.echo("Current queue size: " + actualCount);
        MBeanTest.assertEquals((String)"no change", (int)initialQueueSize, (int)actualCount);
    }

    public void testRemoveMessages() throws Exception {
        ObjectName brokerName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost");
        BrokerViewMBean broker = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, brokerName, BrokerViewMBean.class, true);
        broker.addQueue(this.getDestinationString());
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + this.getDestinationString());
        QueueViewMBean queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        String msg1 = queue.sendTextMessage("message 1");
        String msg2 = queue.sendTextMessage("message 2");
        MBeanTest.assertTrue((boolean)queue.removeMessage(msg2));
        this.connection = this.connectionFactory.createConnection();
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination dest = this.createDestination();
        MessageConsumer consumer = session.createConsumer((Destination)dest);
        Message message = consumer.receive(1000L);
        MBeanTest.assertNotNull((Object)message);
        MBeanTest.assertEquals((String)msg1, (String)message.getJMSMessageID());
        String msg3 = queue.sendTextMessage("message 3");
        message = consumer.receive(1000L);
        MBeanTest.assertNotNull((Object)message);
        MBeanTest.assertEquals((String)msg3, (String)message.getJMSMessageID());
        message = consumer.receive(1000L);
        MBeanTest.assertNull((Object)message);
    }

    public void testRemoveQueue() throws Exception {
        String queueName = "TEST";
        ObjectName brokerName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost");
        BrokerViewMBean broker = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, brokerName, BrokerViewMBean.class, true);
        broker.addQueue(queueName);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + queueName);
        QueueViewMBean queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        queue.sendTextMessage("message 1");
        queue.sendTextMessage("message 2");
        MBeanTest.assertEquals((long)2L, (long)broker.getTotalMessageCount());
        broker.removeQueue(queueName);
        MBeanTest.assertEquals((long)0L, (long)broker.getTotalMessageCount());
    }

    public void testRetryMessages() throws Exception {
        ActiveMQConnectionFactory factory = (ActiveMQConnectionFactory)this.connectionFactory;
        factory.getRedeliveryPolicy().setCollisionAvoidancePercent((short)0);
        factory.getRedeliveryPolicy().setMaximumRedeliveries(1);
        factory.getRedeliveryPolicy().setInitialRedeliveryDelay(0L);
        factory.getRedeliveryPolicy().setUseCollisionAvoidance(false);
        factory.getRedeliveryPolicy().setUseExponentialBackOff(false);
        factory.getRedeliveryPolicy().setBackOffMultiplier(0.0);
        this.connection = this.connectionFactory.createConnection();
        this.useConnection(this.connection);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + this.getDestinationString());
        QueueViewMBean queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        long initialQueueSize = queue.getQueueSize();
        this.echo("current queue size: " + initialQueueSize);
        MBeanTest.assertTrue((String)"dest has some memory usage", (queue.getMemoryPercentUsage() > 0 ? 1 : 0) != 0);
        Session session = this.connection.createSession(true, 0);
        MessageConsumer consumer = session.createConsumer((Destination)new ActiveMQQueue(this.getDestinationString()));
        Message message = consumer.receive(5000L);
        while (message != null) {
            this.echo("Message: " + message.getJMSMessageID() + " redelivered " + message.getJMSRedelivered() + " counter " + message.getObjectProperty("JMSXDeliveryCount"));
            session.rollback();
            message = consumer.receive(2000L);
        }
        consumer.close();
        session.close();
        Thread.sleep(1000L);
        ObjectName dlqQueueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + "ActiveMQ.DLQ");
        QueueViewMBean dlq = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, dlqQueueViewMBeanName, QueueViewMBean.class, true);
        long initialDlqSize = dlq.getQueueSize();
        CompositeData[] compdatalist = dlq.browse();
        int dlqQueueSize = compdatalist.length;
        if (dlqQueueSize == 0) {
            MBeanTest.fail((String)"There are no messages in the queue:");
        } else {
            this.echo("Current DLQ queue size: " + dlqQueueSize);
        }
        int messageCount = dlqQueueSize;
        String[] messageIDs = new String[messageCount];
        for (int i = 0; i < messageCount; ++i) {
            CompositeData cdata = compdatalist[i];
            String messageID = (String)cdata.get("JMSMessageID");
            MBeanTest.assertNotNull((String)("Should have a message ID for message " + i), (Object)messageID);
            messageIDs[i] = messageID;
        }
        int dlqMemUsage = dlq.getMemoryPercentUsage();
        MBeanTest.assertTrue((String)"dlq has some memory usage", (dlqMemUsage > 0 ? 1 : 0) != 0);
        MBeanTest.assertEquals((String)"dest has no memory usage", (int)0, (int)queue.getMemoryPercentUsage());
        this.echo("About to retry " + messageCount + " messages");
        for (String messageID : messageIDs) {
            this.echo("Retrying message: " + messageID);
            dlq.retryMessage(messageID);
        }
        long queueSize = queue.getQueueSize();
        compdatalist = queue.browse();
        int actualCount = compdatalist.length;
        this.echo("Orginal queue size is now " + queueSize);
        this.echo("Original browse queue size: " + actualCount);
        long dlqSize = dlq.getQueueSize();
        this.echo("DLQ size: " + dlqSize);
        MBeanTest.assertEquals((String)"DLQ size", (long)(initialDlqSize - (long)messageCount), (long)dlqSize);
        MBeanTest.assertEquals((String)"queue size", (long)initialQueueSize, (long)queueSize);
        MBeanTest.assertEquals((String)"browse queue size", (long)initialQueueSize, (long)actualCount);
        MBeanTest.assertEquals((String)"dest has some memory usage", (int)dlqMemUsage, (int)queue.getMemoryPercentUsage());
    }

    public void testMoveMessagesBySelector() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.useConnection(this.connection);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + this.getDestinationString());
        QueueViewMBean queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        String newDestination = this.getSecondDestinationString();
        queue.moveMatchingMessagesTo("counter > 2", newDestination);
        queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + newDestination);
        queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        int movedSize = 397;
        MBeanTest.assertEquals((String)"Unexpected number of messages ", (long)movedSize, (long)queue.getQueueSize());
        queue.removeMatchingMessages("counter > 2");
        MBeanTest.assertEquals((String)("Should have no more messages in the queue: " + queueViewMBeanName), (long)0L, (long)queue.getQueueSize());
        MBeanTest.assertEquals((String)"dest has no memory usage", (int)0, (int)queue.getMemoryPercentUsage());
    }

    public void testCopyMessagesBySelector() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.useConnection(this.connection);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + this.getDestinationString());
        QueueViewMBean queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        String newDestination = this.getSecondDestinationString();
        long queueSize = queue.getQueueSize();
        MBeanTest.assertTrue((queueSize > 0L ? 1 : 0) != 0);
        queue.copyMatchingMessagesTo("counter > 2", newDestination);
        queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + newDestination);
        queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        LOG.info("Queue: " + queueViewMBeanName + " now has: " + queue.getQueueSize() + " message(s)");
        MBeanTest.assertEquals((String)("Expected messages in a queue: " + queueViewMBeanName), (long)397L, (long)queue.getQueueSize());
        queue.removeMatchingMessages("counter > 2");
        MBeanTest.assertEquals((String)("Should have no more messages in the queue: " + queueViewMBeanName), (long)0L, (long)queue.getQueueSize());
        MBeanTest.assertEquals((String)"dest has no memory usage", (int)0, (int)queue.getMemoryPercentUsage());
    }

    public void testCopyPurgeCopyBack() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        int numMessages = 100;
        this.useConnection(this.connection, 100);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + this.getDestinationString());
        QueueViewMBean queueT = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        String newDestination = this.getSecondDestinationString();
        long queueSize = queueT.getQueueSize();
        MBeanTest.assertTrue((queueSize > 0L ? 1 : 0) != 0);
        int c = queueT.copyMatchingMessagesTo(null, newDestination);
        LOG.info("Copied: " + c);
        queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + newDestination);
        QueueViewMBean queueD = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        LOG.info("Queue: " + queueD.getName() + " now has: " + queueD.getQueueSize() + " message(s)");
        MBeanTest.assertEquals((String)("Expected messages in a queue: " + queueD.getQueueSize()), (long)100L, (long)queueD.getQueueSize());
        LOG.info("Queue: " + queueT.getName() + " now has: " + queueT.getQueueSize() + " message(s)");
        MBeanTest.assertEquals((String)("Expected messages in a queue: " + queueT.getQueueSize()), (long)100L, (long)queueT.getQueueSize());
        queueT.purge();
        queueD.copyMatchingMessagesTo(null, this.getDestinationString());
        LOG.info("Queue: " + queueD.getName() + " now has: " + queueD.getQueueSize() + " message(s)");
        MBeanTest.assertEquals((String)("Expected messages in a queue: " + queueD.getQueueSize()), (long)100L, (long)queueD.getQueueSize());
        LOG.info("Queue: " + queueT.getName() + " now has: " + queueT.getQueueSize() + " message(s)");
        MBeanTest.assertEquals((String)("Expected messages in a queue: " + queueT.getQueueSize()), (long)100L, (long)queueT.getQueueSize());
        this.assertNotRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + "ActiveMQ.DLQ");
    }

    public void testCreateDestinationWithSpacesAtEnds() throws Exception {
        ObjectName brokerName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost");
        BrokerViewMBean broker = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, brokerName, BrokerViewMBean.class, true);
        MBeanTest.assertTrue((String)"broker is not a slave", (!broker.isSlave() ? 1 : 0) != 0);
        broker.addTopic(this.getDestinationString() + "1 ");
        broker.addTopic(" " + this.getDestinationString() + "2");
        broker.addTopic(" " + this.getDestinationString() + "3 ");
        this.assertNotRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Topic,destinationName=" + this.getDestinationString() + "1 ");
        this.assertNotRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Topic,destinationName= " + this.getDestinationString() + "2");
        this.assertNotRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Topic,destinationName= " + this.getDestinationString() + "3 ");
        ObjectName topicObjName1 = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Topic,destinationName=" + this.getDestinationString() + "1");
        ObjectName topicObjName2 = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Topic,destinationName=" + this.getDestinationString() + "2");
        ObjectName topicObjName3 = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Topic,destinationName=" + this.getDestinationString() + "3");
        TopicViewMBean topic1 = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, topicObjName1, TopicViewMBean.class, true);
        TopicViewMBean topic2 = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, topicObjName2, TopicViewMBean.class, true);
        TopicViewMBean topic3 = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, topicObjName3, TopicViewMBean.class, true);
        MBeanTest.assertEquals((String)"topic1 Durable subscriber count", (long)0L, (long)topic1.getConsumerCount());
        MBeanTest.assertEquals((String)"topic2 Durable subscriber count", (long)0L, (long)topic2.getConsumerCount());
        MBeanTest.assertEquals((String)"topic3 Durable subscriber count", (long)0L, (long)topic3.getConsumerCount());
        String topicName = this.getDestinationString();
        String selector = null;
        broker.createDurableSubscriber(this.clientID, "topic1.subscriber1", topicName + "1", selector);
        broker.createDurableSubscriber(this.clientID, "topic2.subscriber1", topicName + "2", selector);
        broker.createDurableSubscriber(this.clientID, "topic3.subscriber1", topicName + "3", selector);
        MBeanTest.assertEquals((String)"topic1 Durable subscriber count", (long)1L, (long)topic1.getConsumerCount());
        MBeanTest.assertEquals((String)"topic2 Durable subscriber count", (long)1L, (long)topic2.getConsumerCount());
        MBeanTest.assertEquals((String)"topic3 Durable subscriber count", (long)1L, (long)topic3.getConsumerCount());
    }

    protected void assertSendViaMBean() throws Exception {
        String queueName = this.getDestinationString() + ".SendMBBean";
        ObjectName brokerName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost");
        this.echo("Create QueueView MBean...");
        BrokerViewMBean broker = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, brokerName, BrokerViewMBean.class, true);
        broker.addQueue(queueName);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + queueName);
        this.echo("Create QueueView MBean...");
        QueueViewMBean proxy = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        proxy.purge();
        int count = 5;
        for (int i = 0; i < count; ++i) {
            String body = "message:" + i;
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("JMSCorrelationID", "MyCorrId");
            headers.put("JMSDeliveryMode", Boolean.FALSE);
            headers.put("JMSXGroupID", "MyGroupID");
            headers.put("JMSXGroupSeq", 1234);
            headers.put("JMSPriority", i + 1);
            headers.put("JMSType", "MyType");
            headers.put("MyHeader", i);
            headers.put("MyStringHeader", "StringHeader" + i);
            proxy.sendTextMessage(headers, body);
        }
        this.browseAndVerify(proxy);
    }

    private void browseAndVerify(QueueViewMBean proxy) throws Exception {
        this.browseAndVerifyTypes(proxy, false);
    }

    private void browseAndVerifyTypes(QueueViewMBean proxy, boolean allStrings) throws Exception {
        CompositeData[] compdatalist = proxy.browse();
        if (compdatalist.length == 0) {
            MBeanTest.fail((String)"There is no message in the queue:");
        }
        for (int i = 0; i < compdatalist.length; ++i) {
            CompositeData cdata = compdatalist[i];
            if (i == 0) {
                this.echo("Columns: " + cdata.getCompositeType().keySet());
            }
            this.assertComplexData(i, cdata, "JMSCorrelationID", "MyCorrId");
            this.assertComplexData(i, cdata, "JMSPriority", i + 1);
            this.assertComplexData(i, cdata, "JMSType", "MyType");
            this.assertComplexData(i, cdata, "JMSCorrelationID", "MyCorrId");
            this.assertComplexData(i, cdata, "JMSDeliveryMode", "NON-PERSISTENT");
            String expected = "{MyStringHeader=StringHeader" + i + ", MyHeader=" + i + "}";
            if (System.getProperty("java.vendor").equals("IBM Corporation")) {
                expected = "{MyHeader=" + i + ", MyStringHeader=StringHeader" + i + "}";
            }
            this.assertComplexData(i, cdata, "PropertiesText", expected);
            if (allStrings) {
                Map stringProperties = CompositeDataHelper.getTabularMap((CompositeData)cdata, (String)"StringProperties");
                MBeanTest.assertEquals((String)"stringProperties size()", (int)2, (int)stringProperties.size());
                MBeanTest.assertEquals((String)"stringProperties.MyHeader", (Object)("StringHeader" + i), stringProperties.get("MyStringHeader"));
                MBeanTest.assertEquals((String)"stringProperties.MyHeader", (Object)("" + i), stringProperties.get("MyHeader"));
            } else {
                Map intProperties = CompositeDataHelper.getTabularMap((CompositeData)cdata, (String)"IntProperties");
                MBeanTest.assertEquals((String)"intProperties size()", (int)1, (int)intProperties.size());
                MBeanTest.assertEquals((String)"intProperties.MyHeader", (Object)i, intProperties.get("MyHeader"));
                Map stringProperties = CompositeDataHelper.getTabularMap((CompositeData)cdata, (String)"StringProperties");
                MBeanTest.assertEquals((String)"stringProperties size()", (int)1, (int)stringProperties.size());
                MBeanTest.assertEquals((String)"stringProperties.MyHeader", (Object)("StringHeader" + i), stringProperties.get("MyStringHeader"));
            }
            Map properties = CompositeDataHelper.getMessageUserProperties((CompositeData)cdata);
            MBeanTest.assertEquals((String)"properties size()", (int)2, (int)properties.size());
            MBeanTest.assertEquals((String)"properties.MyHeader", (Object)(allStrings ? "" + i : Integer.valueOf(i)), properties.get("MyHeader"));
            MBeanTest.assertEquals((String)"properties.MyHeader", (Object)("StringHeader" + i), properties.get("MyStringHeader"));
            this.assertComplexData(i, cdata, "JMSXGroupSeq", 1234);
            this.assertComplexData(i, cdata, "JMSXGroupID", "MyGroupID");
            this.assertComplexData(i, cdata, "Text", "message:" + i);
        }
    }

    protected void assertSendCsnvViaMBean() throws Exception {
        String queueName = this.getDestinationString() + ".SendMBBean";
        ObjectName brokerName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost");
        this.echo("Create QueueView MBean...");
        BrokerViewMBean broker = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, brokerName, BrokerViewMBean.class, true);
        broker.addQueue(queueName);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + queueName);
        this.echo("Create QueueView MBean...");
        QueueViewMBean proxy = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        proxy.purge();
        int count = 5;
        for (int i = 0; i < count; ++i) {
            String props = "body=message:" + i;
            props = props + ",JMSCorrelationID=MyCorrId";
            props = props + ",JMSDeliveryMode=1";
            props = props + ",JMSXGroupID=MyGroupID";
            props = props + ",JMSXGroupSeq=1234";
            props = props + ",JMSPriority=" + (i + 1);
            props = props + ",JMSType=MyType";
            props = props + ",MyHeader=" + i;
            props = props + ",MyStringHeader=StringHeader" + i;
            proxy.sendTextMessageWithProperties(props);
        }
        this.browseAndVerifyTypes(proxy, true);
    }

    protected void assertComplexData(int messageIndex, CompositeData cdata, String name, Object expected) {
        Object value = cdata.get(name);
        MBeanTest.assertEquals((String)("Message " + messageIndex + " CData field: " + name), (Object)expected, (Object)value);
    }

    protected void assertQueueBrowseWorks() throws Exception {
        Integer mbeancnt = this.mbeanServer.getMBeanCount();
        this.echo("Mbean count :" + mbeancnt);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + this.getDestinationString());
        this.echo("Create QueueView MBean...");
        QueueViewMBean proxy = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        long concount = proxy.getConsumerCount();
        this.echo("Consumer Count :" + concount);
        long messcount = proxy.getQueueSize();
        this.echo("current number of messages in the queue :" + messcount);
        CompositeData[] compdatalist = proxy.browse();
        if (compdatalist.length == 0) {
            MBeanTest.fail((String)"There is no message in the queue:");
        }
        String[] messageIDs = new String[compdatalist.length];
        for (int i = 0; i < compdatalist.length; ++i) {
            CompositeData cdata = compdatalist[i];
            if (i == 0) {
                this.echo("Columns: " + cdata.getCompositeType().keySet());
            }
            messageIDs[i] = (String)cdata.get("JMSMessageID");
            this.echo("message " + i + " : " + cdata.values());
        }
        TabularData table = proxy.browseAsTable();
        this.echo("Found tabular data: " + table);
        MBeanTest.assertTrue((String)"Table should not be empty!", (table.size() > 0 ? 1 : 0) != 0);
        MBeanTest.assertEquals((String)"Queue size", (long)400L, (long)proxy.getQueueSize());
        String messageID = messageIDs[0];
        String newDestinationName = "queue://dummy.test.cheese";
        this.echo("Attempting to copy: " + messageID + " to destination: " + newDestinationName);
        proxy.copyMessageTo(messageID, newDestinationName);
        MBeanTest.assertEquals((String)"Queue size", (long)400L, (long)proxy.getQueueSize());
        messageID = messageIDs[1];
        this.echo("Attempting to remove: " + messageID);
        proxy.removeMessage(messageID);
        MBeanTest.assertEquals((String)"Queue size", (long)399L, (long)proxy.getQueueSize());
        this.echo("Worked!");
    }

    protected void assertCreateAndDestroyDurableSubscriptions() throws Exception {
        ObjectName brokerName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost");
        this.echo("Create QueueView MBean...");
        BrokerViewMBean broker = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, brokerName, BrokerViewMBean.class, true);
        broker.addTopic(this.getDestinationString());
        MBeanTest.assertEquals((String)"Durable subscriber count", (int)0, (int)broker.getDurableTopicSubscribers().length);
        String topicName = this.getDestinationString();
        String selector = null;
        ObjectName name1 = broker.createDurableSubscriber(this.clientID, "subscriber1", topicName, selector);
        broker.createDurableSubscriber(this.clientID, "subscriber2", topicName, selector);
        MBeanTest.assertEquals((String)"Durable subscriber count", (int)2, (int)broker.getInactiveDurableTopicSubscribers().length);
        MBeanTest.assertNotNull((String)"Should have created an mbean name for the durable subscriber!", (Object)name1);
        LOG.info("Created durable subscriber with name: " + name1);
        broker.destroyDurableSubscriber(this.clientID, "subscriber1");
        MBeanTest.assertEquals((String)"Durable subscriber count", (int)1, (int)broker.getInactiveDurableTopicSubscribers().length);
    }

    protected void assertConsumerCounts() throws Exception {
        ObjectName brokerName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost");
        BrokerViewMBean broker = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, brokerName, BrokerViewMBean.class, true);
        MBeanTest.assertTrue((String)"broker is not a slave", (!broker.isSlave() ? 1 : 0) != 0);
        broker.addTopic(this.getDestinationString() + "1");
        broker.addTopic(this.getDestinationString() + "2");
        ObjectName topicObjName1 = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Topic,destinationName=" + this.getDestinationString() + "1");
        ObjectName topicObjName2 = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Topic,destinationName=" + this.getDestinationString() + "2");
        TopicViewMBean topic1 = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, topicObjName1, TopicViewMBean.class, true);
        TopicViewMBean topic2 = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, topicObjName2, TopicViewMBean.class, true);
        MBeanTest.assertEquals((String)"topic1 Durable subscriber count", (long)0L, (long)topic1.getConsumerCount());
        MBeanTest.assertEquals((String)"topic2 Durable subscriber count", (long)0L, (long)topic2.getConsumerCount());
        String topicName = this.getDestinationString();
        String selector = null;
        broker.createDurableSubscriber(this.clientID, "topic1.subscriber1", topicName + "1", selector);
        broker.createDurableSubscriber(this.clientID, "topic2.subscriber1", topicName + "2", selector);
        MBeanTest.assertEquals((String)"topic1 Durable subscriber count", (long)1L, (long)topic1.getConsumerCount());
        MBeanTest.assertEquals((String)"topic2 Durable subscriber count", (long)1L, (long)topic2.getConsumerCount());
        broker.createDurableSubscriber(this.clientID, "topic1.subscriber2", topicName + "1", selector);
        MBeanTest.assertEquals((String)"topic1 Durable subscriber count", (long)2L, (long)topic1.getConsumerCount());
        MBeanTest.assertEquals((String)"topic2 Durable subscriber count", (long)1L, (long)topic2.getConsumerCount());
        broker.destroyDurableSubscriber(this.clientID, "topic1.subscriber1");
        MBeanTest.assertEquals((String)"topic1 Durable subscriber count", (long)1L, (long)topic1.getConsumerCount());
        MBeanTest.assertEquals((String)"topic2 Durable subscriber count", (long)1L, (long)topic2.getConsumerCount());
        broker.destroyDurableSubscriber(this.clientID, "topic2.subscriber1");
        MBeanTest.assertEquals((String)"topic1 Durable subscriber count", (long)1L, (long)topic1.getConsumerCount());
        MBeanTest.assertEquals((String)"topic2 Durable subscriber count", (long)0L, (long)topic2.getConsumerCount());
        broker.destroyDurableSubscriber(this.clientID, "topic1.subscriber2");
        MBeanTest.assertEquals((String)"topic1 Durable subscriber count", (long)0L, (long)topic1.getConsumerCount());
        MBeanTest.assertEquals((String)"topic2 Durable subscriber count", (long)0L, (long)topic2.getConsumerCount());
    }

    protected void assertProducerCounts() throws Exception {
        ObjectName brokerName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost");
        BrokerViewMBean broker = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, brokerName, BrokerViewMBean.class, true);
        MBeanTest.assertTrue((String)"broker is not a slave", (!broker.isSlave() ? 1 : 0) != 0);
        broker.addTopic(this.getDestinationString() + "1");
        broker.addTopic(this.getDestinationString() + "2");
        ObjectName topicObjName1 = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Topic,destinationName=" + this.getDestinationString() + "1");
        ObjectName topicObjName2 = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Topic,destinationName=" + this.getDestinationString() + "2");
        TopicViewMBean topic1 = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, topicObjName1, TopicViewMBean.class, true);
        TopicViewMBean topic2 = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, topicObjName2, TopicViewMBean.class, true);
        MBeanTest.assertEquals((String)"topic1 Producer count", (long)0L, (long)topic1.getProducerCount());
        MBeanTest.assertEquals((String)"topic2 Producer count", (long)0L, (long)topic2.getProducerCount());
        MBeanTest.assertEquals((String)"broker Topic Producer count", (int)0, (int)broker.getTopicProducers().length);
        Session session = this.connection.createSession(false, 1);
        Topic dest1 = session.createTopic(this.getDestinationString() + "1");
        Topic dest2 = session.createTopic(this.getDestinationString() + "2");
        MessageProducer producer1 = session.createProducer((Destination)dest1);
        MessageProducer producer2 = session.createProducer((Destination)dest2);
        Thread.sleep(500L);
        MBeanTest.assertEquals((String)"topic1 Producer count", (long)1L, (long)topic1.getProducerCount());
        MBeanTest.assertEquals((String)"topic2 Producer count", (long)1L, (long)topic2.getProducerCount());
        MBeanTest.assertEquals((String)"broker Topic Producer count", (int)2, (int)broker.getTopicProducers().length);
        MessageProducer producer3 = session.createProducer((Destination)dest1);
        Thread.sleep(500L);
        MBeanTest.assertEquals((String)"topic1 Producer count", (long)2L, (long)topic1.getProducerCount());
        MBeanTest.assertEquals((String)"topic2 Producer count", (long)1L, (long)topic2.getProducerCount());
        MBeanTest.assertEquals((String)"broker Topic Producer count", (int)3, (int)broker.getTopicProducers().length);
        producer1.close();
        Thread.sleep(500L);
        MBeanTest.assertEquals((String)"topic1 Producer count", (long)1L, (long)topic1.getProducerCount());
        MBeanTest.assertEquals((String)"topic2 Producer count", (long)1L, (long)topic2.getProducerCount());
        MBeanTest.assertEquals((String)"broker Topic Producer count", (int)2, (int)broker.getTopicProducers().length);
        producer2.close();
        Thread.sleep(500L);
        MBeanTest.assertEquals((String)"topic1 Producer count", (long)1L, (long)topic1.getProducerCount());
        MBeanTest.assertEquals((String)"topic2 Producer count", (long)0L, (long)topic2.getProducerCount());
        MBeanTest.assertEquals((String)"broker Topic Producer count", (int)1, (int)broker.getTopicProducers().length);
        producer3.close();
        Thread.sleep(500L);
        MBeanTest.assertEquals((String)"topic1 Producer count", (long)0L, (long)topic1.getProducerCount());
        MBeanTest.assertEquals((String)"topic2 Producer count", (long)0L, (long)topic2.getProducerCount());
        MessageProducer producer4 = session.createProducer(null);
        Thread.sleep(500L);
        MBeanTest.assertEquals((int)1, (int)broker.getDynamicDestinationProducers().length);
        producer4.close();
        Thread.sleep(500L);
        MBeanTest.assertEquals((String)"broker Topic Producer count", (int)0, (int)broker.getTopicProducers().length);
    }

    protected ObjectName assertRegisteredObjectName(String name) throws MalformedObjectNameException, Exception {
        final ObjectName objectName = new ObjectName(name);
        final AtomicBoolean result = new AtomicBoolean(false);
        MBeanTest.assertTrue((String)("Bean registered: " + objectName), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                try {
                    result.set(MBeanTest.this.mbeanServer.isRegistered(objectName));
                }
                catch (Exception ignored) {
                    LOG.debug(ignored.toString());
                }
                return result.get();
            }
        }));
        return objectName;
    }

    protected ObjectName assertNotRegisteredObjectName(String name) throws MalformedObjectNameException, NullPointerException {
        ObjectName objectName = new ObjectName(name);
        if (this.mbeanServer.isRegistered(objectName)) {
            MBeanTest.fail((String)("Found the MBean!: " + objectName));
        } else {
            this.echo("Bean not registered Registered: " + objectName);
        }
        return objectName;
    }

    @Override
    protected void setUp() throws Exception {
        this.bindAddress = "tcp://localhost:0";
        this.useTopic = false;
        super.setUp();
        ManagementContext managementContext = this.broker.getManagementContext();
        this.mbeanServer = managementContext.getMBeanServer();
    }

    @Override
    protected void tearDown() throws Exception {
        if (waitForKeyPress) {
            System.out.println();
            System.out.println("Press enter to terminate the program.");
            System.out.println("In the meantime you can use your JMX console to view the current MBeans");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            reader.readLine();
        }
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        super.tearDown();
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString());
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setPersistent(false);
        answer.setDeleteAllMessagesOnStartup(true);
        answer.setUseJmx(true);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setMemoryLimit(0x400000L);
        policyMap.setDefaultEntry(defaultEntry);
        answer.setDestinationPolicy(policyMap);
        answer.setDestinations(new ActiveMQDestination[]{new ActiveMQQueue("QueueWithOptions?topQueue=true&hasOptions=2")});
        answer.addConnector(this.bindAddress);
        return answer;
    }

    protected void useConnection(Connection connection, int numToSend) throws Exception {
        connection.setClientID(this.clientID);
        connection.start();
        Session session = connection.createSession(this.transacted, this.authMode);
        this.destination = this.createDestination();
        MessageProducer producer = session.createProducer((Destination)this.destination);
        for (int i = 0; i < numToSend; ++i) {
            TextMessage message = session.createTextMessage("Message: " + i);
            message.setIntProperty("counter", i);
            message.setJMSCorrelationID("MyCorrelationID");
            message.setJMSReplyTo((Destination)new ActiveMQQueue("MyReplyTo"));
            message.setJMSType("MyType");
            message.setJMSPriority(5);
            producer.send((Message)message);
        }
        Thread.sleep(1000L);
    }

    protected void useConnection(Connection connection) throws Exception {
        this.useConnection(connection, 400);
    }

    protected void useConnectionWithBlobMessage(Connection connection) throws Exception {
        connection.setClientID(this.clientID);
        connection.start();
        ActiveMQSession session = (ActiveMQSession)connection.createSession(this.transacted, this.authMode);
        this.destination = this.createDestination();
        MessageProducer producer = session.createProducer((Destination)this.destination);
        for (int i = 0; i < 400; ++i) {
            BlobMessage message = session.createBlobMessage(new URL("http://foo.bar/test"));
            message.setIntProperty("counter", i);
            message.setJMSCorrelationID("MyCorrelationID");
            message.setJMSReplyTo((Destination)new ActiveMQQueue("MyReplyTo"));
            message.setJMSType("MyType");
            message.setJMSPriority(5);
            producer.send((Message)message);
        }
        Thread.sleep(1000L);
    }

    protected void useConnectionWithByteMessage(Connection connection) throws Exception {
        connection.setClientID(this.clientID);
        connection.start();
        ActiveMQSession session = (ActiveMQSession)connection.createSession(this.transacted, this.authMode);
        this.destination = this.createDestination();
        MessageProducer producer = session.createProducer((Destination)this.destination);
        for (int i = 0; i < 400; ++i) {
            BytesMessage message = session.createBytesMessage();
            message.writeBytes(("Message: " + i).getBytes());
            message.setIntProperty("counter", i);
            message.setJMSCorrelationID("MyCorrelationID");
            message.setJMSReplyTo((Destination)new ActiveMQQueue("MyReplyTo"));
            message.setJMSType("MyType");
            message.setJMSPriority(5);
            producer.send((Message)message);
        }
        Thread.sleep(1000L);
    }

    protected void echo(String text) {
    }

    protected String getSecondDestinationString() {
        return "test.new.destination." + ((Object)((Object)this)).getClass() + "." + this.getName();
    }

    public void testDynamicProducerView() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        ObjectName brokerName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost");
        BrokerViewMBean broker = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, brokerName, BrokerViewMBean.class, true);
        MBeanTest.assertEquals((int)0, (int)broker.getDynamicDestinationProducers().length);
        Session session = this.connection.createSession(false, 1);
        MessageProducer producer = session.createProducer(null);
        Topic dest1 = session.createTopic("DynamicDest-1");
        Topic dest2 = session.createTopic("DynamicDest-2");
        Queue dest3 = session.createQueue("DynamicDest-3");
        Thread.sleep(100L);
        MBeanTest.assertEquals((int)1, (int)broker.getDynamicDestinationProducers().length);
        ObjectName viewName = broker.getDynamicDestinationProducers()[0];
        MBeanTest.assertNotNull((Object)viewName);
        ProducerViewMBean view = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, viewName, ProducerViewMBean.class, true);
        MBeanTest.assertNotNull((Object)view);
        MBeanTest.assertEquals((String)"NOTSET", (String)view.getDestinationName());
        producer.send((Destination)dest1, (Message)session.createTextMessage("Test Message 1"));
        Thread.sleep(200L);
        MBeanTest.assertEquals((String)((ActiveMQDestination)dest1).getPhysicalName(), (String)view.getDestinationName());
        MBeanTest.assertTrue((boolean)view.isDestinationTopic());
        MBeanTest.assertFalse((boolean)view.isDestinationQueue());
        MBeanTest.assertFalse((boolean)view.isDestinationTemporary());
        producer.send((Destination)dest2, (Message)session.createTextMessage("Test Message 2"));
        Thread.sleep(200L);
        MBeanTest.assertEquals((String)((ActiveMQDestination)dest2).getPhysicalName(), (String)view.getDestinationName());
        MBeanTest.assertTrue((boolean)view.isDestinationTopic());
        MBeanTest.assertFalse((boolean)view.isDestinationQueue());
        MBeanTest.assertFalse((boolean)view.isDestinationTemporary());
        producer.send((Destination)dest3, (Message)session.createTextMessage("Test Message 3"));
        Thread.sleep(200L);
        MBeanTest.assertEquals((String)((ActiveMQDestination)dest3).getPhysicalName(), (String)view.getDestinationName());
        MBeanTest.assertTrue((boolean)view.isDestinationQueue());
        MBeanTest.assertFalse((boolean)view.isDestinationTopic());
        MBeanTest.assertFalse((boolean)view.isDestinationTemporary());
        producer.close();
        Thread.sleep(200L);
        MBeanTest.assertEquals((int)0, (int)broker.getDynamicDestinationProducers().length);
    }

    public void testTempQueueJMXDelete() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.connection.setClientID(this.clientID);
        this.connection.start();
        Session session = this.connection.createSession(this.transacted, this.authMode);
        ActiveMQTempQueue tQueue = (ActiveMQTempQueue)session.createTemporaryQueue();
        Thread.sleep(1000L);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=" + JMXSupport.encodeObjectNamePart((String)tQueue.getDestinationTypeAsString()) + ",destinationName=" + JMXSupport.encodeObjectNamePart((String)tQueue.getPhysicalName()));
        this.mbeanServer.getObjectInstance(queueViewMBeanName);
        tQueue.delete();
        Thread.sleep(1000L);
        try {
            this.mbeanServer.getObjectInstance(queueViewMBeanName);
            MBeanTest.fail((String)"should be deleted already!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testBrowseBlobMessages() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.useConnectionWithBlobMessage(this.connection);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + this.getDestinationString());
        QueueViewMBean queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        CompositeData[] compdatalist = queue.browse();
        int initialQueueSize = compdatalist.length;
        if (initialQueueSize == 0) {
            MBeanTest.fail((String)"There is no message in the queue:");
        } else {
            this.echo("Current queue size: " + initialQueueSize);
        }
        int messageCount = initialQueueSize;
        String[] messageIDs = new String[messageCount];
        for (int i = 0; i < messageCount; ++i) {
            CompositeData cdata = compdatalist[i];
            String messageID = (String)cdata.get("JMSMessageID");
            MBeanTest.assertNotNull((String)("Should have a message ID for message " + i), (Object)messageID);
            messageIDs[i] = messageID;
        }
        MBeanTest.assertTrue((String)"dest has some memory usage", (queue.getMemoryPercentUsage() > 0 ? 1 : 0) != 0);
    }

    public void testDestinationOptionsAreVisible() throws Exception {
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + QUEUE_WITH_OPTIONS);
        QueueViewMBean queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        MBeanTest.assertEquals((String)"name match", (String)QUEUE_WITH_OPTIONS, (String)queue.getName());
        String options = queue.getOptions();
        LOG.info("Got options: " + options);
        Map optionsMap = URISupport.parseQuery((String)options);
        MBeanTest.assertEquals((String)"got a map", (int)2, (int)optionsMap.size());
        MBeanTest.assertTrue((String)"matches our options", (boolean)optionsMap.containsKey("hasOptions"));
        MBeanTest.assertTrue((String)"matches our options", (boolean)optionsMap.containsKey("topQueue"));
        MBeanTest.assertTrue((String)"matches our options", (boolean)optionsMap.containsValue("true"));
        MBeanTest.assertTrue((String)"matches our options", (boolean)optionsMap.containsValue("2"));
    }

    public void testSubscriptionViewToConnectionMBean() throws Exception {
        this.connection = this.connectionFactory.createConnection("admin", "admin");
        this.connection.setClientID("MBeanTest");
        Session session = this.connection.createSession(false, 1);
        Queue queue = session.createQueue(this.getDestinationString() + ".Queue");
        MessageConsumer queueConsumer = session.createConsumer((Destination)queue);
        MessageProducer producer = session.createProducer((Destination)queue);
        ObjectName brokerName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost");
        BrokerViewMBean broker = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, brokerName, BrokerViewMBean.class, true);
        Thread.sleep(100L);
        MBeanTest.assertTrue((broker.getQueueSubscribers().length == 1 ? 1 : 0) != 0);
        ObjectName subscriptionName = broker.getQueueSubscribers()[0];
        LOG.info("Looking for Subscription: " + subscriptionName);
        SubscriptionViewMBean subscriberView = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, subscriptionName, SubscriptionViewMBean.class, true);
        MBeanTest.assertNotNull((Object)subscriberView);
        ObjectName connectionName = subscriberView.getConnection();
        LOG.info("Looking for Connection: " + connectionName);
        MBeanTest.assertNotNull((Object)connectionName);
        ConnectionViewMBean connectionView = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, connectionName, ConnectionViewMBean.class, true);
        MBeanTest.assertNotNull((Object)connectionView);
        MBeanTest.assertEquals((int)2, (int)connectionView.getConsumers().length);
        MBeanTest.assertEquals((String)"client id match", (String)"MBeanTest", (String)connectionView.getClientId());
        boolean found = false;
        for (ObjectName name : connectionView.getConsumers()) {
            if (!name.equals(subscriptionName)) continue;
            found = true;
        }
        MBeanTest.assertTrue((String)("We should have found: " + subscriptionName), (boolean)found);
        MBeanTest.assertEquals((int)1, (int)connectionView.getProducers().length);
        queueConsumer.close();
        producer.close();
        Thread.sleep(200L);
        MBeanTest.assertEquals((int)1, (int)connectionView.getConsumers().length);
        MBeanTest.assertEquals((int)0, (int)connectionView.getProducers().length);
    }

    public void testCreateAndUnsubscribeDurableSubscriptions() throws Exception {
        this.connection = this.connectionFactory.createConnection("admin", "admin");
        this.connection.setClientID("MBeanTest");
        Session session = this.connection.createSession(false, 1);
        String topicName = this.getDestinationString() + ".DurableTopic";
        Topic topic = session.createTopic(topicName);
        ObjectName brokerName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost");
        this.echo("Create QueueView MBean...");
        BrokerViewMBean broker = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, brokerName, BrokerViewMBean.class, true);
        MBeanTest.assertEquals((String)"Durable subscriber count", (int)0, (int)broker.getDurableTopicSubscribers().length);
        MBeanTest.assertEquals((String)"Durable subscriber count", (int)0, (int)broker.getInactiveDurableTopicSubscribers().length);
        TopicSubscriber durableConsumer1 = session.createDurableSubscriber(topic, "subscription1");
        TopicSubscriber durableConsumer2 = session.createDurableSubscriber(topic, "subscription2");
        Thread.sleep(100L);
        MBeanTest.assertEquals((String)"Durable subscriber count", (int)2, (int)broker.getDurableTopicSubscribers().length);
        MBeanTest.assertEquals((String)"Durable subscriber count", (int)0, (int)broker.getInactiveDurableTopicSubscribers().length);
        durableConsumer1.close();
        durableConsumer2.close();
        Thread.sleep(100L);
        MBeanTest.assertEquals((String)"Durable subscriber count", (int)0, (int)broker.getDurableTopicSubscribers().length);
        MBeanTest.assertEquals((String)"Durable subscriber count", (int)2, (int)broker.getInactiveDurableTopicSubscribers().length);
        session.unsubscribe("subscription1");
        Thread.sleep(100L);
        MBeanTest.assertEquals((String)"Inactive Durable subscriber count", (int)1, (int)broker.getInactiveDurableTopicSubscribers().length);
        session.unsubscribe("subscription2");
        MBeanTest.assertEquals((String)"Inactive Durable subscriber count", (int)0, (int)broker.getInactiveDurableTopicSubscribers().length);
    }

    public void testUserNamePopulated() throws Exception {
        this.doTestUserNameInMBeans(true);
    }

    public void testUserNameNotPopulated() throws Exception {
        this.doTestUserNameInMBeans(false);
    }

    private void doTestUserNameInMBeans(boolean expect) throws Exception {
        SubscriptionViewMBean subscriberView;
        this.broker.setPopulateUserNameInMBeans(expect);
        this.connection = this.connectionFactory.createConnection("admin", "admin");
        this.connection.setClientID("MBeanTest");
        Session session = this.connection.createSession(false, 1);
        Queue queue = session.createQueue(this.getDestinationString() + ".Queue");
        Topic topic = session.createTopic(this.getDestinationString() + ".Topic");
        MessageProducer producer = session.createProducer((Destination)queue);
        MessageConsumer queueConsumer = session.createConsumer((Destination)queue);
        MessageConsumer topicConsumer = session.createConsumer((Destination)topic);
        TopicSubscriber durable = session.createDurableSubscriber(topic, "Durable");
        ObjectName brokerName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost");
        BrokerViewMBean broker = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, brokerName, BrokerViewMBean.class, true);
        Thread.sleep(100L);
        MBeanTest.assertTrue((broker.getQueueProducers().length == 1 ? 1 : 0) != 0);
        MBeanTest.assertTrue((broker.getTopicSubscribers().length == 2 ? 1 : 0) != 0);
        MBeanTest.assertTrue((broker.getQueueSubscribers().length == 1 ? 1 : 0) != 0);
        ObjectName producerName = broker.getQueueProducers()[0];
        ProducerViewMBean producerView = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, producerName, ProducerViewMBean.class, true);
        MBeanTest.assertNotNull((Object)producerView);
        if (expect) {
            MBeanTest.assertEquals((String)"admin", (String)producerView.getUserName());
        } else {
            MBeanTest.assertNull((Object)producerView.getUserName());
        }
        for (ObjectName name : broker.getTopicSubscribers()) {
            subscriberView = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, name, SubscriptionViewMBean.class, true);
            if (expect) {
                MBeanTest.assertEquals((String)"admin", (String)subscriberView.getUserName());
                continue;
            }
            MBeanTest.assertNull((Object)subscriberView.getUserName());
        }
        for (ObjectName name : broker.getQueueSubscribers()) {
            subscriberView = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, name, SubscriptionViewMBean.class, true);
            if (expect) {
                MBeanTest.assertEquals((String)"admin", (String)subscriberView.getUserName());
                continue;
            }
            MBeanTest.assertNull((Object)subscriberView.getUserName());
        }
        ObjectName query = BrokerMBeanSupport.createConnectionQuery((String)this.domain, (String)"localhost", (String)this.connection.getClientID());
        Set<ObjectName> names = this.mbeanServer.queryNames(query, null);
        boolean found = false;
        for (ObjectName name : names) {
            if (!name.toString().endsWith("connectionName=MBeanTest")) continue;
            ConnectionViewMBean connectionView = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, name, ConnectionViewMBean.class, true);
            MBeanTest.assertNotNull((Object)connectionView);
            if (expect) {
                MBeanTest.assertEquals((String)"admin", (String)connectionView.getUserName());
            } else {
                MBeanTest.assertNull((Object)connectionView.getUserName());
            }
            found = true;
            break;
        }
        MBeanTest.assertTrue((String)"Should find the connection's ManagedTransportConnection", (boolean)found);
    }

    public void testMoveMessagesToRetainOrder() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.useConnection(this.connection);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + this.getDestinationString());
        QueueViewMBean queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        String newDestination = this.getSecondDestinationString();
        queue.moveMatchingMessagesTo("", newDestination);
        queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + newDestination);
        queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        int movedSize = 400;
        MBeanTest.assertEquals((String)"Unexpected number of messages ", (long)movedSize, (long)queue.getQueueSize());
        Session session = this.connection.createSession(false, 1);
        Queue destination = session.createQueue(newDestination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        int last = -1;
        int current = -1;
        Message message = null;
        while ((message = consumer.receive(2000L)) != null) {
            if (!message.propertyExists("counter")) continue;
            current = message.getIntProperty("counter");
            MBeanTest.assertEquals((int)last, (int)(current - 1));
            last = current;
        }
        queue.removeMatchingMessages("");
        MBeanTest.assertEquals((String)("Should have no more messages in the queue: " + queueViewMBeanName), (long)0L, (long)queue.getQueueSize());
        MBeanTest.assertEquals((String)"dest has no memory usage", (int)0, (int)queue.getMemoryPercentUsage());
    }

    public void testConnectionCounts() throws Exception {
        ObjectName brokerName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost");
        BrokerViewMBean broker = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, brokerName, BrokerViewMBean.class, true);
        MBeanTest.assertEquals((int)0, (int)broker.getCurrentConnectionsCount());
        this.connection = this.connectionFactory.createConnection();
        this.useConnection(this.connection);
        MBeanTest.assertEquals((int)1, (int)broker.getCurrentConnectionsCount());
        this.connection.close();
        MBeanTest.assertEquals((int)0, (int)broker.getCurrentConnectionsCount());
        MBeanTest.assertEquals((long)1L, (long)broker.getTotalConnectionsCount());
    }

    public void testCopyMessagesToRetainOrder() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.useConnection(this.connection);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + this.getDestinationString());
        QueueViewMBean queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        String newDestination = this.getSecondDestinationString();
        queue.copyMatchingMessagesTo("", newDestination);
        queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + newDestination);
        queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        int movedSize = 400;
        MBeanTest.assertEquals((String)"Unexpected number of messages ", (long)movedSize, (long)queue.getQueueSize());
        Session session = this.connection.createSession(false, 1);
        Queue destination = session.createQueue(newDestination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        int last = -1;
        int current = -1;
        Message message = null;
        while ((message = consumer.receive(2000L)) != null) {
            if (!message.propertyExists("counter")) continue;
            current = message.getIntProperty("counter");
            MBeanTest.assertEquals((int)last, (int)(current - 1));
            last = current;
        }
        queue.removeMatchingMessages("");
        MBeanTest.assertEquals((String)("Should have no more messages in the queue: " + queueViewMBeanName), (long)0L, (long)queue.getQueueSize());
        MBeanTest.assertEquals((String)"dest has no memory usage", (int)0, (int)queue.getMemoryPercentUsage());
    }

    public void testRemoveMatchingMessageRetainOrder() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.useConnection(this.connection);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + this.getDestinationString());
        QueueViewMBean queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        String queueName = this.getDestinationString();
        queue.removeMatchingMessages("counter < 10");
        int newSize = 390;
        MBeanTest.assertEquals((String)"Unexpected number of messages ", (long)newSize, (long)queue.getQueueSize());
        Session session = this.connection.createSession(false, 1);
        Queue destination = session.createQueue(queueName);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        int last = 9;
        int current = 0;
        Message message = null;
        while ((message = consumer.receive(2000L)) != null) {
            if (!message.propertyExists("counter")) continue;
            current = message.getIntProperty("counter");
            MBeanTest.assertEquals((int)last, (int)(current - 1));
            last = current;
        }
        queue.removeMatchingMessages("");
        MBeanTest.assertEquals((String)("Should have no more messages in the queue: " + queueViewMBeanName), (long)0L, (long)queue.getQueueSize());
        MBeanTest.assertEquals((String)"dest has no memory usage", (int)0, (int)queue.getMemoryPercentUsage());
    }

    public void testBrowseBytesMessages() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.useConnectionWithByteMessage(this.connection);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + this.getDestinationString());
        QueueViewMBean queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        CompositeData[] compdatalist = queue.browse();
        int initialQueueSize = compdatalist.length;
        if (initialQueueSize == 0) {
            MBeanTest.fail((String)"There is no message in the queue:");
        } else {
            this.echo("Current queue size: " + initialQueueSize);
        }
        int messageCount = initialQueueSize;
        String[] messageIDs = new String[messageCount];
        for (int i = 0; i < messageCount; ++i) {
            CompositeData cdata = compdatalist[i];
            String messageID = (String)cdata.get("JMSMessageID");
            MBeanTest.assertNotNull((String)("Should have a message ID for message " + i), (Object)messageID);
            messageIDs[i] = messageID;
            Byte[] preview = (Byte[])cdata.get("BodyPreview");
            MBeanTest.assertNotNull((String)"should be a preview", (Object)preview);
            MBeanTest.assertTrue((String)"not empty", (preview.length > 0 ? 1 : 0) != 0);
        }
        MBeanTest.assertTrue((String)"dest has some memory usage", (queue.getMemoryPercentUsage() > 0 ? 1 : 0) != 0);
        this.echo("Attempting to consume all bytes messages from: " + this.destination);
        Session session = this.connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        for (int i = 0; i < 400; ++i) {
            Message message = consumer.receive(5000L);
            MBeanTest.assertNotNull((Object)message);
            MBeanTest.assertTrue((boolean)(message instanceof BytesMessage));
        }
        consumer.close();
        session.close();
    }

    public void testBrowseOrder() throws Exception {
        int i;
        this.connection = this.connectionFactory.createConnection();
        ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
        prefetchPolicy.setAll(20);
        ((ActiveMQConnection)this.connection).setPrefetchPolicy(prefetchPolicy);
        this.useConnection(this.connection);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + this.getDestinationString());
        QueueViewMBean queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        CompositeData[] compdatalist = queue.browse();
        int initialQueueSize = compdatalist.length;
        MBeanTest.assertEquals((String)"expected", (int)400, (int)initialQueueSize);
        int messageCount = initialQueueSize;
        for (int i2 = 0; i2 < messageCount; ++i2) {
            CompositeData cdata = compdatalist[i2];
            String messageID = (String)cdata.get("JMSMessageID");
            MBeanTest.assertNotNull((String)("Should have a message ID for message " + i2), (Object)messageID);
            Map intProperties = CompositeDataHelper.getTabularMap((CompositeData)cdata, (String)"IntProperties");
            MBeanTest.assertTrue((String)"not empty", (intProperties.size() > 0 ? 1 : 0) != 0);
            MBeanTest.assertEquals((String)"counter in order", (Object)i2, intProperties.get("counter"));
        }
        this.echo("Attempting to consume 5 bytes messages from: " + this.destination);
        Session session = this.connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        for (i = 0; i < 5; ++i) {
            Message message = consumer.receive(5000L);
            MBeanTest.assertNotNull((Object)message);
            MBeanTest.assertEquals((String)"ordered", (int)i, (int)message.getIntProperty("counter"));
            this.echo("Consumed: " + message.getIntProperty("counter"));
        }
        consumer.close();
        session.close();
        this.connection.close();
        compdatalist = queue.browse();
        initialQueueSize = compdatalist.length;
        MBeanTest.assertEquals((String)"5 gone", (int)395, (int)initialQueueSize);
        messageCount = initialQueueSize;
        for (i = 0; i < messageCount - 4; ++i) {
            CompositeData cdata = compdatalist[i];
            Map intProperties = CompositeDataHelper.getTabularMap((CompositeData)cdata, (String)"IntProperties");
            MBeanTest.assertTrue((String)"not empty", (intProperties.size() > 0 ? 1 : 0) != 0);
            MBeanTest.assertEquals((String)"counter in order", (Object)(i + 5), intProperties.get("counter"));
            this.echo("Got: " + intProperties.get("counter"));
        }
    }

    public void testAddRemoveConnectorBrokerView() throws Exception {
        ObjectName brokerName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost");
        BrokerViewMBean brokerView = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, brokerName, BrokerViewMBean.class, true);
        Map connectors = brokerView.getTransportConnectors();
        LOG.info("Connectors: " + connectors);
        MBeanTest.assertEquals((String)"one connector", (int)1, (int)connectors.size());
        ConnectorViewMBean connector = this.getProxyToConnectionView("tcp");
        MBeanTest.assertNotNull((Object)connector);
        String name = connectors.keySet().iterator().next().toString();
        brokerView.removeConnector(name);
        connectors = brokerView.getTransportConnectors();
        MBeanTest.assertEquals((String)"empty", (int)0, (int)connectors.size());
        name = brokerView.addConnector("tcp://0.0.0.0:0");
        connector = this.getProxyToConnectionView("tcp");
        MBeanTest.assertNotNull((Object)connector);
        connectors = brokerView.getTransportConnectors();
        LOG.info("Connectors: " + connectors);
        MBeanTest.assertEquals((String)"one connector", (int)1, (int)connectors.size());
        MBeanTest.assertTrue((String)("name is in map: " + connectors.keySet()), (boolean)connectors.keySet().contains(name));
    }

    public void testConnectorView() throws Exception {
        ConnectorViewMBean connector = this.getProxyToConnectionView("tcp");
        MBeanTest.assertNotNull((Object)connector);
        MBeanTest.assertFalse((boolean)connector.isRebalanceClusterClients());
        MBeanTest.assertFalse((boolean)connector.isUpdateClusterClientsOnRemove());
        MBeanTest.assertFalse((boolean)connector.isUpdateClusterClients());
        MBeanTest.assertFalse((boolean)connector.isAllowLinkStealingEnabled());
    }

    protected ConnectorViewMBean getProxyToConnectionView(String connectionType) throws Exception {
        ObjectName connectorQuery = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost,connector=clientConnectors,connectorName=" + connectionType + "_//*");
        Set results = this.broker.getManagementContext().queryNames(connectorQuery, null);
        if (results == null || results.isEmpty() || results.size() > 1) {
            throw new Exception("Unable to find the exact Connector instance.");
        }
        ConnectorViewMBean proxy = (ConnectorViewMBean)this.broker.getManagementContext().newProxyInstance((ObjectName)results.iterator().next(), ConnectorViewMBean.class, true);
        return proxy;
    }

    public void testDynamicProducers() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        Session session = this.connection.createSession(false, 1);
        MessageProducer producer = session.createProducer(null);
        ObjectName query = new ObjectName(this.domain + ":type=Broker,brokerName=localhost,endpoint=dynamicProducer,*");
        Set<ObjectInstance> mbeans = this.mbeanServer.queryMBeans(query, null);
        MBeanTest.assertEquals((int)mbeans.size(), (int)1);
        producer.close();
    }

    public void testDurableSubQuery() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.connection.setClientID("test");
        Session session = this.connection.createSession(false, 1);
        TopicSubscriber sub = session.createDurableSubscriber(session.createTopic("test.topic"), "test.consumer");
        ObjectName query = new ObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Topic,destinationName=test.topic,endpoint=Consumer,consumerId=Durable(*),*");
        Set<ObjectInstance> mbeans = this.mbeanServer.queryMBeans(query, null);
        MBeanTest.assertEquals((int)mbeans.size(), (int)1);
        sub.close();
    }

    public void testQueuePauseResume() throws Exception {
        int i;
        this.connection = this.connectionFactory.createConnection();
        int numToSend = 20;
        int numToConsume = 5;
        this.useConnection(this.connection, 20);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + this.getDestinationString());
        final QueueViewMBean queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        CompositeData[] compdatalist = queue.browse();
        int initialQueueSize = compdatalist.length;
        MBeanTest.assertEquals((String)"expected", (int)20, (int)initialQueueSize);
        this.echo("Attempting to consume 5 bytes messages from: " + this.destination);
        Session session = this.connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        for (i = 0; i < 5; ++i) {
            MBeanTest.assertNotNull((String)("Message: " + i), (Object)consumer.receive(5000L));
        }
        consumer.close();
        session.close();
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return 15 == queue.browse().length;
            }
        });
        compdatalist = queue.browse();
        MBeanTest.assertEquals((String)"expected", (int)15, (int)compdatalist.length);
        this.echo("pause");
        queue.pause();
        MBeanTest.assertTrue((String)"queue is paused", (boolean)queue.isPaused());
        session = this.connection.createSession(false, 1);
        consumer = session.createConsumer((Destination)this.destination);
        MBeanTest.assertNull((String)"cannot get message while paused", (Object)consumer.receive(2000L));
        consumer.close();
        session.close();
        this.connection.close();
        this.connection = this.connectionFactory.createConnection();
        this.useConnection(this.connection, 20);
        compdatalist = queue.browse();
        MBeanTest.assertEquals((String)"expected browse", (int)35, (int)compdatalist.length);
        MBeanTest.assertEquals((String)"expected message count", (long)compdatalist.length, (long)queue.getQueueSize());
        this.echo("resume");
        queue.resume();
        MBeanTest.assertFalse((String)"queue is not paused", (boolean)queue.isPaused());
        session = this.connection.createSession(false, 1);
        consumer = session.createConsumer((Destination)this.destination);
        for (i = 0; i < compdatalist.length; ++i) {
            MBeanTest.assertNotNull((String)("Message: " + i), (Object)consumer.receive(5000L));
        }
    }

    public void testTopicView() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.connection.setClientID("test");
        Session session = this.connection.createSession(false, 2);
        this.connection.start();
        Topic singleTopic = session.createTopic("test.topic");
        Topic wildcardTopic = session.createTopic("test.>");
        TopicSubscriber durable1 = session.createDurableSubscriber(singleTopic, "single");
        TopicSubscriber durable2 = session.createDurableSubscriber(wildcardTopic, "wildcard");
        MessageConsumer consumer1 = session.createConsumer((Destination)singleTopic);
        MessageConsumer consumer2 = session.createConsumer((Destination)wildcardTopic);
        final ArrayList messages = new ArrayList();
        MessageListener listener = new MessageListener(){

            public void onMessage(Message message) {
                messages.add(message);
            }
        };
        durable1.setMessageListener(listener);
        durable2.setMessageListener(listener);
        consumer1.setMessageListener(listener);
        consumer2.setMessageListener(listener);
        MessageProducer producer = session.createProducer((Destination)singleTopic);
        producer.send((Message)session.createTextMessage("test"));
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return messages.size() == 4;
            }
        });
        ObjectName topicObjName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Topic,destinationName=test.topic");
        final TopicViewMBean topicView = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, topicObjName, TopicViewMBean.class, true);
        MBeanTest.assertEquals((long)1L, (long)topicView.getEnqueueCount());
        MBeanTest.assertEquals((long)4L, (long)topicView.getDispatchCount());
        MBeanTest.assertEquals((long)4L, (long)topicView.getInFlightCount());
        MBeanTest.assertEquals((long)0L, (long)topicView.getDequeueCount());
        ArrayList<SubscriptionViewMBean> subscriberViews = new ArrayList<SubscriptionViewMBean>();
        for (ObjectName name : topicView.getSubscriptions()) {
            subscriberViews.add(MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, name, SubscriptionViewMBean.class, true));
        }
        MBeanTest.assertEquals((int)4, (int)subscriberViews.size());
        for (SubscriptionViewMBean subscriberView : subscriberViews) {
            MBeanTest.assertEquals((long)1L, (long)subscriberView.getEnqueueCounter());
            MBeanTest.assertEquals((long)1L, (long)subscriberView.getDispatchedCounter());
            MBeanTest.assertEquals((long)0L, (long)subscriberView.getDequeueCounter());
        }
        for (Message message : messages) {
            try {
                message.acknowledge();
            }
            catch (JMSException jMSException) {}
        }
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return topicView.getDequeueCount() == 4L;
            }
        });
        MBeanTest.assertEquals((long)1L, (long)topicView.getEnqueueCount());
        MBeanTest.assertEquals((long)4L, (long)topicView.getDispatchCount());
        MBeanTest.assertEquals((long)0L, (long)topicView.getInFlightCount());
        MBeanTest.assertEquals((long)4L, (long)topicView.getDequeueCount());
        for (SubscriptionViewMBean subscriberView : subscriberViews) {
            MBeanTest.assertEquals((long)1L, (long)subscriberView.getEnqueueCounter());
            MBeanTest.assertEquals((long)1L, (long)subscriberView.getDispatchedCounter());
            MBeanTest.assertEquals((long)1L, (long)subscriberView.getDequeueCounter());
        }
    }
}

