/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.policy.DeadLetterTest;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.IndividualDeadLetterStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndividualDeadLetterTest
extends DeadLetterTest {
    private static final Logger LOG = LoggerFactory.getLogger(IndividualDeadLetterTest.class);

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        PolicyEntry policy = new PolicyEntry();
        IndividualDeadLetterStrategy strategy = new IndividualDeadLetterStrategy();
        strategy.setProcessNonPersistent(true);
        policy.setDeadLetterStrategy((DeadLetterStrategy)strategy);
        PolicyMap pMap = new PolicyMap();
        pMap.put((ActiveMQDestination)new ActiveMQQueue(this.getDestinationString()), (Object)policy);
        pMap.put((ActiveMQDestination)new ActiveMQTopic(this.getDestinationString()), (Object)policy);
        broker.setDestinationPolicy(pMap);
        return broker;
    }

    @Override
    protected Destination createDlqDestination() {
        String prefix = this.topic ? "ActiveMQ.DLQ.Topic." : "ActiveMQ.DLQ.Queue.";
        return new ActiveMQQueue(prefix + ((Object)((Object)this)).getClass().getName() + "." + this.getName());
    }

    public void testDLQBrowsing() throws Exception {
        this.topic = false;
        this.deliveryMode = 2;
        this.durableSubscriber = false;
        this.messageCount = 1;
        this.connection.start();
        ActiveMQConnection amqConnection = (ActiveMQConnection)this.connection;
        this.rollbackCount = amqConnection.getRedeliveryPolicy().getMaximumRedeliveries() + 1;
        LOG.info("Will redeliver messages: " + this.rollbackCount + " times");
        this.sendMessages();
        for (int i = 0; i < this.rollbackCount; ++i) {
            this.makeConsumer();
            Message message = this.consumer.receive(5000L);
            IndividualDeadLetterTest.assertNotNull((String)"No message received: ", (Object)message);
            this.session.rollback();
            LOG.info("Rolled back: " + this.rollbackCount + " times");
            this.consumer.close();
        }
        this.makeDlqBrowser();
        this.browseDlq();
        this.dlqBrowser.close();
        this.session.close();
        Thread.sleep(1000L);
        this.session = this.connection.createSession(this.transactedMode, this.acknowledgeMode);
        ActiveMQQueue testQueue = new ActiveMQQueue("ActiveMQ.DLQ.Queue.ActiveMQ.DLQ.Queue." + ((Object)((Object)this)).getClass().getName() + "." + this.getName());
        MessageConsumer testConsumer = this.session.createConsumer((Destination)testQueue);
        IndividualDeadLetterTest.assertNull((String)"The message shouldn't be sent to another DLQ", (Object)testConsumer.receive(1000L));
    }

    protected void browseDlq() throws Exception {
        Enumeration messages = this.dlqBrowser.getEnumeration();
        while (messages.hasMoreElements()) {
            LOG.info("Browsing: " + messages.nextElement());
        }
    }
}

