/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usage;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.ProducerThread;
import org.apache.activemq.util.Wait;

public class StoreUsageTest
extends EmbeddedBrokerTestSupport {
    final int WAIT_TIME_MILLS = 20000;

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        broker.getSystemUsage().getStoreUsage().setLimit(10240L);
        broker.deleteAllMessages();
        return broker;
    }

    @Override
    protected boolean isPersistent() {
        return true;
    }

    public void testJmx() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        Connection conn = factory.createConnection();
        conn.start();
        Session sess = conn.createSession(false, 1);
        Queue dest = sess.createQueue(((Object)((Object)this)).getClass().getName());
        final ProducerThread producer = new ProducerThread(sess, (Destination)dest);
        producer.start();
        Thread.sleep(10000L);
        this.broker.getAdminView().setStoreLimit(0x100000L);
        Thread.sleep(20000L);
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return producer.getSentCount() == producer.getMessageCount();
            }
        }, (long)40000L);
        StoreUsageTest.assertEquals((String)"Producer didn't send all messages", (int)producer.getMessageCount(), (int)producer.getSentCount());
    }
}

