/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.policy.DeadLetterTestSupport;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;

public class NoConsumerDeadLetterTest
extends DeadLetterTestSupport {
    @Override
    public void testDurableQueueMessage() throws Exception {
    }

    @Override
    public void testDurableTopicMessage() throws Exception {
    }

    @Override
    protected void doTest() throws Exception {
        this.makeDlqConsumer();
        this.sendMessages();
        for (int i = 0; i < this.messageCount; ++i) {
            Message msg = this.dlqConsumer.receive(1000L);
            NoConsumerDeadLetterTest.assertNotNull((String)("Should be a message for loop: " + i), (Object)msg);
        }
    }

    public void testConsumerReceivesMessages() throws Exception {
        this.topic = false;
        ActiveMQConnectionFactory factory = this.createConnectionFactory();
        this.connection = (ActiveMQConnection)factory.createConnection();
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        MessageProducer producer = session.createProducer(this.getDestination());
        producer.setDeliveryMode(1);
        ActiveMQTopic advisoryTopic = AdvisorySupport.getNoQueueConsumersAdvisoryTopic((Destination)this.getDestination());
        MessageConsumer advisoryConsumer = session.createConsumer((Destination)advisoryTopic);
        TextMessage msg = session.createTextMessage("Message: x");
        producer.send((Message)msg);
        Message advisoryMessage = advisoryConsumer.receive(1000L);
        NoConsumerDeadLetterTest.assertNotNull((String)"Advisory message not received", (Object)advisoryMessage);
        Thread.sleep(1000L);
        factory = this.createConnectionFactory();
        this.connection = (ActiveMQConnection)factory.createConnection();
        this.connection.start();
        session = this.connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer(this.getDestination());
        Message received = consumer.receive(1000L);
        NoConsumerDeadLetterTest.assertNotNull((String)"Message not received", (Object)received);
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        PolicyEntry policy = new PolicyEntry();
        policy.setSendAdvisoryIfNoConsumers(true);
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        broker.setDestinationPolicy(pMap);
        return broker;
    }

    @Override
    protected Destination createDlqDestination() {
        if (this.topic) {
            return AdvisorySupport.getNoTopicConsumersAdvisoryTopic((ActiveMQDestination)((ActiveMQDestination)this.getDestination()));
        }
        return AdvisorySupport.getNoQueueConsumersAdvisoryTopic((ActiveMQDestination)((ActiveMQDestination)this.getDestination()));
    }
}

