/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import javax.jms.Destination;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.policy.DeadLetterTest;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.IndividualDeadLetterStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQQueue;

public class PerDurableConsumerDeadLetterTest
extends DeadLetterTest {
    private static final String CLIENT_ID = "george";

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        PolicyEntry policy = new PolicyEntry();
        IndividualDeadLetterStrategy strategy = new IndividualDeadLetterStrategy();
        strategy.setProcessNonPersistent(true);
        strategy.setDestinationPerDurableSubscriber(true);
        policy.setDeadLetterStrategy((DeadLetterStrategy)strategy);
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        broker.setDestinationPolicy(pMap);
        return broker;
    }

    @Override
    protected String createClientId() {
        return CLIENT_ID;
    }

    @Override
    protected Destination createDlqDestination() {
        String prefix = this.topic ? "ActiveMQ.DLQ.Topic." : "ActiveMQ.DLQ.Queue.";
        String destinationName = prefix + ((Object)((Object)this)).getClass().getName() + "." + this.getName();
        if (this.durableSubscriber) {
            String subName = "george:" + this.getDestination().toString();
            destinationName = destinationName + "." + subName;
        }
        return new ActiveMQQueue(destinationName);
    }
}

