/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import java.io.File;
import java.io.IOException;
import java.security.ProtectionDomain;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.scheduler.JobScheduler;
import org.apache.activemq.broker.scheduler.JobSchedulerStore;
import org.apache.activemq.broker.scheduler.SchedulerDBVersionTest;
import org.apache.activemq.store.kahadb.scheduler.JobSchedulerStoreImpl;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KahaDBSchedulerIndexRebuildTest {
    static final Logger LOG = LoggerFactory.getLogger(KahaDBSchedulerIndexRebuildTest.class);
    private BrokerService broker = null;
    private final int NUM_JOBS = 50;
    static String basedir;
    private final File schedulerStoreDir = new File(basedir, "activemq-data/store/scheduler");
    private final File storeDir = new File(basedir, "activemq-data/store/");

    @Before
    public void setUp() throws Exception {
        LOG.info("Test Dir = {}", (Object)this.schedulerStoreDir);
    }

    @After
    public void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    @Test
    public void testIndexRebuilds() throws Exception {
        IOHelper.deleteFile((File)this.schedulerStoreDir);
        JobSchedulerStoreImpl schedulerStore = this.createScheduler();
        this.broker = this.createBroker(schedulerStore);
        this.broker.start();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost");
        Connection connection = cf.createConnection();
        connection.start();
        for (int i = 0; i < 50; ++i) {
            this.scheduleRepeating(connection);
        }
        connection.close();
        JobScheduler scheduler = schedulerStore.getJobScheduler("JMS");
        Assert.assertNotNull((Object)scheduler);
        Assert.assertEquals((long)50L, (long)scheduler.getAllJobs().size());
        this.broker.stop();
        IOHelper.delete((File)new File(this.schedulerStoreDir, "scheduleDB.data"));
        schedulerStore = this.createScheduler();
        this.broker = this.createBroker(schedulerStore);
        this.broker.start();
        scheduler = schedulerStore.getJobScheduler("JMS");
        Assert.assertNotNull((Object)scheduler);
        Assert.assertEquals((long)50L, (long)scheduler.getAllJobs().size());
    }

    @Test
    public void testIndexRebuildsAfterSomeJobsExpire() throws Exception {
        IOHelper.deleteFile((File)this.schedulerStoreDir);
        JobSchedulerStoreImpl schedulerStore = this.createScheduler();
        this.broker = this.createBroker(schedulerStore);
        this.broker.start();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost");
        Connection connection = cf.createConnection();
        connection.start();
        for (int i = 0; i < 50; ++i) {
            this.scheduleRepeating(connection);
            this.scheduleOneShot(connection);
        }
        connection.close();
        JobScheduler scheduler = schedulerStore.getJobScheduler("JMS");
        Assert.assertNotNull((Object)scheduler);
        Assert.assertEquals((long)100L, (long)scheduler.getAllJobs().size());
        final JobScheduler awaitingOneShotTimeout = scheduler;
        Assert.assertTrue((String)"One shot jobs should time out", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return awaitingOneShotTimeout.getAllJobs().size() == 50;
            }
        }, (long)TimeUnit.MINUTES.toMillis(2L)));
        this.broker.stop();
        IOHelper.delete((File)new File(this.schedulerStoreDir, "scheduleDB.data"));
        schedulerStore = this.createScheduler();
        this.broker = this.createBroker(schedulerStore);
        this.broker.start();
        scheduler = schedulerStore.getJobScheduler("JMS");
        Assert.assertNotNull((Object)scheduler);
        Assert.assertEquals((long)50L, (long)scheduler.getAllJobs().size());
    }

    private void scheduleRepeating(Connection connection) throws Exception {
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue("test.queue");
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage message = session.createTextMessage("test msg");
        long time = 360000L;
        message.setLongProperty("AMQ_SCHEDULED_DELAY", time);
        message.setLongProperty("AMQ_SCHEDULED_PERIOD", 500L);
        message.setIntProperty("AMQ_SCHEDULED_REPEAT", -1);
        producer.send((Message)message);
        producer.close();
    }

    private void scheduleOneShot(Connection connection) throws Exception {
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue("test.queue");
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage message = session.createTextMessage("test msg");
        long time = TimeUnit.SECONDS.toMillis(30L);
        message.setLongProperty("AMQ_SCHEDULED_DELAY", time);
        message.setIntProperty("AMQ_SCHEDULED_REPEAT", 0);
        producer.send((Message)message);
        producer.close();
    }

    protected JobSchedulerStoreImpl createScheduler() {
        JobSchedulerStoreImpl scheduler = new JobSchedulerStoreImpl();
        scheduler.setDirectory(this.schedulerStoreDir);
        scheduler.setJournalMaxFileLength(10240);
        return scheduler;
    }

    protected BrokerService createBroker(JobSchedulerStoreImpl scheduler) throws Exception {
        BrokerService answer = new BrokerService();
        answer.setJobSchedulerStore((JobSchedulerStore)scheduler);
        answer.setPersistent(true);
        answer.setDataDirectory(this.storeDir.getAbsolutePath());
        answer.setSchedulerSupport(true);
        answer.setUseJmx(false);
        return answer;
    }

    static {
        try {
            ProtectionDomain protectionDomain = SchedulerDBVersionTest.class.getProtectionDomain();
            basedir = new File(new File(protectionDomain.getCodeSource().getLocation().getPath()), "../.").getCanonicalPath();
        }
        catch (IOException e) {
            basedir = ".";
        }
    }
}

