/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.DefaultTestAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ3567Test {
    private static Logger logger = LoggerFactory.getLogger(AMQ3567Test.class);
    private ActiveMQConnectionFactory factory;
    private Connection connection;
    private Session sessionWithListener;
    private Session session;
    private Queue destination;
    private MessageConsumer consumer;
    private Thread thread;
    private BrokerService broker;
    private String connectionUri;

    @Before
    public void setUp() throws Exception {
        this.startBroker();
        this.initializeConsumer();
        this.startConsumer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void runTest() throws Exception {
        this.produceSingleMessage();
        org.apache.log4j.Logger log4jLogger = org.apache.log4j.Logger.getLogger((String)"org.apache.activemq.util.ServiceSupport");
        final AtomicBoolean failed = new AtomicBoolean(false);
        DefaultTestAppender appender = new DefaultTestAppender(){

            public void doAppend(LoggingEvent event) {
                InterruptedException ie;
                if (event.getThrowableInformation() != null && event.getThrowableInformation().getThrowable() instanceof InterruptedException && (ie = (InterruptedException)event.getThrowableInformation().getThrowable()).getMessage().startsWith("Could not stop service:")) {
                    logger.info("Received an interrupted exception : ", (Throwable)ie);
                    failed.set(true);
                }
            }
        };
        log4jLogger.addAppender((Appender)appender);
        Level level = log4jLogger.getLevel();
        log4jLogger.setLevel(Level.DEBUG);
        try {
            this.stopConsumer();
            this.stopBroker();
            if (failed.get()) {
                Assert.fail((String)"An Interrupt exception was generated");
            }
        }
        finally {
            log4jLogger.setLevel(level);
            log4jLogger.removeAppender((Appender)appender);
        }
    }

    private void startBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDataDirectory("target/data");
        this.connectionUri = this.broker.addConnector("tcp://localhost:0?wireFormat.maxInactivityDuration=30000&transport.closeAsync=false&transport.threadName&soTimeout=60000&transport.keepAlive=false&transport.useInactivityMonitor=false").getPublishableConnectString();
        this.broker.start(true);
        this.broker.waitUntilStarted();
    }

    private void stopBroker() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    private void initializeConsumer() throws JMSException {
        logger.info("Initializing the consumer messagor that will just not do anything....");
        this.factory = new ActiveMQConnectionFactory();
        this.factory.setBrokerURL("failover:(" + this.connectionUri + "?wireFormat.maxInactivityDuration=30000&keepAlive=true&soTimeout=60000)?jms.watchTopicAdvisories=false&jms.useAsyncSend=false&jms.dispatchAsync=true&jms.producerWindowSize=10485760&jms.copyMessageOnSend=false&jms.disableTimeStampsByDefault=true&InitialReconnectDelay=1000&maxReconnectDelay=10000&maxReconnectAttempts=400&useExponentialBackOff=true");
        this.connection = this.factory.createConnection();
        this.connection.start();
        this.sessionWithListener = this.connection.createSession(false, 1);
        this.session = this.connection.createSession(false, 1);
        this.destination = this.sessionWithListener.createQueue("EMPTY.QUEUE");
    }

    private void startConsumer() throws Exception {
        logger.info("Starting the consumer");
        this.consumer = this.sessionWithListener.createConsumer((Destination)this.destination);
        this.consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                logger.info("Received a message: " + message);
            }
        });
        this.thread = new Thread(new Runnable(){
            private Session session;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AMQ3567Test.this.destination = this.session.createQueue("EMPTY.QUEUE");
                    MessageConsumer consumer = this.session.createConsumer((Destination)AMQ3567Test.this.destination);
                    for (int cnt = 0; cnt < 2; ++cnt) {
                        Message message = consumer.receive(50000L);
                        logger.info("Received message: " + message);
                    }
                }
                catch (JMSException e) {
                    logger.debug("Received an exception while processing messages", (Throwable)e);
                }
                finally {
                    try {
                        this.session.close();
                    }
                    catch (JMSException e) {
                        logger.debug("Received an exception while closing session", (Throwable)e);
                    }
                }
            }

            public Runnable setSession(Session session) {
                this.session = session;
                return this;
            }
        }.setSession(this.session)){
            {
                this.start();
            }
        };
    }

    private void stopConsumer() throws JMSException {
        logger.info("Stopping the consumer");
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            logger.debug("Received an exception while waiting for thread to complete", (Throwable)e);
        }
        if (this.sessionWithListener != null) {
            this.sessionWithListener.close();
        }
        if (this.connection != null) {
            this.connection.stop();
        }
    }

    private void produceSingleMessage() throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        factory.setBrokerURL(this.connectionUri);
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue("EMPTY.QUEUE");
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.send((Message)session.createTextMessage("Single Message"));
        producer.close();
        session.close();
        connection.close();
    }
}

