/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.Map;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.command.ActiveMQQueue;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ4530Test {
    private static BrokerService brokerService;
    private static String TEST_QUEUE;
    private static ActiveMQQueue queue;
    private static String BROKER_ADDRESS;
    private static String KEY;
    private static String VALUE;
    private ActiveMQConnectionFactory connectionFactory;
    private String connectionUri;

    @Before
    public void setUp() throws Exception {
        brokerService = new BrokerService();
        brokerService.setPersistent(false);
        brokerService.setUseJmx(true);
        this.connectionUri = brokerService.addConnector(BROKER_ADDRESS).getPublishableConnectString();
        brokerService.start();
        brokerService.waitUntilStarted();
        this.connectionFactory = new ActiveMQConnectionFactory(this.connectionUri);
        this.sendMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage() throws Exception {
        try (Connection conn = this.connectionFactory.createConnection();){
            conn.start();
            Session session = conn.createSession(false, 1);
            Queue queue = session.createQueue(TEST_QUEUE);
            Message toSend = session.createMessage();
            toSend.setStringProperty(KEY, VALUE);
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Destination)queue, toSend);
        }
    }

    @After
    public void tearDown() throws Exception {
        brokerService.stop();
        brokerService.waitUntilStopped();
    }

    @Test
    public void testStringPropertiesFromCompositeData() throws Exception {
        QueueViewMBean queueView = this.getProxyToQueueViewMBean();
        CompositeData message = queueView.browse()[0];
        Assert.assertNotNull((Object)message);
        TabularDataSupport stringProperties = (TabularDataSupport)message.get("StringProperties");
        Assert.assertNotNull((Object)stringProperties);
        Assert.assertThat((Object)stringProperties.size(), (Matcher)Is.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Map.Entry compositeDataEntry = (Map.Entry)stringProperties.entrySet().toArray()[0];
        CompositeData stringEntry = (CompositeData)compositeDataEntry.getValue();
        Assert.assertThat((Object)String.valueOf(stringEntry.get("key")), (Matcher)Matchers.equalTo((Object)KEY));
        Assert.assertThat((Object)String.valueOf(stringEntry.get("value")), (Matcher)Matchers.equalTo((Object)VALUE));
    }

    private QueueViewMBean getProxyToQueueViewMBean() throws MalformedObjectNameException, NullPointerException, JMSException {
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + queue.getQueueName());
        QueueViewMBean proxy = (QueueViewMBean)brokerService.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        return proxy;
    }

    static {
        TEST_QUEUE = "testQueue";
        queue = new ActiveMQQueue(TEST_QUEUE);
        BROKER_ADDRESS = "tcp://localhost:0";
        KEY = "testproperty";
        VALUE = "propvalue";
    }
}

